/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import org.refcodes.generator.Generator;
import org.refcodes.mixin.CharSetAccessor;
import org.refcodes.mixin.ColumnWidthAccessor;
import org.refcodes.textual.RandomTextMode;

public class RandomTextGenerartor
implements ColumnWidthAccessor.ColumnWidthBuilder<RandomTextGenerartor>,
ColumnWidthAccessor.ColumnWidthProperty,
Generator<String>,
CharSetAccessor.CharSetProperty,
CharSetAccessor.CharSetBuilder<RandomTextGenerartor> {
    private static final Random RND = new Random();
    private int _columnWidth = 64;
    private RandomTextMode _randomTextMode = RandomTextMode.ASCII;
    private char[] _charSet = null;

    @Override
    public RandomTextGenerartor withColumnWidth(int aColumnWidth) {
        this.setColumnWidth(aColumnWidth);
        return this;
    }

    @Override
    public void setColumnWidth(int aColumnWidth) {
        this._columnWidth = aColumnWidth;
    }

    @Override
    public int getColumnWidth() {
        return this._columnWidth;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public String next() {
        if (this._charSet != null) {
            return RandomTextGenerartor.asRandom(this._charSet, this._columnWidth, RND);
        }
        return RandomTextGenerartor.asRandom(this._randomTextMode.getCharSet(), this._columnWidth, RND);
    }

    public RandomTextMode getRandomTextMode() {
        return this._randomTextMode;
    }

    public void setRandomTextMode(RandomTextMode aRandomTextMode) {
        this._randomTextMode = aRandomTextMode;
        if (aRandomTextMode != null) {
            this._charSet = null;
        }
    }

    @Override
    public char[] getCharSet() {
        return this._charSet;
    }

    @Override
    public void setCharSet(char[] aCharSet) {
        this._charSet = aCharSet;
        if (aCharSet != null) {
            this._randomTextMode = null;
        }
    }

    @Override
    public RandomTextGenerartor withCharSet(char[] aCharSet) {
        this.setCharSet(aCharSet);
        return this;
    }

    public RandomTextGenerartor withRandomTextMode(RandomTextMode aRandomTextMode) {
        this.setRandomTextMode(aRandomTextMode);
        return this;
    }

    public static String asString(int aColumnWidth, RandomTextMode aRandomTextMode) {
        return RandomTextGenerartor.asRandom(aRandomTextMode.getCharSet(), aColumnWidth, RND);
    }

    public static String asString(int aColumnWidth) {
        return RandomTextGenerartor.asRandom(RandomTextMode.ALPHANUMERIC.getCharSet(), aColumnWidth, RND);
    }

    public static String asRandom(int aColumnWidth, char ... aCharSet) {
        return RandomTextGenerartor.asRandom(aCharSet, aColumnWidth, RND);
    }

    public static String asShuffled(char ... aCharSet) {
        ArrayList<Character> theChars = new ArrayList<Character>();
        for (char eChar : aCharSet) {
            theChars.add(Character.valueOf(eChar));
        }
        Collections.shuffle(theChars);
        StringBuilder theBuilder = new StringBuilder();
        Iterator iterator = theChars.iterator();
        while (iterator.hasNext()) {
            char eChar = ((Character)iterator.next()).charValue();
            theBuilder.append(eChar);
        }
        return theBuilder.toString();
    }

    public static String asShuffled(String aCharSet) {
        return RandomTextGenerartor.asShuffled(aCharSet.toCharArray());
    }

    private static String asRandom(char[] aCharSet, int aColumnWidth, Random aRndGenerator) {
        int theBound = aCharSet.length;
        char[] theRandom = new char[aColumnWidth];
        for (int i = 0; i < aColumnWidth; ++i) {
            theRandom[i] = aCharSet[aRndGenerator.nextInt(theBound)];
        }
        return new String(theRandom);
    }
}

