/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties.ext.obfuscation;

import org.refcodes.exception.BugException;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.properties.ImmutableProperties;
import org.refcodes.properties.ext.obfuscation.AbstractImmutableObfuscationPropertiesDecorator;
import org.refcodes.runtime.SystemContext;
import org.refcodes.security.DecryptionException;
import org.refcodes.security.alt.chaos.ChaosKey;
import org.refcodes.security.alt.chaos.ChaosTextDecrypter;
import org.refcodes.textual.SecretHintBuilder;

public class UnmodifyableObfuscationProperties
extends AbstractImmutableObfuscationPropertiesDecorator<ImmutableProperties> {
    private ChaosKey _chaosKey;

    public UnmodifyableObfuscationProperties(ImmutableProperties aProperties) {
        this(aProperties, SystemContext.HOST.toContextString());
    }

    public UnmodifyableObfuscationProperties(ImmutableProperties aProperties, String aDecryptPrefix, String aEncryptPrefix) {
        this(aProperties, aDecryptPrefix, aEncryptPrefix, SystemContext.HOST.toContextString());
    }

    public UnmodifyableObfuscationProperties(ImmutableProperties aProperties, String aDecryptPrefix, String aEncryptPrefix, SystemContext aObfuscationMode) {
        this(aProperties, aDecryptPrefix, aEncryptPrefix, aObfuscationMode.toContextString());
    }

    public UnmodifyableObfuscationProperties(ImmutableProperties aProperties, String aDecryptPrefix, String aEncryptPrefix, String aSecret) {
        super(aProperties, aDecryptPrefix, aEncryptPrefix);
        int[] theIds = NumericalUtility.toHashCodes(aSecret, 3);
        this._chaosKey = new ChaosKey(theIds[0], theIds[1], theIds[2]);
    }

    public UnmodifyableObfuscationProperties(ImmutableProperties aProperties, SystemContext aObfuscationMode) {
        this(aProperties, aObfuscationMode.toContextString());
    }

    public UnmodifyableObfuscationProperties(ImmutableProperties aProperties, String aSecret) {
        super(aProperties);
        int[] theIds = NumericalUtility.toHashCodes(aSecret, 3);
        this._chaosKey = new ChaosKey(theIds[0], theIds[1], theIds[2]);
    }

    @Override
    protected String toDecrypted(String aValue) {
        try {
            return new ChaosTextDecrypter(this._chaosKey).toDecrypted(aValue);
        }
        catch (DecryptionException e) {
            throw new BugException("Encountered a bug while decrypting value <" + SecretHintBuilder.asString(aValue) + "> with <" + String.valueOf((Object)SystemContext.HOST_USER_APPLICATION_SESSION) + "> system context!", e);
        }
    }
}

