/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.data;

import org.refcodes.mixin.TimeMillisAccessor;

public enum IoTimeout implements TimeMillisAccessor
{
    MIN(5000),
    NORM(15000),
    MAX(30000);

    public static final int TIMEOUT_DIVIDER = 64;
    private int _value;

    private IoTimeout(int aValue) {
        this._value = aValue;
    }

    @Override
    public int getTimeMillis() {
        return this._value;
    }

    public static long toTimeoutSleepLoopTimeInMs(long aIoTimeoutInMs) {
        long thePollTimeInMs = aIoTimeoutInMs / 64L;
        if (thePollTimeInMs < 50L) {
            thePollTimeInMs = 50L;
        }
        return thePollTimeInMs;
    }

    public static long toSenseTimeoutTimeframeInMs(long aIoTimeoutInMs) {
        return aIoTimeoutInMs * 8L / 10L;
    }
}

