/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import org.refcodes.audio.AbstractWavAmplitudeWriter;
import org.refcodes.audio.BitsPerAmplitude;
import org.refcodes.audio.SamplingRate;
import org.refcodes.audio.SoundAmplitude;
import org.refcodes.audio.SoundAmplitudeBuilder;
import org.refcodes.audio.SoundAmplitudeBuilderImpl;
import org.refcodes.audio.SoundAmplitudeWriter;
import org.refcodes.numerical.NumericalUtility;

public class WavSoundAmplitudeWriter
extends AbstractWavAmplitudeWriter<SoundAmplitude, WavSoundAmplitudeWriter>
implements SoundAmplitudeWriter<WavSoundAmplitudeWriter> {
    private final SoundAmplitudeBuilder _soundSample = new SoundAmplitudeBuilderImpl(0L, SamplingRate.AUDIO_CD.getSamplesPerSecond());
    private boolean _hasHeader = false;

    public WavSoundAmplitudeWriter(File aFile) throws FileNotFoundException {
        super(aFile);
    }

    public WavSoundAmplitudeWriter(OutputStream aOutputStream) {
        super(aOutputStream);
    }

    @Override
    public WavSoundAmplitudeWriter withBitsPerAmplitude(BitsPerAmplitude aBitsPerAmplitude) {
        this.setBitsPerAmplitude(aBitsPerAmplitude);
        return this;
    }

    @Override
    public void writeNext(double ... aAmplitudeData) throws IOException {
        if (aAmplitudeData == null || aAmplitudeData.length == 0) {
            throw new IllegalArgumentException("You must provide at least one sample value, bit you provided " + (aAmplitudeData == null ? "<null>" : " an empty array") + "!");
        }
        this._soundSample.setSampleData(aAmplitudeData);
        this._soundSample.updateTimeStamp();
        this.writeNext(this._soundSample);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeNext(SoundAmplitude aAmplitude) throws IOException {
        if (!this._hasHeader) {
            WavSoundAmplitudeWriter wavSoundAmplitudeWriter = this;
            synchronized (wavSoundAmplitudeWriter) {
                if (!this._hasHeader) {
                    if (aAmplitude.getSamplingRate() > 0) {
                        this.setSamplingRate(aAmplitude.getSamplingRate());
                    }
                    this.writeHeader(this.getSamplingRate(), aAmplitude.getChannelCount());
                    this._hasHeader = true;
                }
            }
        }
        for (int i = 0; i < aAmplitude.getChannelCount(); ++i) {
            double eSampleData = aAmplitude.getSampleData()[i];
            byte[] eBytes = NumericalUtility.toLittleEndianBytes(this.toWavSample(eSampleData), this.getBitsPerAmplitude().getByteCount());
            this._outputStream.write(eBytes);
        }
        this._soundSample.increaseIndex();
    }

    @Override
    public int getSamplingRate() {
        return this._soundSample.getSamplingRate();
    }

    @Override
    public void setSamplingRate(int aSamplingRate) {
        if (aSamplingRate != -1 && aSamplingRate != this._soundSample.getSamplingRate()) {
            this._soundSample.setSamplingRate(aSamplingRate);
        }
    }

    @Override
    public WavSoundAmplitudeWriter withSamplingRate(int aSamplingRate) {
        this.setSamplingRate(aSamplingRate);
        return this;
    }
}

