/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import org.refcodes.audio.AbstractWavAmplitudeWriter;
import org.refcodes.audio.BitsPerAmplitude;
import org.refcodes.audio.MonoAmplitude;
import org.refcodes.audio.MonoAmplitudeBuilder;
import org.refcodes.audio.MonoAmplitudeBuilderImpl;
import org.refcodes.audio.MonoAmplitudeWriter;
import org.refcodes.audio.SamplingRate;
import org.refcodes.numerical.NumericalUtility;

public class WavMonoAmplitudeWriter
extends AbstractWavAmplitudeWriter<MonoAmplitude, WavMonoAmplitudeWriter>
implements MonoAmplitudeWriter<WavMonoAmplitudeWriter> {
    private final MonoAmplitudeBuilder _soundSample = new MonoAmplitudeBuilderImpl(0L, SamplingRate.AUDIO_CD.getSamplesPerSecond());
    private boolean _hasHeader = false;

    public WavMonoAmplitudeWriter(File aFile) throws FileNotFoundException {
        super(aFile);
    }

    public WavMonoAmplitudeWriter(OutputStream aOutputStream) {
        super(aOutputStream);
    }

    public WavMonoAmplitudeWriter(File aFile, BitsPerAmplitude aBitsPerAmplitude) throws FileNotFoundException {
        super(aFile);
        this.setBitsPerAmplitude(aBitsPerAmplitude);
    }

    public WavMonoAmplitudeWriter(OutputStream aOutputStream, BitsPerAmplitude aBitsPerAmplitude) {
        super(aOutputStream);
        this.setBitsPerAmplitude(aBitsPerAmplitude);
    }

    @Override
    public WavMonoAmplitudeWriter withBitsPerAmplitude(BitsPerAmplitude aBitsPerAmplitude) {
        this.setBitsPerAmplitude(aBitsPerAmplitude);
        return this;
    }

    @Override
    public void writeNext(double aSampleData) throws IOException {
        this._soundSample.setMonoData(aSampleData);
        this._soundSample.updateTimeStamp();
        this.writeNext(this._soundSample);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeNext(MonoAmplitude aSample) throws IOException {
        if (!this._hasHeader) {
            WavMonoAmplitudeWriter wavMonoAmplitudeWriter = this;
            synchronized (wavMonoAmplitudeWriter) {
                if (!this._hasHeader) {
                    if (aSample.getSamplingRate() > 0) {
                        this.setSamplingRate(aSample.getSamplingRate());
                    }
                    this.writeHeader(this.getSamplingRate(), 1);
                    this._hasHeader = true;
                }
            }
        }
        double theValue = this.toWavSample(aSample.getMonoData());
        byte[] eBytes = NumericalUtility.toLittleEndianBytes((long)theValue, this.getBitsPerAmplitude().getByteCount());
        this._outputStream.write(eBytes);
        this._soundSample.increaseIndex();
    }

    @Override
    public int getSamplingRate() {
        return this._soundSample.getSamplingRate();
    }

    @Override
    public void setSamplingRate(int aSamplingRate) {
        if (aSamplingRate != -1 && aSamplingRate != this._soundSample.getSamplingRate()) {
            this._soundSample.setSamplingRate(aSamplingRate);
        }
    }

    @Override
    public WavMonoAmplitudeWriter withSamplingRate(int aSamplingRate) {
        this.setSamplingRate(aSamplingRate);
        return this;
    }
}

