/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.refcodes.audio.AbstractSvgAmplitudeWriter;
import org.refcodes.audio.MonoAmplitude;
import org.refcodes.audio.MonoAmplitudeBuilder;
import org.refcodes.audio.MonoAmplitudeBuilderImpl;
import org.refcodes.audio.MonoAmplitudeWriter;
import org.refcodes.audio.SamplingRate;

public class SvgMonoAmplitudeWriter
extends AbstractSvgAmplitudeWriter<MonoAmplitude, SvgMonoAmplitudeWriter>
implements MonoAmplitudeWriter<SvgMonoAmplitudeWriter> {
    private static final int Y_SCALE_FACTOR = 500;
    private final MonoAmplitudeBuilder _soundSample = new MonoAmplitudeBuilderImpl(0L, SamplingRate.AUDIO_CD.getSamplesPerSecond());
    private boolean _hasHeader = false;
    private boolean _isFirst = true;

    public SvgMonoAmplitudeWriter(File aFile) throws FileNotFoundException {
        super(aFile);
    }

    public SvgMonoAmplitudeWriter(OutputStream aOutputStream) {
        super(aOutputStream);
    }

    public SvgMonoAmplitudeWriter(PrintStream aPrintStream) {
        super(aPrintStream);
    }

    @Override
    public void writeNext(double aAmplitudeData) {
        this._soundSample.setMonoData(aAmplitudeData);
        this._soundSample.updateTimeStamp();
        this.writeNext(this._soundSample);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeNext(MonoAmplitude aAmplitude) {
        if (!this._hasHeader) {
            SvgMonoAmplitudeWriter svgMonoAmplitudeWriter = this;
            synchronized (svgMonoAmplitudeWriter) {
                if (!this._hasHeader) {
                    this.writeSvgHeader();
                    this._printStream.print("\t<polyline points=\"");
                    this._hasHeader = true;
                }
            }
        }
        if (aAmplitude != this._soundSample) {
            this._soundSample.setMonoData(aAmplitude.getMonoData());
            if (aAmplitude.getSamplingRate() != -1 && aAmplitude.getSamplingRate() != this._soundSample.getSamplingRate()) {
                this._soundSample.setSamplingRate(aAmplitude.getSamplingRate());
            }
            if (aAmplitude.getIndex() != -1L) {
                this._soundSample.setIndex(aAmplitude.getIndex());
            }
            if (aAmplitude.getTimeStamp() != -1.0) {
                this._soundSample.setTimeStamp(aAmplitude.getTimeStamp());
            }
        }
        if (!this._isFirst) {
            this._printStream.print(" " + SvgMonoAmplitudeWriter.toString(this._soundSample.getIndex()) + "," + SvgMonoAmplitudeWriter.toString(this.toYCoordinate(this._soundSample.getMonoData(), 500.0)));
        } else {
            this._printStream.print(SvgMonoAmplitudeWriter.toString(this._soundSample.getIndex()) + "," + SvgMonoAmplitudeWriter.toString(this.toYCoordinate(this._soundSample.getMonoData(), 500.0)));
            this._isFirst = false;
        }
        this._soundSample.increaseIndex();
    }

    @Override
    public void close() throws IOException {
        this._printStream.println("\" style=\"fill:none;stroke:black;stroke-width:1\" >");
        this._printStream.println("\t\t<title>Mono</title>");
        this._printStream.println("\t</polyline>");
        super.close();
    }

    @Override
    public int getSamplingRate() {
        return this._soundSample.getSamplingRate();
    }

    @Override
    public void setSamplingRate(int aSamplingRate) {
        if (aSamplingRate != -1 && aSamplingRate != this._soundSample.getSamplingRate()) {
            this._soundSample.setSamplingRate(aSamplingRate);
        }
    }

    @Override
    public SvgMonoAmplitudeWriter withSamplingRate(int aSamplingRate) {
        this.setSamplingRate(aSamplingRate);
        return this;
    }
}

