/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.util.Arrays;
import org.refcodes.audio.SoundAmplitude;
import org.refcodes.audio.SoundAmplitudeBuilder;

public class SoundAmplitudeBuilderImpl
implements SoundAmplitudeBuilder {
    private double _timeStamp = -1.0;
    private int _sampligRate = -1;
    private double[] _sampleData = null;
    private long _index = -1L;

    public SoundAmplitudeBuilderImpl(SoundAmplitude aSoundAmplitude) {
        this._index = aSoundAmplitude.getIndex();
        this._timeStamp = aSoundAmplitude.getTimeStamp();
        this._sampligRate = aSoundAmplitude.getSamplingRate();
        if (aSoundAmplitude.getSampleData() != null) {
            this._sampleData = Arrays.copyOf(aSoundAmplitude.getSampleData(), aSoundAmplitude.getChannelCount());
        }
    }

    public SoundAmplitudeBuilderImpl(double[] aAmplitudeData) {
        this._sampleData = aAmplitudeData;
    }

    public SoundAmplitudeBuilderImpl(double aTimeMillis, double[] aAmplitudeData) {
        this._timeStamp = aTimeMillis;
        this._sampleData = aAmplitudeData;
    }

    public SoundAmplitudeBuilderImpl(double aTimeMillis, double[] aAmplitudeData, int aSamplingRate) {
        this._timeStamp = aTimeMillis;
        this._sampleData = aAmplitudeData;
        this._sampligRate = aSamplingRate;
    }

    public SoundAmplitudeBuilderImpl(double[] aAmplitudeData, int aSamplingRate) {
        this._sampleData = aAmplitudeData;
        this._sampligRate = aSamplingRate;
    }

    public SoundAmplitudeBuilderImpl(long aIndex, double[] aAmplitudeData) {
        this._index = aIndex;
        this._sampleData = aAmplitudeData;
    }

    public SoundAmplitudeBuilderImpl(long aIndex, double[] aAmplitudeData, int aSamplingRate) {
        this._index = aIndex;
        this._sampleData = aAmplitudeData;
        this._sampligRate = aSamplingRate;
    }

    public SoundAmplitudeBuilderImpl(long aIndex, double aTimeMillis, double[] aAmplitudeData) {
        this._index = aIndex;
        this._timeStamp = aTimeMillis;
        this._sampleData = aAmplitudeData;
    }

    public SoundAmplitudeBuilderImpl(long aIndex, double aTimeMillis, double[] aAmplitudeData, int aSamplingRate) {
        this._index = aIndex;
        this._timeStamp = aTimeMillis;
        this._sampleData = aAmplitudeData;
        this._sampligRate = aSamplingRate;
    }

    public SoundAmplitudeBuilderImpl(long aIndex, int aSamplingRate) {
        this._index = aIndex;
        this._sampligRate = aSamplingRate;
    }

    @Override
    public double[] getSampleData() {
        return this._sampleData;
    }

    @Override
    public double getTimeStamp() {
        return this._timeStamp;
    }

    @Override
    public int getSamplingRate() {
        return this._sampligRate;
    }

    @Override
    public long getIndex() {
        return this._index;
    }

    @Override
    public void setIndex(long aIndex) {
        this._index = aIndex;
    }

    @Override
    public void increaseIndex() {
        ++this._index;
    }

    @Override
    public void decreaseIndex() {
        --this._index;
    }

    @Override
    public void setSampleData(double[] aAmplitudeData) {
        this._sampleData = aAmplitudeData;
    }

    @Override
    public void setTimeStamp(double aTimeMillis) {
        this._timeStamp = aTimeMillis;
    }

    @Override
    public void setSamplingRate(int aSamplingRate) {
        this._sampligRate = aSamplingRate;
    }

    public String toString() {
        return "SoundAmplitudeBuilderImpl [index=" + this.getIndex() + ", timeStamp=" + this.getTimeStamp() + ", sampleData=" + Arrays.toString(this.getSampleData()) + ", sampligRate=" + this.getSamplingRate() + "]";
    }
}

