/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.util.Arrays;
import org.refcodes.audio.MonoAmplitude;
import org.refcodes.audio.MonoAmplitudeBuilder;

public class MonoAmplitudeBuilderImpl
implements MonoAmplitudeBuilder {
    private double _timeStamp = -1.0;
    private int _sampligRate = -1;
    private double[] _sampleData = new double[1];
    private long _index = -1L;

    public MonoAmplitudeBuilderImpl(MonoAmplitude aAmplitude) {
        this._index = aAmplitude.getIndex();
        this._timeStamp = aAmplitude.getTimeStamp();
        this._sampligRate = aAmplitude.getSamplingRate();
        if (aAmplitude.getSampleData() != null) {
            this._sampleData = Arrays.copyOf(aAmplitude.getSampleData(), aAmplitude.getChannelCount());
        }
    }

    public MonoAmplitudeBuilderImpl(double aAmplitude) {
        this._sampleData[0] = aAmplitude;
    }

    public MonoAmplitudeBuilderImpl(double aTimeMillis, double aAmplitude) {
        this._timeStamp = aTimeMillis;
        this._sampleData[0] = aAmplitude;
    }

    public MonoAmplitudeBuilderImpl(double aTimeMillis, double aAmplitude, int aSamplingRate) {
        this._timeStamp = aTimeMillis;
        this._sampleData[0] = aAmplitude;
        this._sampligRate = aSamplingRate;
    }

    public MonoAmplitudeBuilderImpl(double aAmplitude, int aSamplingRate) {
        this._sampleData[0] = aAmplitude;
        this._sampligRate = aSamplingRate;
    }

    public MonoAmplitudeBuilderImpl(long aIndex, double aAmplitude) {
        this._index = aIndex;
        this._sampleData[0] = aAmplitude;
    }

    public MonoAmplitudeBuilderImpl(long aIndex, double aAmplitude, int aSamplingRate) {
        this._index = aIndex;
        this._sampleData[0] = aAmplitude;
        this._sampligRate = aSamplingRate;
    }

    public MonoAmplitudeBuilderImpl(long aIndex, double aTimeMillis, double aAmplitude) {
        this._index = aIndex;
        this._timeStamp = aTimeMillis;
        this._sampleData[0] = aAmplitude;
    }

    public MonoAmplitudeBuilderImpl(long aIndex, double aTimeMillis, double aAmplitude, int aSamplingRate) {
        this._index = aIndex;
        this._timeStamp = aTimeMillis;
        this._sampleData[0] = aAmplitude;
        this._sampligRate = aSamplingRate;
    }

    public MonoAmplitudeBuilderImpl(long aIndex, int aSamplingRate) {
        this._index = aIndex;
        this._sampligRate = aSamplingRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMonoData(double aAmplitudeData) {
        if (this._sampleData == null || this._sampleData.length != 1) {
            MonoAmplitudeBuilderImpl monoAmplitudeBuilderImpl = this;
            synchronized (monoAmplitudeBuilderImpl) {
                if (this._sampleData == null || this._sampleData.length != 1) {
                    this._sampleData = new double[1];
                }
            }
        }
        this._sampleData[0] = aAmplitudeData;
    }

    @Override
    public double[] getSampleData() {
        return this._sampleData;
    }

    @Override
    public double getTimeStamp() {
        return this._timeStamp;
    }

    @Override
    public int getSamplingRate() {
        return this._sampligRate;
    }

    @Override
    public long getIndex() {
        return this._index;
    }

    @Override
    public void setIndex(long aIndex) {
        this._index = aIndex;
    }

    @Override
    public void increaseIndex() {
        ++this._index;
    }

    @Override
    public void decreaseIndex() {
        --this._index;
    }

    @Override
    public void setTimeStamp(double aTimeMillis) {
        this._timeStamp = aTimeMillis;
    }

    @Override
    public void setSamplingRate(int aSamplingRate) {
        this._sampligRate = aSamplingRate;
    }

    public String toString() {
        return "MonoAmplitudeBuilderImpl [index=" + this.getIndex() + ", timeStamp=" + this.getTimeStamp() + ", sampleData=" + this.getMonoData() + ", sampligRate=" + this.getSamplingRate();
    }
}

