/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.io.IOException;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.refcodes.audio.AbstractLineOutAmplitudeWriter;
import org.refcodes.audio.BitsPerAmplitude;
import org.refcodes.audio.SamplingRate;
import org.refcodes.audio.SoundAmplitude;
import org.refcodes.audio.SoundAmplitudeBuilder;
import org.refcodes.audio.SoundAmplitudeBuilderImpl;
import org.refcodes.audio.SoundAmplitudeWriter;
import org.refcodes.numerical.NumericalUtility;

public class LineOutSoundAmplitudeWriter
extends AbstractLineOutAmplitudeWriter<SoundAmplitude, LineOutSoundAmplitudeWriter>
implements SoundAmplitudeWriter<LineOutSoundAmplitudeWriter> {
    private final SoundAmplitudeBuilder _soundSample = new SoundAmplitudeBuilderImpl(0L, SamplingRate.AUDIO_CD.getSamplesPerSecond());
    private SourceDataLine _lineOut = null;

    @Override
    public LineOutSoundAmplitudeWriter withBitsPerAmplitude(BitsPerAmplitude aBitsPerAmplitude) {
        this.setBitsPerAmplitude(aBitsPerAmplitude);
        return this;
    }

    @Override
    public void writeNext(double ... aAmplitudeData) throws IOException {
        if (aAmplitudeData == null || aAmplitudeData.length == 0) {
            throw new IllegalArgumentException("You must provide at least one sample value, bit you provided " + (aAmplitudeData == null ? "<null>" : " an empty array") + "!");
        }
        this._soundSample.setSampleData(aAmplitudeData);
        this._soundSample.updateTimeStamp();
        this.writeNext(this._soundSample);
    }

    @Override
    public void writeNext(SoundAmplitude aAmplitude) throws IOException {
        if (aAmplitude != this._soundSample) {
            if (aAmplitude.getIndex() != -1L) {
                this._soundSample.setIndex(aAmplitude.getIndex());
            }
            if (aAmplitude.getSamplingRate() != -1) {
                this._soundSample.setSamplingRate(aAmplitude.getSamplingRate());
            }
            if (aAmplitude.getTimeStamp() != -1.0) {
                this._soundSample.setTimeStamp(aAmplitude.getTimeStamp());
            } else {
                this._soundSample.updateTimeStamp();
            }
            this._soundSample.setSampleData(aAmplitude.getSampleData());
        }
        for (int i = 0; i < this._soundSample.getChannelCount(); ++i) {
            long eValue = this.toWavSample(this._soundSample.getSampleData()[i]);
            byte[] eBytes = NumericalUtility.toBigEndianBytes(eValue, this._bitsPerSample.getByteCount());
            try {
                SourceDataLine theLineOut = this.getLineOut();
                while (theLineOut.getBufferSize() < eBytes.length) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                theLineOut.write(eBytes, 0, eBytes.length);
                continue;
            }
            catch (LineUnavailableException e) {
                throw new IOException("The audio-out line" + (String)(this._lineOut != null ? " <" + this._lineOut.toString() + ">" : "") + " is unavailable!", e);
            }
        }
        this._soundSample.increaseIndex();
    }

    @Override
    public int getSamplingRate() {
        return this._soundSample.getSamplingRate();
    }

    @Override
    public void setSamplingRate(int aSamplingRate) {
        if (aSamplingRate != -1 && aSamplingRate != this._soundSample.getSamplingRate()) {
            this._soundSample.setSamplingRate(aSamplingRate);
        }
    }

    @Override
    public LineOutSoundAmplitudeWriter withSamplingRate(int aSamplingRate) {
        this.setSamplingRate(aSamplingRate);
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this._lineOut != null) {
            this._lineOut.stop();
            this._lineOut.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SourceDataLine getLineOut() throws LineUnavailableException {
        if (this._lineOut == null) {
            LineOutSoundAmplitudeWriter lineOutSoundAmplitudeWriter = this;
            synchronized (lineOutSoundAmplitudeWriter) {
                if (this._lineOut == null) {
                    this._lineOut = LineOutSoundAmplitudeWriter.toLineOut(this._soundSample, this._bitsPerSample);
                }
            }
        }
        return this._lineOut;
    }

    public void open(int aChannelCount, BitsPerAmplitude aBitsPerAmplitude, int aSamplingRate) throws IOException {
        if (this._lineOut == null) {
            try {
                this._bitsPerSample = aBitsPerAmplitude;
                this._soundSample.setSamplingRate(aSamplingRate);
                double[] theSilence = new double[aChannelCount];
                this._lineOut = LineOutSoundAmplitudeWriter.toLineOut(aChannelCount, this._soundSample.getSamplingRate(), this._bitsPerSample);
                int theSilentSamples = this._lineOut.available() > this._soundSample.getSamplingRate() ? this._lineOut.available() : this._soundSample.getSamplingRate();
                for (int i = 0; i < theSilentSamples; ++i) {
                    this.writeNext(theSilence);
                }
            }
            catch (LineUnavailableException e) {
                throw new IOException("The audio-out line" + (String)(this._lineOut != null ? " <" + this._lineOut.toString() + ">" : "") + " is unavailable!", e);
            }
        }
    }

    public LineOutSoundAmplitudeWriter withOpen(int aChannelCount, BitsPerAmplitude aBitsPerAmplitude, int aSamplingRate) throws IOException {
        this.open(aChannelCount, aBitsPerAmplitude, aSamplingRate);
        return this;
    }
}

