/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.io.IOException;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.refcodes.audio.AbstractLineOutAmplitudeWriter;
import org.refcodes.audio.BitsPerAmplitude;
import org.refcodes.audio.MonoAmplitude;
import org.refcodes.audio.MonoAmplitudeBuilder;
import org.refcodes.audio.MonoAmplitudeBuilderImpl;
import org.refcodes.audio.MonoAmplitudeWriter;
import org.refcodes.audio.SamplingRate;
import org.refcodes.numerical.NumericalUtility;

public class LineOutMonoAmplitudeWriter
extends AbstractLineOutAmplitudeWriter<MonoAmplitude, LineOutMonoAmplitudeWriter>
implements MonoAmplitudeWriter<LineOutMonoAmplitudeWriter> {
    private final MonoAmplitudeBuilder _soundSample = new MonoAmplitudeBuilderImpl(0L, SamplingRate.AUDIO_CD.getSamplesPerSecond());
    private SourceDataLine _lineOut = null;

    public LineOutMonoAmplitudeWriter() {
    }

    public LineOutMonoAmplitudeWriter(BitsPerAmplitude aBitsPerAmplitude) {
        this.setBitsPerAmplitude(aBitsPerAmplitude);
    }

    @Override
    public LineOutMonoAmplitudeWriter withBitsPerAmplitude(BitsPerAmplitude aBitsPerAmplitude) {
        this.setBitsPerAmplitude(aBitsPerAmplitude);
        return this;
    }

    @Override
    public void writeNext(double aAmplitudeData) throws IOException {
        this._soundSample.setMonoData(aAmplitudeData);
        this._soundSample.updateTimeStamp();
        this.writeNext(this._soundSample);
    }

    @Override
    public void writeNext(MonoAmplitude aAmplitude) throws IOException {
        if (aAmplitude != this._soundSample) {
            if (aAmplitude.getIndex() != -1L) {
                this._soundSample.setIndex(aAmplitude.getIndex());
            }
            if (aAmplitude.getSamplingRate() != -1) {
                this._soundSample.setSamplingRate(aAmplitude.getSamplingRate());
            }
            if (aAmplitude.getTimeStamp() != -1.0) {
                this._soundSample.setTimeStamp(aAmplitude.getTimeStamp());
            } else {
                this._soundSample.updateTimeStamp();
            }
            this._soundSample.setMonoData(aAmplitude.getMonoData());
        }
        long eValue = this.toWavSample(this._soundSample.getMonoData());
        byte[] eBytes = NumericalUtility.toBigEndianBytes(eValue, this._soundSample.getChannelCount() * this._bitsPerSample.getByteCount());
        try {
            SourceDataLine theLineOut = this.getLineOut();
            while (theLineOut.getBufferSize() < eBytes.length) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            theLineOut.write(eBytes, 0, eBytes.length);
        }
        catch (LineUnavailableException e) {
            throw new IOException("The audio-out line" + (String)(this._lineOut != null ? " <" + this._lineOut.toString() + ">" : "") + " is unavailable!", e);
        }
        this._soundSample.increaseIndex();
    }

    @Override
    public int getSamplingRate() {
        return this._soundSample.getSamplingRate();
    }

    @Override
    public void setSamplingRate(int aSamplingRate) {
        if (aSamplingRate != -1 && aSamplingRate != this._soundSample.getSamplingRate()) {
            this._soundSample.setSamplingRate(aSamplingRate);
        }
    }

    @Override
    public LineOutMonoAmplitudeWriter withSamplingRate(int aSamplingRate) {
        this.setSamplingRate(aSamplingRate);
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this._lineOut != null) {
            this._lineOut.stop();
            this._lineOut.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SourceDataLine getLineOut() throws LineUnavailableException {
        if (this._lineOut == null) {
            LineOutMonoAmplitudeWriter lineOutMonoAmplitudeWriter = this;
            synchronized (lineOutMonoAmplitudeWriter) {
                if (this._lineOut == null) {
                    this._lineOut = LineOutMonoAmplitudeWriter.toLineOut(this._soundSample, this._bitsPerSample);
                }
            }
        }
        return this._lineOut;
    }

    public void open(BitsPerAmplitude aBitsPerAmplitude, int aSamplingRate) throws IOException {
        if (this._lineOut == null) {
            try {
                this._bitsPerSample = aBitsPerAmplitude;
                this._soundSample.setSamplingRate(aSamplingRate);
                this._lineOut = LineOutMonoAmplitudeWriter.toLineOut(1, this._soundSample.getSamplingRate(), this._bitsPerSample);
                int theSilentSamples = this._lineOut.available() > this._soundSample.getSamplingRate() ? this._lineOut.available() : this._soundSample.getSamplingRate();
                for (int i = 0; i < theSilentSamples; ++i) {
                    this.writeNext(0.0);
                }
            }
            catch (LineUnavailableException e) {
                throw new IOException("The audio-out line" + (String)(this._lineOut != null ? " <" + this._lineOut.toString() + ">" : "") + " is unavailable!", e);
            }
        }
    }

    public LineOutMonoAmplitudeWriter withOpen(BitsPerAmplitude aBitsPerAmplitude, int aSamplingRate) throws IOException {
        this.open(aBitsPerAmplitude, aSamplingRate);
        return this;
    }
}

