/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.util.function.Function;
import org.refcodes.audio.CurveFunctionFunction;
import org.refcodes.audio.CurveFunctionSoundAmplitudeBuilder;
import org.refcodes.audio.MonoAmplitude;
import org.refcodes.audio.SamplingRate;

public class CurveFunctionSoundAmplitudeBuilderImpl
implements CurveFunctionSoundAmplitudeBuilder {
    private int _index = 0;
    private int _samplingRate = SamplingRate.AUDIO_CD.getSamplesPerSecond();
    private int _xOffset = 0;
    private double _yOffset = 0.0;
    private double _amplitude = 0.0;
    private double _frequencyInHz = 440.0;
    private Function<Double, Double> _trigonometricFunction = CurveFunctionFunction.SINE.getFunction();

    @Override
    public void setTrigonometricFunction(Function<Double, Double> aFunction) {
        this._trigonometricFunction = aFunction;
    }

    @Override
    public Function<Double, Double> getTrigonometricFunction() {
        return this._trigonometricFunction;
    }

    @Override
    public void setIndex(int aIndex) {
        this._index = aIndex;
    }

    @Override
    public int getIndex() {
        return this._index;
    }

    @Override
    public void setFrequency(double aFrequencyInHz) {
        this._frequencyInHz = aFrequencyInHz;
    }

    @Override
    public double getFrequency() {
        return this._frequencyInHz;
    }

    @Override
    public void setAmplitude(double aAmplitude) {
        this._amplitude = aAmplitude;
    }

    @Override
    public double getAmplitude() {
        return this._amplitude;
    }

    @Override
    public void setXOffset(int aXOffset) {
        this._xOffset = aXOffset;
    }

    @Override
    public int getXOffset() {
        return this._xOffset;
    }

    @Override
    public void setYOffset(double aYOffset) {
        this._yOffset = aYOffset;
    }

    @Override
    public double getYOffset() {
        return this._yOffset;
    }

    @Override
    public void setSamplingRate(int aSamplingRate) {
        this._samplingRate = aSamplingRate;
    }

    @Override
    public int getSamplingRate() {
        return this._samplingRate;
    }

    @Override
    public MonoAmplitude next() {
        MonoAmplitude theSample = this.toMonoSample();
        ++this._index;
        return theSample;
    }

    @Override
    public MonoAmplitude toMonoSample() {
        return CurveFunctionSoundAmplitudeBuilder.asMonoSample(this._index, this._trigonometricFunction, this._frequencyInHz, this._amplitude, this._xOffset, this._yOffset, this._samplingRate);
    }

    @Override
    public MonoAmplitude toMonoSample(int index) {
        return CurveFunctionSoundAmplitudeBuilder.asMonoSample(index, this._trigonometricFunction, this._frequencyInHz, this._amplitude, this._xOffset, this._yOffset, this._samplingRate);
    }
}

