/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.util.function.Function;
import org.refcodes.audio.CurveFunctionFunction;
import org.refcodes.audio.CurveFunctionSoundAmplitudeBuilderImpl;
import org.refcodes.audio.MonoAmplitude;
import org.refcodes.audio.MonoAmplitudeBuilder;
import org.refcodes.audio.MonoAmplitudeBuilderImpl;
import org.refcodes.audio.SamplingRateAccessor;

public interface CurveFunctionSoundAmplitudeBuilder
extends SamplingRateAccessor.SamplingRateProperty,
SamplingRateAccessor.SamplingRateBuilder<CurveFunctionSoundAmplitudeBuilder> {
    public void setTrigonometricFunction(Function<Double, Double> var1);

    public Function<Double, Double> getTrigonometricFunction();

    default public CurveFunctionSoundAmplitudeBuilder withTrigonometricFunction(Function<Double, Double> aFunction) {
        this.setTrigonometricFunction(aFunction);
        return this;
    }

    default public void setTrigonometricFunction(CurveFunctionFunction aFunction) {
        this.setTrigonometricFunction(aFunction.getFunction());
    }

    default public CurveFunctionSoundAmplitudeBuilder withTrigonometricFunction(CurveFunctionFunction aFunction) {
        this.setTrigonometricFunction(aFunction.getFunction());
        return this;
    }

    public void setIndex(int var1);

    public int getIndex();

    default public CurveFunctionSoundAmplitudeBuilder withIndex(int aIndex) {
        this.setIndex(aIndex);
        return this;
    }

    public void setFrequency(double var1);

    public double getFrequency();

    default public CurveFunctionSoundAmplitudeBuilder withFrequency(double aFrequencyInHz) {
        this.setFrequency(aFrequencyInHz);
        return this;
    }

    public void setAmplitude(double var1);

    public double getAmplitude();

    default public CurveFunctionSoundAmplitudeBuilder withAmplitude(double aAmplitude) {
        this.setAmplitude(aAmplitude);
        return this;
    }

    public void setXOffset(int var1);

    public int getXOffset();

    default public CurveFunctionSoundAmplitudeBuilder withXOffset(int aXOffset) {
        this.setXOffset(aXOffset);
        return this;
    }

    public void setYOffset(double var1);

    public double getYOffset();

    default public CurveFunctionSoundAmplitudeBuilder withYOffset(double aYOffset) {
        this.setYOffset(aYOffset);
        return this;
    }

    @Override
    default public CurveFunctionSoundAmplitudeBuilder withSamplingRate(int aSamplingRate) {
        this.setSamplingRate(aSamplingRate);
        return null;
    }

    public MonoAmplitude next();

    public MonoAmplitude toMonoSample();

    public MonoAmplitude toMonoSample(int var1);

    public static MonoAmplitudeBuilder asMonoSample(double aIndex, Function<Double, Double> aFunction, double aFrequencyHz, double aAmplitude, int aXOffset, double aYOffset, int aSamplingRate) {
        double theTime = aIndex / (double)aSamplingRate;
        double theSample = aFunction.apply(Math.PI * 2 * (aIndex - (double)aXOffset) * aFrequencyHz / (double)aSamplingRate);
        theSample *= aAmplitude;
        return new MonoAmplitudeBuilderImpl(theTime, theSample += aYOffset);
    }

    public static CurveFunctionSoundAmplitudeBuilder build() {
        return new CurveFunctionSoundAmplitudeBuilderImpl();
    }
}

