/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import org.refcodes.audio.AbstractCsvAmplitudeWriter;
import org.refcodes.audio.CsvDeltaMode;
import org.refcodes.audio.SamplingRate;
import org.refcodes.audio.SoundAmplitude;
import org.refcodes.audio.SoundAmplitudeBuilder;
import org.refcodes.audio.SoundAmplitudeBuilderImpl;
import org.refcodes.audio.SoundAmplitudeWriter;

public class CsvSoundAmplitudeWriter
extends AbstractCsvAmplitudeWriter<SoundAmplitude, CsvSoundAmplitudeWriter>
implements SoundAmplitudeWriter<CsvSoundAmplitudeWriter> {
    private final SoundAmplitudeBuilder _soundSample = new SoundAmplitudeBuilderImpl(0L, SamplingRate.AUDIO_CD.getSamplesPerSecond());
    private boolean _hasHeader = false;
    private boolean[] _isSampleDataDirty;
    private boolean _isSamplingRateDirty = true;

    public CsvSoundAmplitudeWriter(File aFile) throws FileNotFoundException {
        super(aFile);
    }

    public CsvSoundAmplitudeWriter(OutputStream aOutputStream) {
        super(aOutputStream);
    }

    public CsvSoundAmplitudeWriter(PrintStream aPrintStream) {
        super(aPrintStream);
    }

    public CsvSoundAmplitudeWriter(File aFile, CsvDeltaMode aDeltaMode) throws FileNotFoundException {
        super(aFile, aDeltaMode);
    }

    public CsvSoundAmplitudeWriter(OutputStream aOutputStream, CsvDeltaMode aDeltaMode) {
        super(aOutputStream, aDeltaMode);
    }

    public CsvSoundAmplitudeWriter(PrintStream aPrintStream, CsvDeltaMode aDeltaMode) {
        super(aPrintStream, aDeltaMode);
    }

    @Override
    public void writeNext(double ... aAmplitudeData) {
        if (aAmplitudeData == null || aAmplitudeData.length == 0) {
            throw new IllegalArgumentException("You must provide at least one sample value, bit you provided " + (aAmplitudeData == null ? "<null>" : " an empty array") + "!");
        }
        this.doUpdateSampleData(aAmplitudeData);
        this._soundSample.updateTimeStamp();
        this.writeNext(this._soundSample);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeNext(SoundAmplitude aAmplitude) {
        double[] theSample = aAmplitude.getSampleData();
        String[] theRow = new String[theSample.length + 3];
        if (!this._hasHeader) {
            CsvSoundAmplitudeWriter csvSoundAmplitudeWriter = this;
            synchronized (csvSoundAmplitudeWriter) {
                if (!this._hasHeader) {
                    theRow[0] = "index";
                    theRow[1] = "time_stamp";
                    if (theSample.length > 1) {
                        for (int i = 0; i < theSample.length; ++i) {
                            theRow[i + 2] = "channel_" + i;
                        }
                    } else {
                        theRow[2] = "sample_data";
                    }
                    theRow[theRow.length - 1] = "sampling_rate";
                    this._csvWriter.writeHeader(theRow);
                    this._hasHeader = true;
                }
            }
        }
        if (aAmplitude != this._soundSample) {
            this.doUpdateSampleData(aAmplitude.getSampleData());
            if (aAmplitude.getSamplingRate() != -1 && aAmplitude.getSamplingRate() != this._soundSample.getSamplingRate()) {
                this._soundSample.setSamplingRate(aAmplitude.getSamplingRate());
                this._isSamplingRateDirty = true;
            }
            if (aAmplitude.getIndex() != -1L) {
                this._soundSample.setIndex(aAmplitude.getIndex());
            }
            if (aAmplitude.getTimeStamp() != -1.0) {
                this._soundSample.setTimeStamp(aAmplitude.getTimeStamp());
            }
        }
        theRow[0] = Long.toString(this._soundSample.getIndex());
        theRow[1] = CsvSoundAmplitudeWriter.toString(this._soundSample.getTimeStamp());
        for (int i = 0; i < theSample.length; ++i) {
            if (this._deltaMode.isSampleDataDelta() && !this._isSampleDataDirty[i]) continue;
            theRow[i + 2] = CsvSoundAmplitudeWriter.toString(theSample[i]);
        }
        if (!this._deltaMode.isSamplingRateDelta() || this._isSamplingRateDirty) {
            theRow[theRow.length - 1] = Integer.toString(this._soundSample.getSamplingRate());
        }
        this._csvWriter.writeNext((T[])theRow);
        this._soundSample.increaseIndex();
        Arrays.fill(this._isSampleDataDirty, false);
        this._isSamplingRateDirty = false;
    }

    @Override
    public int getSamplingRate() {
        return this._soundSample.getSamplingRate();
    }

    @Override
    public void setSamplingRate(int aSamplingRate) {
        if (aSamplingRate != -1 && aSamplingRate != this._soundSample.getSamplingRate()) {
            this._soundSample.setSamplingRate(aSamplingRate);
            this._isSamplingRateDirty = true;
        }
    }

    @Override
    public CsvSoundAmplitudeWriter withSamplingRate(int aSamplingRate) {
        this.setSamplingRate(aSamplingRate);
        return this;
    }

    private void doUpdateSampleData(double ... aAmplitudeData) {
        if (this._isSampleDataDirty == null) {
            this._isSampleDataDirty = new boolean[aAmplitudeData.length];
            Arrays.fill(this._isSampleDataDirty, true);
        }
        double[] theSampleData = this._soundSample.getSampleData();
        for (int i = 0; i < aAmplitudeData.length; ++i) {
            if (theSampleData != null && theSampleData[i] == aAmplitudeData[i]) continue;
            this._isSampleDataDirty[i] = true;
        }
        this._soundSample.setSampleData(aAmplitudeData);
    }
}

