/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.refcodes.audio.AbstractCsvAmplitudeReader;
import org.refcodes.audio.CsvSoundAmplitudeWriter;
import org.refcodes.audio.SamplingRate;
import org.refcodes.audio.SoundAmplitude;
import org.refcodes.audio.SoundAmplitudeBuilderImpl;
import org.refcodes.audio.SoundAmplitudeImpl;
import org.refcodes.audio.SoundAmplitudeReader;
import org.refcodes.tabular.CsvStringRecordReader;

public class CsvSoundAmplitudeReader
extends AbstractCsvAmplitudeReader<SoundAmplitude>
implements SoundAmplitudeReader {
    private final SoundAmplitudeBuilderImpl _soundSample = new SoundAmplitudeBuilderImpl(0L, SamplingRate.AUDIO_CD.getSamplesPerSecond());

    public CsvSoundAmplitudeReader(File aFile) throws IOException {
        super(aFile);
    }

    public CsvSoundAmplitudeReader(InputStream aInputStream) throws IOException {
        super(aInputStream);
    }

    protected CsvSoundAmplitudeReader(CsvStringRecordReader aCsvReader) {
        super(aCsvReader);
    }

    @Override
    public SoundAmplitude nextRow() throws IOException {
        String theTimeStamp;
        this.doProbeHeader();
        Object theSampleCsv = this._csvReader.next();
        ArrayList<Double> theSamplingDatas = new ArrayList<Double>();
        if (theSampleCsv.containsKey("sample_data")) {
            eSampleDataCsv = (String)theSampleCsv.get("sample_data");
            theSamplingDatas.add(eSampleDataCsv != null ? Double.valueOf(CsvSoundAmplitudeWriter.toDouble(eSampleDataCsv)) : null);
        } else {
            int index = 0;
            String eKey = "channel_" + index;
            while (theSampleCsv.containsKey(eKey)) {
                eSampleDataCsv = (String)theSampleCsv.get(eKey);
                theSamplingDatas.add(eSampleDataCsv != null ? Double.valueOf(CsvSoundAmplitudeWriter.toDouble(eSampleDataCsv)) : null);
                eKey = "channel_" + ++index;
            }
        }
        double[] theSample = this._soundSample.getSampleData();
        if (theSample == null || theSample.length == 0) {
            theSample = new double[theSamplingDatas.size()];
            this._soundSample.setSampleData(theSample);
        }
        for (int i = 0; i < theSample.length; ++i) {
            if (theSamplingDatas.get(i) == null) continue;
            theSample[i] = (Double)theSamplingDatas.get(i);
        }
        String theIndex = (String)theSampleCsv.get("index");
        if (theIndex != null && theIndex.length() != 0) {
            this._soundSample.setIndex(Long.parseLong(theIndex));
        } else {
            this._soundSample.increaseIndex();
        }
        String theSamplingRate = (String)theSampleCsv.get("sampling_rate");
        if (theSamplingRate != null && theSamplingRate.length() != 0) {
            this._soundSample.setSamplingRate(Integer.parseInt(theSamplingRate));
        }
        if ((theTimeStamp = (String)theSampleCsv.get("time_stamp")) != null && theTimeStamp.length() != 0) {
            BigDecimal theDecimal = new BigDecimal(theTimeStamp);
            this._soundSample.setTimeStamp(theDecimal.toBigInteger().doubleValue());
        } else {
            this._soundSample.updateTimeStamp();
        }
        return new SoundAmplitudeImpl(this._soundSample);
    }

    @Override
    public String nextRaw() {
        return this._csvReader.nextRaw();
    }

    @Override
    public double[] nextSampleData() throws IOException {
        return this.nextRow().getSampleData();
    }

    @Override
    public int getSamplingRate() {
        return this._soundSample.getSamplingRate();
    }

    @Override
    public long getIndex() {
        return this._soundSample.getIndex();
    }
}

