/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.refcodes.audio.AbstractCsvAmplitudeWriter;
import org.refcodes.audio.CsvDeltaMode;
import org.refcodes.audio.MonoAmplitude;
import org.refcodes.audio.MonoAmplitudeBuilder;
import org.refcodes.audio.MonoAmplitudeBuilderImpl;
import org.refcodes.audio.MonoAmplitudeWriter;
import org.refcodes.audio.SamplingRate;

public class CsvMonoAmplitudeWriter
extends AbstractCsvAmplitudeWriter<MonoAmplitude, CsvMonoAmplitudeWriter>
implements MonoAmplitudeWriter<CsvMonoAmplitudeWriter> {
    private final MonoAmplitudeBuilder _soundSample = new MonoAmplitudeBuilderImpl(0L, SamplingRate.AUDIO_CD.getSamplesPerSecond());
    private boolean _hasHeader = false;
    private boolean _isSampleDataDirty = true;
    private boolean _isSamplingRateDirty = true;

    public CsvMonoAmplitudeWriter(File aFile) throws FileNotFoundException {
        super(aFile);
    }

    public CsvMonoAmplitudeWriter(OutputStream aOutputStream) {
        super(aOutputStream);
    }

    public CsvMonoAmplitudeWriter(PrintStream aPrintStream) {
        super(aPrintStream);
    }

    public CsvMonoAmplitudeWriter(File aFile, CsvDeltaMode aDeltaMode) throws FileNotFoundException {
        super(aFile, aDeltaMode);
    }

    public CsvMonoAmplitudeWriter(OutputStream aOutputStream, CsvDeltaMode aDeltaMode) {
        super(aOutputStream, aDeltaMode);
    }

    public CsvMonoAmplitudeWriter(PrintStream aPrintStream, CsvDeltaMode aDeltaMode) {
        super(aPrintStream, aDeltaMode);
    }

    @Override
    public void writeNext(double aAmplitudeData) {
        this.doUpdateSampleData(aAmplitudeData);
        this._soundSample.updateTimeStamp();
        this.writeNext(this._soundSample);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeNext(MonoAmplitude aAmplitude) {
        double theSample = aAmplitude.getMonoData();
        String[] theRow = new String[4];
        if (!this._hasHeader) {
            CsvMonoAmplitudeWriter csvMonoAmplitudeWriter = this;
            synchronized (csvMonoAmplitudeWriter) {
                if (!this._hasHeader) {
                    theRow[0] = "index";
                    theRow[1] = "time_stamp";
                    theRow[2] = "sample_data";
                    theRow[theRow.length - 1] = "sampling_rate";
                    this._csvWriter.writeHeader(theRow);
                    this._hasHeader = true;
                }
            }
        }
        if (aAmplitude != this._soundSample) {
            this.doUpdateSampleData(aAmplitude.getMonoData());
            if (aAmplitude.getSamplingRate() != -1 && aAmplitude.getSamplingRate() != this._soundSample.getSamplingRate()) {
                this._soundSample.setSamplingRate(aAmplitude.getSamplingRate());
                this._isSamplingRateDirty = true;
            }
            if (aAmplitude.getIndex() != -1L) {
                this._soundSample.setIndex(aAmplitude.getIndex());
            }
            if (aAmplitude.getTimeStamp() != -1.0) {
                this._soundSample.setTimeStamp(aAmplitude.getTimeStamp());
            }
        }
        theRow[0] = Long.toString(this._soundSample.getIndex());
        theRow[1] = CsvMonoAmplitudeWriter.toString(this._soundSample.getTimeStamp());
        if (!this._deltaMode.isSampleDataDelta() || this._isSampleDataDirty) {
            theRow[2] = CsvMonoAmplitudeWriter.toString(theSample);
        }
        if (!this._deltaMode.isSamplingRateDelta() || this._isSamplingRateDirty) {
            theRow[theRow.length - 1] = Integer.toString(this._soundSample.getSamplingRate());
        }
        this._csvWriter.writeNext((T[])theRow);
        this._soundSample.increaseIndex();
        this._isSampleDataDirty = false;
        this._isSamplingRateDirty = false;
    }

    @Override
    public int getSamplingRate() {
        return this._soundSample.getSamplingRate();
    }

    @Override
    public void setSamplingRate(int aSamplingRate) {
        if (aSamplingRate != -1 && aSamplingRate != this._soundSample.getSamplingRate()) {
            this._soundSample.setSamplingRate(aSamplingRate);
            this._isSamplingRateDirty = true;
        }
    }

    @Override
    public CsvMonoAmplitudeWriter withSamplingRate(int aSamplingRate) {
        this.setSamplingRate(aSamplingRate);
        return this;
    }

    private void doUpdateSampleData(double aAmplitudeData) {
        double theSampleData = this._soundSample.getMonoData();
        if (theSampleData != aAmplitudeData) {
            this._isSampleDataDirty = true;
        }
        this._soundSample.setMonoData(aAmplitudeData);
    }
}

