/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import org.refcodes.audio.AbstractCsvAmplitudeReader;
import org.refcodes.audio.CsvSoundAmplitudeWriter;
import org.refcodes.audio.MonoAmplitude;
import org.refcodes.audio.MonoAmplitudeBuilderImpl;
import org.refcodes.audio.MonoAmplitudeImpl;
import org.refcodes.audio.MonoAmplitudeReader;
import org.refcodes.audio.SamplingRate;
import org.refcodes.tabular.CsvStringRecordReader;

public class CsvMonoAmplitudeReader
extends AbstractCsvAmplitudeReader<MonoAmplitude>
implements MonoAmplitudeReader {
    private final MonoAmplitudeBuilderImpl _soundSample = new MonoAmplitudeBuilderImpl(0L, SamplingRate.AUDIO_CD.getSamplesPerSecond());

    public CsvMonoAmplitudeReader(File aFile) throws IOException {
        super(aFile);
    }

    public CsvMonoAmplitudeReader(InputStream aInputStream) throws IOException {
        super(aInputStream);
    }

    protected CsvMonoAmplitudeReader(CsvStringRecordReader aCsvReader) {
        super(aCsvReader);
    }

    @Override
    public MonoAmplitude nextRow() throws IOException {
        String theTimeStamp;
        String eSampleDataCsv;
        this.doProbeHeader();
        Object theSampleCsv = this._csvReader.next();
        double theSamplingData = 0.0;
        if (theSampleCsv.containsKey("sample_data") && (eSampleDataCsv = (String)theSampleCsv.get("sample_data")) != null) {
            theSamplingData = CsvSoundAmplitudeWriter.toDouble(eSampleDataCsv);
        }
        this._soundSample.setMonoData(theSamplingData);
        String theIndex = (String)theSampleCsv.get("index");
        if (theIndex != null && theIndex.length() != 0) {
            this._soundSample.setIndex(Long.parseLong(theIndex));
        } else {
            this._soundSample.increaseIndex();
        }
        String theSamplingRate = (String)theSampleCsv.get("sampling_rate");
        if (theSamplingRate != null && theSamplingRate.length() != 0) {
            this._soundSample.setSamplingRate(Integer.parseInt(theSamplingRate));
        }
        if ((theTimeStamp = (String)theSampleCsv.get("time_stamp")) != null && theTimeStamp.length() != 0) {
            BigDecimal theDecimal = new BigDecimal(theTimeStamp);
            this._soundSample.setTimeStamp(theDecimal.doubleValue());
        } else {
            this._soundSample.updateTimeStamp();
        }
        return new MonoAmplitudeImpl(this._soundSample);
    }

    @Override
    public String nextRaw() {
        return this._csvReader.nextRaw();
    }

    @Override
    public double nextMonoData() throws IOException {
        return this.nextRow().getMonoData();
    }

    @Override
    public int getSamplingRate() {
        return this._soundSample.getSamplingRate();
    }

    @Override
    public long getIndex() {
        return this._soundSample.getIndex();
    }
}

