/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

public enum BitsPerAmplitude {
    LOW_RES(8),
    HIGH_RES(16);

    private int _bitsPerSample;

    private BitsPerAmplitude(int aResolution) {
        this._bitsPerSample = aResolution;
    }

    public int getBitCount() {
        return this._bitsPerSample;
    }

    public int getByteCount() {
        return this._bitsPerSample / 8;
    }

    public static BitsPerAmplitude getLowestResolution() {
        return LOW_RES;
    }

    public static BitsPerAmplitude getHigestResolution() {
        return HIGH_RES;
    }

    public BitsPerAmplitude getNextHigherResolution() {
        return BitsPerAmplitude.toNextHigherResolution(this);
    }

    public BitsPerAmplitude getPreviousLowerResolution() {
        return BitsPerAmplitude.toPreviousLowerResolution(this);
    }

    private static BitsPerAmplitude toNextHigherResolution(BitsPerAmplitude aResolution) {
        for (int i = 0; i < BitsPerAmplitude.values().length - 1; ++i) {
            if (aResolution != BitsPerAmplitude.values()[i]) continue;
            return BitsPerAmplitude.values()[i + 1];
        }
        return null;
    }

    private static BitsPerAmplitude toPreviousLowerResolution(BitsPerAmplitude aResolution) {
        for (int i = 1; i < BitsPerAmplitude.values().length; ++i) {
            if (aResolution != BitsPerAmplitude.values()[i]) continue;
            return BitsPerAmplitude.values()[i - 1];
        }
        return null;
    }
}

