/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import org.refcodes.audio.BitsPerAmplitude;
import org.refcodes.audio.SoundAmplitude;
import org.refcodes.audio.WavAmplitudeWriter;
import org.refcodes.numerical.NumericalUtility;

public abstract class AbstractWavAmplitudeWriter<S extends SoundAmplitude, B extends WavAmplitudeWriter<S, B>>
implements WavAmplitudeWriter<S, B> {
    public static String RIFF = "RIFF";
    public static String WAVE = "WAVE";
    public static String FORMAT = "fmt ";
    public static String DATA = "data";
    protected static final long MAX_16_BIT = 65535L;
    protected static final long MAX_8_BIT = 255L;
    protected BufferedOutputStream _outputStream;
    protected File _file = null;
    protected BitsPerAmplitude _bitsPerSample = BitsPerAmplitude.HIGH_RES;

    public AbstractWavAmplitudeWriter(File aFile) throws FileNotFoundException {
        this(new FileOutputStream(aFile));
        this._file = aFile;
    }

    public AbstractWavAmplitudeWriter(OutputStream aOutputStream) {
        this._outputStream = aOutputStream instanceof BufferedOutputStream ? (BufferedOutputStream)aOutputStream : new BufferedOutputStream(aOutputStream);
    }

    @Override
    public void setBitsPerAmplitude(BitsPerAmplitude aBitsPerAmplitude) {
        this._bitsPerSample = aBitsPerAmplitude;
    }

    @Override
    public BitsPerAmplitude getBitsPerAmplitude() {
        return this._bitsPerSample;
    }

    @Override
    public void close() throws IOException {
        this._outputStream.flush();
        this._outputStream.close();
        if (this._file != null) {
            long size = this._file.length();
            try (RandomAccessFile theRndFile = new RandomAccessFile(this._file, "rw");){
                theRndFile.seek(4L);
                byte[] theSizeAfter = NumericalUtility.toLittleEndianBytes(size - 8L, 4);
                theRndFile.write(theSizeAfter);
                theRndFile.seek(40L);
                theSizeAfter = NumericalUtility.toLittleEndianBytes(size - 28L, 4);
                theRndFile.write(theSizeAfter);
            }
        }
    }

    protected long toWavSample(double eSampleData) {
        return switch (this._bitsPerSample) {
            default -> throw new MatchException(null, null);
            case BitsPerAmplitude.HIGH_RES -> (long)(eSampleData * 32767.0);
            case BitsPerAmplitude.LOW_RES -> (long)((eSampleData + 1.0) * 127.0);
        };
    }

    protected void writeHeader(int aSamplingRate, int aChannelNumber) throws IOException {
        this._outputStream.write(RIFF.getBytes(StandardCharsets.US_ASCII));
        this._outputStream.write(NumericalUtility.toLittleEndianBytes(0L, 4));
        this._outputStream.write(WAVE.getBytes(StandardCharsets.US_ASCII));
        this._outputStream.write(FORMAT.getBytes(StandardCharsets.US_ASCII));
        this._outputStream.write(NumericalUtility.toLittleEndianBytes(16L, 4));
        this._outputStream.write(NumericalUtility.toLittleEndianBytes(1L, 2));
        this._outputStream.write(NumericalUtility.toLittleEndianBytes(aChannelNumber, 2));
        this._outputStream.write(NumericalUtility.toLittleEndianBytes(aSamplingRate, 4));
        this._outputStream.write(NumericalUtility.toLittleEndianBytes(aSamplingRate * aChannelNumber * this._bitsPerSample.getByteCount(), 4));
        this._outputStream.write(NumericalUtility.toLittleEndianBytes(this._bitsPerSample.getByteCount() * aChannelNumber, 2));
        this._outputStream.write(NumericalUtility.toLittleEndianBytes(this._bitsPerSample.getBitCount() * aChannelNumber, 2));
        this._outputStream.write(DATA.getBytes(StandardCharsets.US_ASCII));
        this._outputStream.write(NumericalUtility.toLittleEndianBytes(0L, 4));
    }
}

