/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.refcodes.audio.BitsPerAmplitude;
import org.refcodes.audio.LineOutAmplitudeWriter;
import org.refcodes.audio.SoundAmplitude;

public abstract class AbstractLineOutAmplitudeWriter<S extends SoundAmplitude, B extends LineOutAmplitudeWriter<S, B>>
implements LineOutAmplitudeWriter<S, B> {
    protected static final long MAX_16_BIT = 65535L;
    protected static final long MAX_8_BIT = 255L;
    protected BitsPerAmplitude _bitsPerSample = BitsPerAmplitude.HIGH_RES;

    public AbstractLineOutAmplitudeWriter() {
    }

    public AbstractLineOutAmplitudeWriter(BitsPerAmplitude aBitsPerAmplitude) {
        this._bitsPerSample = aBitsPerAmplitude;
    }

    @Override
    public void setBitsPerAmplitude(BitsPerAmplitude aBitsPerAmplitude) {
        this._bitsPerSample = aBitsPerAmplitude;
    }

    @Override
    public BitsPerAmplitude getBitsPerAmplitude() {
        return this._bitsPerSample;
    }

    protected long toWavSample(double eSampleData) {
        return switch (this._bitsPerSample) {
            default -> throw new MatchException(null, null);
            case BitsPerAmplitude.HIGH_RES -> (long)(eSampleData * 32767.0);
            case BitsPerAmplitude.LOW_RES -> (long)(eSampleData * 127.0);
        };
    }

    protected static SourceDataLine toLineOut(SoundAmplitude aSoundAmplitude, BitsPerAmplitude aBitsPerAmplitude) throws LineUnavailableException {
        return AbstractLineOutAmplitudeWriter.toLineOut(aSoundAmplitude.getChannelCount(), aSoundAmplitude.getSamplingRate(), aBitsPerAmplitude);
    }

    protected static SourceDataLine toLineOut(int aChannelCount, int aSamplingRate, BitsPerAmplitude aBitsPerAmplitude) throws LineUnavailableException {
        AudioSystem.getMixerInfo();
        AudioFormat format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, aSamplingRate, aBitsPerAmplitude.getBitCount() * aChannelCount, aChannelCount, aBitsPerAmplitude.getByteCount() * aChannelCount, aSamplingRate, true);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        SourceDataLine theLine = (SourceDataLine)AudioSystem.getLine(info);
        theLine.open();
        theLine.start();
        return theLine;
    }
}

