/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.refcodes.audio.CsvAmplitudeWriter;
import org.refcodes.audio.CsvDeltaMode;
import org.refcodes.audio.SoundAmplitude;
import org.refcodes.tabular.CsvStringRecordWriter;

public abstract class AbstractCsvAmplitudeWriter<S extends SoundAmplitude, B extends CsvAmplitudeWriter<S, B>>
implements CsvAmplitudeWriter<S, B> {
    static final String CHANNEL_INDEX_SEPARATOR = "_";
    static final String HEADER_SAMPLING_RATE = "sampling_rate";
    static final String HEADER_CHANNEL = "channel";
    static final String HEADER_SAMPLE_DATA = "sample_data";
    static final String HEADER_INDEX = "index";
    static final String HEADER_TIME_STAMP = "time_stamp";
    protected CsvStringRecordWriter _csvWriter;
    protected CsvDeltaMode _deltaMode;
    protected boolean _isSamplingRateDirty = true;

    public AbstractCsvAmplitudeWriter(File aFile) throws FileNotFoundException {
        this(aFile, CsvDeltaMode.NONE);
    }

    public AbstractCsvAmplitudeWriter(OutputStream aOutputStream) {
        this(aOutputStream, CsvDeltaMode.NONE);
    }

    public AbstractCsvAmplitudeWriter(PrintStream aPrintStream) {
        this(aPrintStream, CsvDeltaMode.NONE);
    }

    public AbstractCsvAmplitudeWriter(File aFile, CsvDeltaMode aDeltaMode) throws FileNotFoundException {
        this(new CsvStringRecordWriter(aFile), aDeltaMode);
    }

    public AbstractCsvAmplitudeWriter(OutputStream aOutputStream, CsvDeltaMode aDeltaMode) {
        this(new CsvStringRecordWriter(aOutputStream), aDeltaMode);
    }

    public AbstractCsvAmplitudeWriter(PrintStream aPrintStream, CsvDeltaMode aDeltaMode) {
        this(new CsvStringRecordWriter(aPrintStream), aDeltaMode);
    }

    protected AbstractCsvAmplitudeWriter(CsvStringRecordWriter aCsvFriter, CsvDeltaMode aDeltaMode) {
        this._csvWriter = aCsvFriter;
        this._deltaMode = aDeltaMode;
    }

    @Override
    public void close() throws IOException {
        this._csvWriter.close();
    }

    protected static String toString(double aDouble) {
        return AbstractCsvAmplitudeWriter.format(Double.toString(aDouble));
    }

    protected static double toDouble(String aDouble) {
        return Double.valueOf(AbstractCsvAmplitudeWriter.format(aDouble));
    }

    protected static String format(String aDouble) {
        int index = aDouble.indexOf(46);
        if (index == -1) {
            index = aDouble.indexOf(44);
        }
        if (index != -1) {
            while (aDouble.endsWith("0")) {
                aDouble = aDouble.substring(0, aDouble.length() - 1);
            }
            if (aDouble.endsWith(".") || aDouble.endsWith(",")) {
                aDouble = aDouble.substring(0, aDouble.length() - 1);
            }
        }
        return aDouble;
    }
}

