/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.refcodes.audio.AmplitudeReader;
import org.refcodes.audio.SoundAmplitude;
import org.refcodes.tabular.CsvStringRecordReader;

public abstract class AbstractCsvAmplitudeReader<S extends SoundAmplitude>
implements AmplitudeReader<S> {
    protected CsvStringRecordReader _csvReader;
    private boolean _hasHeader = false;

    public AbstractCsvAmplitudeReader(File aFile) throws IOException {
        this(new CsvStringRecordReader(aFile));
    }

    public AbstractCsvAmplitudeReader(InputStream aInputStream) throws IOException {
        this(new CsvStringRecordReader(aInputStream));
    }

    protected AbstractCsvAmplitudeReader(CsvStringRecordReader aCsvReader) {
        this._csvReader = aCsvReader;
    }

    @Override
    public boolean hasNext() {
        try {
            this.doProbeHeader();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this._csvReader.hasNext();
    }

    @Override
    public void close() throws IOException {
        this._csvReader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProbeHeader() throws IOException {
        if (!this._hasHeader) {
            AbstractCsvAmplitudeReader abstractCsvAmplitudeReader = this;
            synchronized (abstractCsvAmplitudeReader) {
                if (!this._hasHeader) {
                    this._csvReader.readHeader();
                    this._hasHeader = true;
                }
            }
        }
    }
}

