/*
 * Decompiled with CFR 0.152.
 */
package club.funcodes.waves;

import club.funcodes.waves.Mixer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.Arrays;
import org.refcodes.archetype.CliHelper;
import org.refcodes.audio.BitsPerAmplitude;
import org.refcodes.audio.CsvMonoAmplitudeReader;
import org.refcodes.audio.CsvMonoAmplitudeWriter;
import org.refcodes.audio.CurveFunctionFunction;
import org.refcodes.audio.CurveFunctionSoundAmplitudeBuilder;
import org.refcodes.audio.LineOutMonoAmplitudeWriter;
import org.refcodes.audio.MonoAmplitude;
import org.refcodes.audio.MonoAmplitudeBuilder;
import org.refcodes.audio.MonoAmplitudeWriter;
import org.refcodes.audio.SvgMonoAmplitudeWriter;
import org.refcodes.audio.WavMonoAmplitudeWriter;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.DebugFlag;
import org.refcodes.cli.DoubleOption;
import org.refcodes.cli.EnumOption;
import org.refcodes.cli.Example;
import org.refcodes.cli.FileOption;
import org.refcodes.cli.HelpFlag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.SuperfluousArgsException;
import org.refcodes.cli.SysInfoFlag;
import org.refcodes.cli.VerboseFlag;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.exception.BugException;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.runtime.Execution;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.VerboseTextBuilder;

public class Main {
    private static final RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final String NAME = "waves";
    private static final String TITLE = "~" + "waves".toUpperCase() + "~";
    private static final String DESCRIPTION = "Tool to generate or pipe and filter (sound) waves for audio playback and export (see [https://www.metacodes.pro/manpages/waves_manpage]).";
    private static final String LICENSE_NOTE = "You may choose between the LGPL v3.0 or later and the Apache License v2.0 when using this software";
    private static final String COPYRIGHT = "Copyright (c) by CLUB.FUNCODES | See [https://www.metacodes.pro/manpages/waves_manpage]";
    private static final char[] BANNER_PALETTE = AsciiColorPalette.MAX_LEVEL_GRAY.getPalette();
    private static final Font BANNER_FONT = new Font(FontFamily.SANS_SERIF, FontStyle.PLAIN);
    private static final String CURVE_FUNCTION = "curveFunction";
    private static final String MIXER = "mixer";
    private static final String FREQUENCY_HZ = "frequencyHz";
    private static final String AMPLITUDE = "amplitude";
    private static final String SAMPLING_RATE = "samplingRate";
    private static final String LENGTH_SEC = "lengthSec";
    private static final String OUTPUT_FILE = "outputFile";
    private static final String X_OFFSET = "xOffset";
    private static final String Y_OFFSET = "yOffset";
    private static final String FORMAT = "format";
    private static final String BITS_PER_AMPLITUDE = "bitsPerAmplitude";
    private static final BitsPerAmplitude DEFAULT_BITS_PER_SAMPLE = BitsPerAmplitude.HIGH_RES;
    private static final CurveFunctionFunction DEFAULT_CURVE_FUNCTION = CurveFunctionFunction.SINE;
    private static final Mixer DEFAULT_ARITHMETIC_OPERATION = Mixer.NONE;
    private static final Format DEFAULT_FILE_FORMAT = Format.CSV;
    private static final int DEFAULT_SAMPLING_RATE_PER_SEC = 44100;
    private static final double DEFAULT_AMPLITUDE = 1.0;
    private static final double DEFAULT_LENGTH_SEC = 1.0;
    private static final int DEFAULT_X_OFFSET = 0;
    private static final double DEFAULT_Y_OFFSET = 0.0;
    private static final String COMMENT = "Generated by <FUNCODES.CLUB> ~WAVES~ (http://www.funcodes.club)";

    public static void main(String[] args) {
        DoubleOption theFrequencyOpt = CliSugar.doubleOption(Character.valueOf('f'), "frequency", FREQUENCY_HZ, "The frequency (Hz) to use when generating the values.");
        EnumOption<CurveFunctionFunction> theCurveFunctionOpt = CliSugar.enumOption(Character.valueOf('c'), "curve-function", CurveFunctionFunction.class, CURVE_FUNCTION, "The function to use when generating the values (defaults to " + DEFAULT_CURVE_FUNCTION.name() + "). The function can be one of the following: " + VerboseTextBuilder.asString((Object[])CurveFunctionFunction.values()));
        EnumOption<Mixer> theMixerOpt = CliSugar.enumOption(Character.valueOf('m'), MIXER, Mixer.class, MIXER, "The mixer operation to be applied to the data from standard input. The function can be one of the following: " + VerboseTextBuilder.asString((Object[])Mixer.values()));
        DoubleOption theAmplitudeOpt = CliSugar.doubleOption(Character.valueOf('a'), AMPLITUDE, AMPLITUDE, "The (max) amplitude (0..n) to use when generating the values (defaults to 1.0).");
        IntOption theSamplingRateOpt = CliSugar.intOption(Character.valueOf('s'), "sampling-rate", SAMPLING_RATE, "The sample rate (per second) for the generated values (defaults to 44100 samples/second).");
        DoubleOption theLengthOpt = CliSugar.doubleOption(Character.valueOf('l'), "length", LENGTH_SEC, "The length (in seconds) for the generated values (defaults to 1.0 seconds).");
        DoubleOption theYOffsetOpt = CliSugar.doubleOption(Character.valueOf('y'), "y-offset", Y_OFFSET, "The y-offset (floating-point ) on the y-axis for the amplitude to use when generating the values (defaults to 0.0).");
        IntOption theXOffsetOpt = CliSugar.intOption(Character.valueOf('x'), "x-offset", X_OFFSET, "The x-offset (integer) on the x-axis for the samples offset to use when generating the values (defaults to 0).");
        FileOption theOutputFileOpt = CliSugar.fileOption(Character.valueOf('o'), "output-file", OUTPUT_FILE, "The output file (file name) where to write the values to.");
        EnumOption<Format> theFormatOpt = CliSugar.enumOption(Character.valueOf('F'), FORMAT, Format.class, FORMAT, "The output Format to use when writing to an output file (defaults to " + DEFAULT_FILE_FORMAT.name() + "). The Format can be one of the following: " + VerboseTextBuilder.asString((Object[])Format.values()));
        EnumOption<BitsPerAmplitude> theBitsPerAmplitudeOpt = CliSugar.enumOption(Character.valueOf('b'), "bits", BitsPerAmplitude.class, BITS_PER_AMPLITUDE, "The bits/amplitude to use if supported by the output Format (defaults to " + DEFAULT_BITS_PER_SAMPLE.name() + "). The bits/amplitude: " + VerboseTextBuilder.asString((Object[])BitsPerAmplitude.values()));
        VerboseFlag theVerboseFlag = CliSugar.verboseFlag();
        DebugFlag theDebugFlag = CliSugar.debugFlag();
        SysInfoFlag theSysInfoFlag = CliSugar.sysInfoFlag(false);
        HelpFlag theHelpFlag = CliSugar.helpFlag();
        CasesCondition theArgsSyntax = CliSugar.cases(CliSugar.and(theFrequencyOpt, theCurveFunctionOpt, CliSugar.optional(theAmplitudeOpt, theXOffsetOpt, theYOffsetOpt, theVerboseFlag, theDebugFlag, CliSugar.xor(CliSugar.optional(theLengthOpt, theSamplingRateOpt, CliSugar.optional(theOutputFileOpt, theFormatOpt, theBitsPerAmplitudeOpt)), CliSugar.and(theMixerOpt, CliSugar.optional(theOutputFileOpt, theFormatOpt, theBitsPerAmplitudeOpt))))), CliSugar.xor(theHelpFlag, theSysInfoFlag));
        Example[] theExamples = CliSugar.examples(CliSugar.example("Set <format> to '" + String.valueOf((Object)Format.LINE_OUT) + "' for direct playback", theCurveFunctionOpt, theLengthOpt, theFrequencyOpt, theFormatOpt), CliSugar.example("Generate waves for further processing", theCurveFunctionOpt, theFrequencyOpt, theLengthOpt), CliSugar.example("Pipe ('|') previous output in here ", theCurveFunctionOpt, theFrequencyOpt, theMixerOpt, theFormatOpt));
        CliHelper theCliHelper = ((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)CliHelper.builder().withArgs(args)).withArgsSyntax(theArgsSyntax)).withExamples(theExamples)).withName(NAME)).withTitle(TITLE)).withDescription(DESCRIPTION)).withLicense(LICENSE_NOTE)).withCopyright(COPYRIGHT)).withBannerFont(BANNER_FONT)).withBannerFontPalette(BANNER_PALETTE)).withLogger(LOGGER)).build();
        try {
            if (theFormatOpt.getValue() == Format.LINE_OUT && theOutputFileOpt.hasValue()) {
                throw new SuperfluousArgsException("The format <" + String.valueOf(theFormatOpt.getValue()) + "> (as of " + Arrays.toString(theCliHelper.toOptions(theFormatOpt)) + ") cannot be used together with an output file (as of " + Arrays.toString(theCliHelper.toOptions(theOutputFileOpt)) + ").", theCliHelper.toOptions(theOutputFileOpt));
            }
            CurveFunctionFunction theTrigonometricFunction = theCurveFunctionOpt.getValueOr(DEFAULT_CURVE_FUNCTION);
            double theFrequency = (Double)theFrequencyOpt.getValue();
            double theAmplitude = theAmplitudeOpt.getValueOr(1.0);
            int theSamplingRate = theSamplingRateOpt.getValueOr(44100);
            double theLength = theLengthOpt.getValueOr(1.0);
            int theXOffset = theXOffsetOpt.getValueOr(0);
            double theYOffset = theYOffsetOpt.getValueOr(0.0);
            Mixer theArithmeticOperation = theMixerOpt.getValueOr(DEFAULT_ARITHMETIC_OPERATION);
            Format theFormat = theFormatOpt.getValueOr(DEFAULT_FILE_FORMAT);
            BitsPerAmplitude theBitsPerAmplitude = theBitsPerAmplitudeOpt.getValueOr(DEFAULT_BITS_PER_SAMPLE);
            File theOutputFile = (File)theOutputFileOpt.getValue();
            MonoAmplitudeWriter<CsvMonoAmplitudeWriter> monoAmplitudeWriter = switch (theFormat.ordinal()) {
                case 3 -> new LineOutMonoAmplitudeWriter().withOpen(theBitsPerAmplitude, theSamplingRate);
                case 0 -> new CsvMonoAmplitudeWriter(Main.toOutStream(theOutputFile));
                case 2 -> new SvgMonoAmplitudeWriter(Main.toOutStream(theOutputFile));
                case 1 -> {
                    if (theOutputFile != null) {
                        yield new WavMonoAmplitudeWriter(theOutputFile, theBitsPerAmplitude);
                    }
                    yield new WavMonoAmplitudeWriter(Main.toOutStream(), theBitsPerAmplitude);
                }
                default -> throw new BugException("Encountered an unconsidered value <" + String.valueOf((Object)theFormat) + "> for type <" + Format.class.getName() + ">");
            };
            try (MonoAmplitudeWriter<CsvMonoAmplitudeWriter> theMonoWriter = monoAmplitudeWriter;){
                if (theMixerOpt.hasValue()) {
                    Main.filterWavesTo(theTrigonometricFunction, theArithmeticOperation, theFrequency, theAmplitude, theXOffset, theYOffset, theMonoWriter, theVerboseFlag.isEnabled());
                } else {
                    Main.generateWavesTo(theTrigonometricFunction, theFrequency, theAmplitude, theXOffset, theYOffset, theSamplingRate, theLength, theMonoWriter, theVerboseFlag.isEnabled());
                }
            }
        }
        catch (Throwable e) {
            theCliHelper.exitOnException(e);
        }
    }

    private static void generateWavesTo(CurveFunctionFunction aTrigonemetricFunction, double aFrequencyHz, double aAmplitude, int aXOffset, double aYOffset, int aSamplingRate, double aLengthSec, MonoAmplitudeWriter<?> aMonoWriter, boolean isVerbose) throws IOException {
        if (isVerbose) {
            System.out.println("# Generated by <FUNCODES.CLUB> ~WAVES~ (http://www.funcodes.club)");
            System.out.println("# Trigonometric function = " + String.valueOf((Object)aTrigonemetricFunction));
            System.out.println("# Frequency (Hz) = " + aFrequencyHz);
            System.out.println("# Amplitude (max) = " + aAmplitude);
            System.out.println("# Length (seconds) = " + aLengthSec);
            System.out.println("# X-Offset (samples) = " + aXOffset);
            System.out.println("# Y-Offset = " + aYOffset);
            System.out.println("# Sampling rate (per second) = " + aSamplingRate);
            System.out.println();
        }
        int theSamples = (int)(aLengthSec * (double)aSamplingRate) + 1;
        try (MonoAmplitudeWriter<?> monoAmplitudeWriter = aMonoWriter;){
            for (int i = 0; i < theSamples; ++i) {
                MonoAmplitudeBuilder eSample = CurveFunctionSoundAmplitudeBuilder.asMonoSample(i, aTrigonemetricFunction.getFunction(), aFrequencyHz, aAmplitude, aXOffset, aYOffset, aSamplingRate);
                aMonoWriter.writeNext(eSample.getMonoData());
            }
        }
    }

    private static void filterWavesTo(CurveFunctionFunction aTrigonemetricFunction, Mixer aMixer, double aFrequencyHz, double aAmplitude, int aXOffset, double aYOffset, MonoAmplitudeWriter<?> aMonoWriter, boolean isVerbose) throws IOException, ParseException {
        if (isVerbose) {
            System.out.println("# Generated by <FUNCODES.CLUB> ~WAVES~ (http://www.funcodes.club)");
            System.out.println("# Trigonometric function = " + String.valueOf((Object)aTrigonemetricFunction));
            System.out.println("# Frequency (Hz) = " + aFrequencyHz);
            System.out.println("# Amplitude (max) = " + aAmplitude);
            System.out.println("# X-Offset (samples) = " + aXOffset);
            System.out.println("# Y-Offset = " + aYOffset);
            System.out.println();
        }
        try (MonoAmplitudeWriter<?> monoAmplitudeWriter = aMonoWriter;
             CsvMonoAmplitudeReader theCsvReader = new CsvMonoAmplitudeReader(new BufferedInputStream(System.in));){
            while (theCsvReader.hasNext()) {
                MonoAmplitude eFromSample = theCsvReader.nextRow();
                MonoAmplitudeBuilder eToSample = CurveFunctionSoundAmplitudeBuilder.asMonoSample(eFromSample.getIndex(), aTrigonemetricFunction.getFunction(), aFrequencyHz, aAmplitude, aXOffset, aYOffset, eFromSample.getSamplingRate());
                double eSampleData = aMixer.getOperation().apply(eFromSample.getMonoData(), eToSample.getMonoData());
                eToSample.setMonoData(eSampleData);
                aMonoWriter.writeNext(eToSample);
            }
        }
    }

    private static PrintStream toOutStream(File aOutputFile) throws FileNotFoundException {
        if (aOutputFile != null) {
            return new PrintStream(new FileOutputStream(aOutputFile));
        }
        return Execution.toBootstrapStandardOut();
    }

    private static PrintStream toOutStream() {
        return Execution.toBootstrapStandardOut();
    }

    private static enum Format {
        CSV,
        WAV,
        SVG,
        LINE_OUT;

    }
}

