/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial.alt.tty;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.exception.Trap;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.serial.PortTestBench;
import org.refcodes.serial.alt.tty.TtyPort;
import org.refcodes.serial.alt.tty.TtyPortHub;
import org.refcodes.serial.alt.tty.TtyPortMetrics;
import org.refcodes.textual.VerboseTextBuilder;

public class TtyPortTestBench
implements PortTestBench {
    private static final Logger LOGGER = Logger.getLogger(TtyPortTestBench.class.getName());
    private static final String[] PORT_TYPES = new String[]{"ttl232", "ftdi_sio", "ft232"};
    private String[] _portTypes;
    private TtyPortMetrics _portMetrics;
    private TtyPort _port1;
    private TtyPort _port2;
    private String _alias1;
    private String _alias2;

    public TtyPortTestBench() {
        this((TtyPortMetrics)null, PORT_TYPES);
    }

    public TtyPortTestBench(String ... aPortTypes) {
        this((TtyPortMetrics)null, aPortTypes);
    }

    public TtyPortTestBench(TtyPortMetrics aPortMetrics) {
        this(aPortMetrics, PORT_TYPES);
    }

    public TtyPortTestBench(TtyPortMetrics aPortMetrics, String ... aPortTypes) {
        block8: {
            this._port1 = null;
            this._port2 = null;
            this._alias1 = null;
            this._alias2 = null;
            aPortTypes = aPortTypes != null && aPortTypes.length != 0 ? aPortTypes : PORT_TYPES;
            this._portTypes = aPortTypes;
            this._portMetrics = aPortMetrics;
            try {
                TtyPortHub thePortHub = new TtyPortHub();
                for (String eCandidate : aPortTypes) {
                    int i = 0;
                    for (TtyPort ePort : thePortHub.ports()) {
                        if (!ePort.getName().toLowerCase().contains(eCandidate) && !ePort.getDescription().toLowerCase().contains(eCandidate)) continue;
                        if (i == 0) {
                            if (SystemProperty.LOG_TESTS.isEnabled()) {
                                LOGGER.log(Level.FINEST, "Found 1st port <" + String.valueOf(ePort) + "> to use ...");
                            }
                            this._alias1 = ePort.getAlias();
                        }
                        if (i == 1) {
                            if (SystemProperty.LOG_TESTS.isEnabled()) {
                                LOGGER.log(Level.FINEST, "Found 2nd port <" + String.valueOf(ePort) + "> to use ...");
                            }
                            this._alias2 = ePort.getAlias();
                            break block8;
                        }
                        ++i;
                    }
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to access any TTY ports: " + Trap.asMessage(e));
            }
        }
    }

    @Override
    public boolean hasPorts() {
        boolean hasPorts;
        boolean bl = hasPorts = this._alias1 != null && this._alias2 != null;
        if (!hasPorts) {
            LOGGER.log(Level.WARNING, "Failed to determine a pair of ports with types < " + VerboseTextBuilder.asString(this._portTypes) + "> (please connect your null modem cable to two serial ports on your box)!");
        }
        return hasPorts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TtyPort getReceiverPort() throws IOException {
        if (this._port1 == null) {
            TtyPortTestBench ttyPortTestBench = this;
            synchronized (ttyPortTestBench) {
                if (this._port1 == null) {
                    this._port1 = new TtyPortHub().toPort(this._alias1, this._portMetrics);
                    if (SystemProperty.LOG_TESTS.isEnabled()) {
                        LOGGER.log(Level.INFO, "Using 1st port <" + String.valueOf(this._port1) + "> ...");
                    }
                }
            }
        }
        return this._port1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TtyPort getTransmitterPort() throws IOException {
        if (this._port2 == null) {
            TtyPortTestBench ttyPortTestBench = this;
            synchronized (ttyPortTestBench) {
                if (this._port2 == null) {
                    this._port2 = new TtyPortHub().toPort(this._alias2, this._portMetrics);
                    if (SystemProperty.LOG_TESTS.isEnabled()) {
                        LOGGER.log(Level.INFO, "Using 2nd port <" + String.valueOf(this._port2) + "> ...");
                    }
                }
            }
        }
        return this._port2;
    }

    @Override
    public void open() throws IOException {
        if (this._portMetrics != null) {
            this.getReceiverPort().open(this._portMetrics);
            this.getTransmitterPort().open(this._portMetrics);
        } else {
            this.getReceiverPort().open();
            this.getTransmitterPort().open();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this._port1 != null) {
                this._port1.close();
            }
        }
        finally {
            if (this._port2 != null) {
                this._port2.close();
            }
        }
    }

    @Override
    public void waitShortestForPortCatchUp() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void waitShortForPortCatchUp() {
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void waitForPortCatchUp() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void waitLongForPortCatchUp() {
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void waitLongestForPortCatchUp() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void waitForPortCatchUp(long aSleepTimeMillis) {
        try {
            Thread.sleep(aSleepTimeMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

