/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial.alt.tty;

import com.fazecast.jSerialComm.SerialPort;
import org.refcodes.mixin.ReadTimeoutMillisAccessor;
import org.refcodes.mixin.WriteTimeoutMillisAccessor;
import org.refcodes.numerical.BitwiseOperationBuilder;
import org.refcodes.serial.PortMetrics;
import org.refcodes.serial.alt.tty.BaudRate;
import org.refcodes.serial.alt.tty.Handshake;
import org.refcodes.serial.alt.tty.Parity;
import org.refcodes.serial.alt.tty.StopBits;

public class TtyPortMetrics
implements PortMetrics,
ReadTimeoutMillisAccessor,
WriteTimeoutMillisAccessor {
    public static final int DEFAULT_DATA_BITS = 8;
    private static final int DEFAULT_BAUD_RATE = BaudRate.BPS_9600.getBitsPerSecond();
    private static final Parity DEFAULT_PARTITY = Parity.AUTO;
    private static final StopBits DEFAULT_STOP_BITS = StopBits.AUTO;
    private static final Handshake DEFAULT_HANDSHAKE = Handshake.AUTO;
    private static final long DEFAULT_READ_TIMEOUT_IN_MS = -1L;
    private static final long DEFAULT_WRITE_TIMEOUT_IN_MS = -1L;
    private int _baudRate = DEFAULT_BAUD_RATE;
    private Parity _parity = DEFAULT_PARTITY;
    private int _dataBits = 8;
    private StopBits _stopBits = DEFAULT_STOP_BITS;
    private Handshake _handshake = DEFAULT_HANDSHAKE;
    private long _readTimeoutInMs = -1L;
    private long _writeTimeoutInMs = -1L;

    private TtyPortMetrics(Builder aBuilder) {
        this._baudRate = aBuilder.baudRate;
        this._parity = aBuilder.parity;
        this._dataBits = aBuilder.dataBits;
        this._stopBits = aBuilder.stopBits;
        this._handshake = aBuilder.handshake;
        this._readTimeoutInMs = aBuilder.readTimeoutInMs;
        this._writeTimeoutInMs = aBuilder.writeTimeoutInMs;
    }

    public TtyPortMetrics(int aBaudRate, int aDataBits, StopBits aStopBits, Parity aParity, Handshake aHandshake, long aReadTimeoutInMs, long aWriteTimeoutInMs) {
        this._baudRate = aBaudRate;
        this._dataBits = aDataBits;
        this._stopBits = aStopBits;
        this._parity = aParity;
        this._handshake = aHandshake;
        this._readTimeoutInMs = aReadTimeoutInMs;
        this._writeTimeoutInMs = aWriteTimeoutInMs;
    }

    public TtyPortMetrics(BaudRate aBaudRate, int aDataBits, StopBits aStopBits, Parity aParity, Handshake aHandshake, long aReadTimeoutInMs, long aWriteTimeoutInMs) {
        this._baudRate = aBaudRate.getBitsPerSecond();
        this._dataBits = aDataBits;
        this._stopBits = aStopBits;
        this._parity = aParity;
        this._handshake = aHandshake;
        this._readTimeoutInMs = aReadTimeoutInMs;
        this._writeTimeoutInMs = aWriteTimeoutInMs;
    }

    public TtyPortMetrics(int aBaudRate, int aDataBits, StopBits aStopBits, Parity aParity, Handshake aHandshake) {
        this._baudRate = aBaudRate;
        this._dataBits = aDataBits;
        this._stopBits = aStopBits;
        this._parity = aParity;
        this._handshake = aHandshake;
        this._readTimeoutInMs = -1L;
        this._writeTimeoutInMs = -1L;
    }

    public TtyPortMetrics(BaudRate aBaudRate, int aDataBits, StopBits aStopBits, Parity aParity, Handshake aHandshake) {
        this._baudRate = aBaudRate.getBitsPerSecond();
        this._dataBits = aDataBits;
        this._stopBits = aStopBits;
        this._parity = aParity;
        this._handshake = aHandshake;
        this._readTimeoutInMs = -1L;
        this._writeTimeoutInMs = -1L;
    }

    public TtyPortMetrics(int aBaudRate, int aDataBits, StopBits aStopBits, Parity aParity) {
        this._baudRate = aBaudRate;
        this._dataBits = aDataBits;
        this._stopBits = aStopBits;
        this._parity = aParity;
        this._handshake = Handshake.AUTO;
        this._readTimeoutInMs = -1L;
        this._writeTimeoutInMs = -1L;
    }

    public TtyPortMetrics(BaudRate aBaudRate, int aDataBits, StopBits aStopBits, Parity aParity) {
        this._baudRate = aBaudRate.getBitsPerSecond();
        this._dataBits = aDataBits;
        this._stopBits = aStopBits;
        this._parity = aParity;
        this._handshake = Handshake.AUTO;
        this._readTimeoutInMs = -1L;
        this._writeTimeoutInMs = -1L;
    }

    public TtyPortMetrics(int aBaudRate) {
        this._baudRate = aBaudRate;
        this._dataBits = 8;
        this._stopBits = StopBits.AUTO;
        this._parity = Parity.AUTO;
        this._handshake = Handshake.AUTO;
        this._readTimeoutInMs = -1L;
        this._writeTimeoutInMs = -1L;
    }

    public TtyPortMetrics(BaudRate aBaudRate) {
        this._baudRate = aBaudRate.getBitsPerSecond();
        this._dataBits = 8;
        this._stopBits = StopBits.AUTO;
        this._parity = Parity.AUTO;
        this._handshake = Handshake.AUTO;
        this._readTimeoutInMs = -1L;
        this._writeTimeoutInMs = -1L;
    }

    public TtyPortMetrics(long aReadTimeoutInMs, long aWriteTimeoutInMs) {
        this._baudRate = DEFAULT_BAUD_RATE;
        this._dataBits = 8;
        this._stopBits = StopBits.AUTO;
        this._parity = Parity.AUTO;
        this._handshake = Handshake.AUTO;
        this._readTimeoutInMs = aReadTimeoutInMs;
        this._writeTimeoutInMs = aWriteTimeoutInMs;
    }

    public TtyPortMetrics(BaudRate aBaudRate, long aReadTimeoutInMs, long aWriteTimeoutInMs) {
        this._baudRate = aBaudRate.getBitsPerSecond();
        this._dataBits = 8;
        this._stopBits = StopBits.AUTO;
        this._parity = Parity.AUTO;
        this._handshake = Handshake.AUTO;
        this._readTimeoutInMs = aReadTimeoutInMs;
        this._writeTimeoutInMs = aWriteTimeoutInMs;
    }

    public TtyPortMetrics(int aBaudRate, long aReadTimeoutInMs, long aWriteTimeoutInMs) {
        this._baudRate = aBaudRate;
        this._dataBits = 8;
        this._stopBits = StopBits.AUTO;
        this._parity = Parity.AUTO;
        this._handshake = Handshake.AUTO;
        this._readTimeoutInMs = aReadTimeoutInMs;
        this._writeTimeoutInMs = aWriteTimeoutInMs;
    }

    public TtyPortMetrics() {
        this._baudRate = -1;
        this._dataBits = 8;
        this._stopBits = StopBits.AUTO;
        this._parity = Parity.AUTO;
        this._handshake = Handshake.AUTO;
        this._readTimeoutInMs = -1L;
        this._writeTimeoutInMs = -1L;
    }

    TtyPortMetrics(SerialPort aSerialPort) {
        this._baudRate = aSerialPort.getBaudRate();
        this._stopBits = switch (aSerialPort.getNumStopBits()) {
            case 1 -> StopBits.ONE;
            case 2 -> StopBits.ONE_POINT_FIVE;
            case 3 -> StopBits.TWO;
            default -> StopBits.AUTO;
        };
        int theFlowControl = aSerialPort.getFlowControlSettings();
        this._handshake = BitwiseOperationBuilder.isMaskable(theFlowControl, 1) || BitwiseOperationBuilder.isMaskable(theFlowControl, 16) ? Handshake.RTS : (BitwiseOperationBuilder.isMaskable(theFlowControl, 4096) || BitwiseOperationBuilder.isMaskable(theFlowControl, 256) ? Handshake.DTR : (BitwiseOperationBuilder.isMaskable(theFlowControl, 65536) || BitwiseOperationBuilder.isMaskable(theFlowControl, 0x100000) ? Handshake.SOFTWARE : Handshake.NONE));
        this._dataBits = aSerialPort.getNumDataBits();
        int thePartiy = aSerialPort.getParity();
        this._parity = switch (thePartiy) {
            case 2 -> Parity.EVEN;
            case 3 -> Parity.MARK;
            case 0 -> Parity.NONE;
            case 1 -> Parity.ODD;
            case 4 -> Parity.SPACE;
            default -> Parity.AUTO;
        };
        this._readTimeoutInMs = aSerialPort.getReadTimeout() == 0 ? -1L : (long)aSerialPort.getReadTimeout();
        this._writeTimeoutInMs = aSerialPort.getWriteTimeout() == 0 ? -1L : (long)aSerialPort.getWriteTimeout();
    }

    public int getBaudRate() {
        return this._baudRate;
    }

    public Parity getParity() {
        return this._parity;
    }

    public int getDataBits() {
        return this._dataBits;
    }

    public StopBits getStopBits() {
        return this._stopBits;
    }

    public Handshake getHandshake() {
        return this._handshake;
    }

    @Override
    public long getReadTimeoutMillis() {
        return this._readTimeoutInMs;
    }

    @Override
    public long getWriteTimeoutMillis() {
        return this._writeTimeoutInMs;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [baudRate=" + this._baudRate + ", parity=" + String.valueOf((Object)this._parity) + ", dataBits=" + this._dataBits + ", stopBits=" + String.valueOf((Object)this._stopBits) + ", handshake=" + String.valueOf((Object)this._handshake) + ", readTimeoutInMs=" + this._readTimeoutInMs + ", writeTimeoutInMs=" + this._writeTimeoutInMs + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements ReadTimeoutMillisAccessor.ReadTimeoutMillisBuilder<Builder>,
    WriteTimeoutMillisAccessor.WriteTimeoutMillisBuilder<Builder> {
        protected int baudRate = DEFAULT_BAUD_RATE;
        protected Parity parity = DEFAULT_PARTITY;
        protected int dataBits = 8;
        protected StopBits stopBits = DEFAULT_STOP_BITS;
        protected Handshake handshake = DEFAULT_HANDSHAKE;
        protected long readTimeoutInMs = -1L;
        protected long writeTimeoutInMs = -1L;

        private Builder() {
        }

        public Builder withBaudRate(int aBaudRate) {
            this.baudRate = aBaudRate;
            return this;
        }

        public Builder withBaudRate(BaudRate aBaudRate) {
            this.baudRate = aBaudRate.getBitsPerSecond();
            return this;
        }

        public Builder withParity(Parity aParity) {
            this.parity = aParity;
            return this;
        }

        public Builder withDataBits(int aDataBits) {
            this.dataBits = aDataBits;
            return this;
        }

        public Builder withStopBits(StopBits aStopBits) {
            this.stopBits = aStopBits;
            return this;
        }

        public Builder withHandshake(Handshake aHandshake) {
            this.handshake = aHandshake;
            return this;
        }

        @Override
        public Builder withReadTimeoutMillis(long aReadTimeoutInMs) {
            this.readTimeoutInMs = aReadTimeoutInMs;
            return this;
        }

        @Override
        public Builder withWriteTimeoutMillis(long aWriteTimeoutInMs) {
            this.writeTimeoutInMs = aWriteTimeoutInMs;
            return this;
        }

        public TtyPortMetrics build() {
            return new TtyPortMetrics(this);
        }
    }
}

