/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialTransceiver;
import org.refcodes.serial.Transmission;
import org.refcodes.serial.TransmissionException;

public interface Segment
extends Transmission {
    default public int fromTransmission(byte[] aChunk) throws TransmissionException {
        return this.fromTransmission(new ByteArraySequence(aChunk));
    }

    default public int fromTransmission(Sequence aSequence) throws TransmissionException {
        return this.fromTransmission(aSequence, 0);
    }

    default public int fromTransmission(byte[] aChunk, int aOffset) throws TransmissionException {
        return this.fromTransmission(new ByteArraySequence(aChunk), aOffset);
    }

    public int fromTransmission(Sequence var1, int var2) throws TransmissionException;

    default public void receiveFrom(InputStream aInputStream) throws IOException {
        this.receiveFrom(aInputStream, null);
    }

    default public void receiveFrom(SerialTransceiver aSerialTransceiver) throws IOException {
        this.receiveFrom(aSerialTransceiver.getInputStream(), aSerialTransceiver.getOutputStream());
    }

    public void receiveFrom(InputStream var1, OutputStream var2) throws IOException;

    public static interface SegmentMixin
    extends Transmission.TransmissionMixin,
    Segment {
        @Override
        default public void receiveFrom(InputStream aInputStream, OutputStream aReturnStream) throws IOException {
            byte[] theChunk = Transmission.fromInputStream(aInputStream, this.getLength());
            this.fromTransmission(theChunk);
        }
    }
}

