/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import org.refcodes.factory.ClassTypeFactory;
import org.refcodes.factory.TypeFactory;
import org.refcodes.schema.Schema;
import org.refcodes.serial.AbstractLengthDecoratorSegment;
import org.refcodes.serial.AbstractReferenceeLengthSegment;
import org.refcodes.serial.AllocSectionDecoratorSegment;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.Section;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionComposite;
import org.refcodes.serial.TransmissionException;

public class SectionComposite<ALLOC extends AllocSectionDecoratorSegment<CHILD>, CHILD extends Section>
implements Section,
Section.SectionMixin,
TransmissionComposite<CHILD> {
    private static final long serialVersionUID = 1L;
    private final TypeFactory<CHILD> _segmentFactory;
    private ALLOC[] _allocSegments;
    private final TypeFactory<ALLOC> _allocSegmentFactory;

    public SectionComposite(TypeFactory<ALLOC> aAllocSegmentFactory, TypeFactory<CHILD> aSegmentFactory) {
        this._allocSegmentFactory = SectionComposite.toAllocFactory(aAllocSegmentFactory, aSegmentFactory);
        this._allocSegments = (AllocSectionDecoratorSegment[])Array.newInstance(aAllocSegmentFactory.getType(), 0);
        this._segmentFactory = aSegmentFactory;
    }

    @SafeVarargs
    public SectionComposite(TypeFactory<ALLOC> aAllocSegmentFactory, TypeFactory<CHILD> aSegmentFactory, CHILD ... aSegmentArray) {
        this._allocSegmentFactory = SectionComposite.toAllocFactory(aAllocSegmentFactory, aSegmentFactory);
        this._allocSegments = SectionComposite.toAllocArray(SectionComposite.toAllocFactory(aAllocSegmentFactory, aSegmentFactory), aSegmentArray);
        this._segmentFactory = aSegmentFactory;
    }

    public SectionComposite(Class<ALLOC> aAllocSegmentClass, Class<CHILD> aSegmentClass) {
        this._allocSegmentFactory = SectionComposite.toAllocFactory(aAllocSegmentClass, aSegmentClass);
        this._allocSegments = (AllocSectionDecoratorSegment[])Array.newInstance(aAllocSegmentClass, 0);
        this._segmentFactory = new ClassTypeFactory<CHILD>(aSegmentClass);
    }

    @SafeVarargs
    public SectionComposite(Class<ALLOC> aAllocSegmentClass, Class<CHILD> aSegmentClass, CHILD ... aSegmentArray) {
        this._allocSegmentFactory = SectionComposite.toAllocFactory(aAllocSegmentClass, aSegmentClass);
        this._allocSegments = SectionComposite.toAllocArray(new ClassTypeFactory<ALLOC>(aAllocSegmentClass), aSegmentArray);
        this._segmentFactory = new ClassTypeFactory<CHILD>(aSegmentClass);
    }

    @Override
    public Sequence toSequence() {
        ByteArraySequence theSequence = new ByteArraySequence();
        if (this._allocSegments != null) {
            for (ALLOC _allocSegment : this._allocSegments) {
                theSequence.append(((AbstractLengthDecoratorSegment)_allocSegment).toSequence());
            }
        }
        return theSequence;
    }

    @Override
    public void reset() {
        if (this._allocSegments != null && this._allocSegments.length != 0) {
            for (ALLOC eSegments : this._allocSegments) {
                ((AbstractReferenceeLengthSegment)eSegments).reset();
            }
        }
    }

    @Override
    public SerialSchema toSchema() {
        Schema[] theSchemas = null;
        if (this._allocSegments != null && this._allocSegments.length != 0) {
            theSchemas = new SerialSchema[this._allocSegments.length];
            for (int i = 0; i < theSchemas.length; ++i) {
                theSchemas[i] = ((AbstractLengthDecoratorSegment)this._allocSegments[i]).toSchema();
            }
        }
        return SerialSchema.builder().withInstance(this).withValue(this.toSequence()).withLength(this.getLength()).withDescription("An array segment containing a variable length elements array as payload.").withChildren(theSchemas).build();
    }

    @Override
    public int getLength() {
        int theLength = 0;
        if (this._allocSegments != null) {
            for (ALLOC _allocSegment : this._allocSegments) {
                theLength += ((AbstractLengthDecoratorSegment)_allocSegment).getLength();
            }
        }
        return theLength;
    }

    @Override
    public CHILD[] getChildren() {
        Section[] theSegments = (Section[])Array.newInstance(this._segmentFactory.getType(), this._allocSegments.length);
        for (int i = 0; i < theSegments.length; ++i) {
            theSegments[i] = (Section)((AbstractLengthDecoratorSegment)this._allocSegments[i]).getDecoratee();
        }
        return theSegments;
    }

    @Override
    public void fromTransmission(Sequence aSequence, int aOffset, int aLength) throws TransmissionException {
        int eOffset = aOffset;
        ArrayList<AllocSectionDecoratorSegment> theAllocSegments = new ArrayList<AllocSectionDecoratorSegment>();
        while (aOffset + aLength > eOffset) {
            AllocSectionDecoratorSegment eAllocSegment = (AllocSectionDecoratorSegment)this._allocSegmentFactory.create();
            eOffset = eAllocSegment.fromTransmission(aSequence, eOffset);
            theAllocSegments.add(eAllocSegment);
        }
        this._allocSegments = theAllocSegments.toArray((AllocSectionDecoratorSegment[])Array.newInstance(this._allocSegments.getClass().getComponentType(), theAllocSegments.size()));
    }

    @Override
    public void receiveFrom(InputStream aInputStream, int aLength, OutputStream aReturnStream) throws IOException {
        AllocSectionDecoratorSegment eAllocSegment;
        ArrayList<AllocSectionDecoratorSegment> theAllocSegments = new ArrayList<AllocSectionDecoratorSegment>();
        for (int theLength = 0; aLength > theLength; theLength += eAllocSegment.getLength()) {
            eAllocSegment = (AllocSectionDecoratorSegment)this._allocSegmentFactory.create();
            eAllocSegment.receiveFrom(aInputStream, aReturnStream);
            theAllocSegments.add(eAllocSegment);
        }
        this._allocSegments = theAllocSegments.toArray((AllocSectionDecoratorSegment[])Array.newInstance(this._allocSegments.getClass().getComponentType(), theAllocSegments.size()));
    }

    protected void setChildren(CHILD[] aChildren) {
        this._allocSegments = SectionComposite.toAllocArray(SectionComposite.toAllocFactory(this._allocSegmentFactory, this._segmentFactory), aChildren);
    }

    private static <ALLOC extends AllocSectionDecoratorSegment<SEGMENT>, SEGMENT extends Section> ALLOC[] toAllocArray(TypeFactory<ALLOC> aAllocFactory, SEGMENT[] aSegmentArray) {
        AllocSectionDecoratorSegment[] theAllocSegments = new AllocSectionDecoratorSegment[aSegmentArray.length];
        for (int i = 0; i < theAllocSegments.length; ++i) {
            theAllocSegments[i] = (AllocSectionDecoratorSegment)aAllocFactory.create();
            theAllocSegments[i].setDecoratee(aSegmentArray[i]);
        }
        return theAllocSegments;
    }

    private static <ALLOC extends AllocSectionDecoratorSegment<SEGMENT>, SEGMENT extends Section> TypeFactory<ALLOC> toAllocFactory(final TypeFactory<ALLOC> aAllocSegmentFactory, final TypeFactory<SEGMENT> aSegmentFactory) {
        return new TypeFactory<ALLOC>(){
            private Class<ALLOC> _type = null;

            @Override
            public ALLOC create() {
                AllocSectionDecoratorSegment theAllocSegment = (AllocSectionDecoratorSegment)aAllocSegmentFactory.create();
                if (this._type == null) {
                    this._type = theAllocSegment.getClass();
                }
                theAllocSegment.setDecoratee((Section)aSegmentFactory.create());
                return theAllocSegment;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Class<ALLOC> getType() {
                if (this._type == null) {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this._type == null) {
                            this._type = this.create().getClass();
                        }
                    }
                }
                return this._type;
            }
        };
    }

    private static <ALLOC extends AllocSectionDecoratorSegment<SEGMENT>, SEGMENT extends Section> TypeFactory<ALLOC> toAllocFactory(final Class<ALLOC> aAllocSegmentClass, final Class<SEGMENT> aSegmentClass) {
        return new TypeFactory<ALLOC>(){
            TypeFactory<ALLOC> _allocSegmentFactory;
            TypeFactory<SEGMENT> _segmentSegmentFactory;
            {
                this._allocSegmentFactory = new ClassTypeFactory(aAllocSegmentClass);
                this._segmentSegmentFactory = new ClassTypeFactory(aSegmentClass);
            }

            @Override
            public ALLOC create() {
                AllocSectionDecoratorSegment theAllocSegment = (AllocSectionDecoratorSegment)this._allocSegmentFactory.create();
                theAllocSegment.setDecoratee((Section)this._segmentSegmentFactory.create());
                return theAllocSegment;
            }

            @Override
            public Class<ALLOC> getType() {
                return aAllocSegmentClass;
            }
        };
    }
}

