/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.refcodes.serial.AbstractMagicBytesTransmissionMultiplexer;
import org.refcodes.serial.BadCrcChecksumException;
import org.refcodes.serial.BadMagicBytesException;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.Section;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialTransceiver;
import org.refcodes.serial.Transmission;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionSequenceException;

public class MagicBytesSectionMultiplexer
extends AbstractMagicBytesTransmissionMultiplexer<Section>
implements Section {
    private static final long serialVersionUID = 1L;

    public MagicBytesSectionMultiplexer() {
    }

    public MagicBytesSectionMultiplexer(Collection<Section> aSections, int aReadLimit) {
        super(aSections, aReadLimit);
    }

    public MagicBytesSectionMultiplexer(Collection<Section> aSections) {
        super(aSections);
    }

    public MagicBytesSectionMultiplexer(int aReadLimit, Section ... aSections) {
        super(aReadLimit, (Transmission[])aSections);
    }

    public MagicBytesSectionMultiplexer(Section ... aSections) {
        super((Transmission[])aSections);
    }

    @Override
    public void fromTransmission(byte[] aChunk, int aLength) throws TransmissionException {
        this.fromTransmission(new ByteArraySequence(aChunk), 0, aLength);
    }

    @Override
    public void fromTransmission(Sequence aSequence, int aLength) throws TransmissionException {
        this.fromTransmission(aSequence, 0, aLength);
    }

    @Override
    public void fromTransmission(byte[] aChunk, int aOffset, int aLength) throws TransmissionException {
        this.fromTransmission(new ByteArraySequence(aChunk), aOffset, aLength);
    }

    @Override
    public void receiveFrom(InputStream aInputStream, int aLength) throws IOException {
        this.receiveFrom(aInputStream, aLength, null);
    }

    @Override
    public void receiveFrom(SerialTransceiver aSerialTransceiver, int aLength) throws IOException {
        this.receiveFrom(aSerialTransceiver.getInputStream(), aLength, aSerialTransceiver.getOutputStream());
    }

    @Override
    public void fromTransmission(Sequence aSequence, int aOffset, int aLength) throws TransmissionException {
        if (this._children != null) {
            for (Section a_children : (Section[])this._children) {
                try {
                    a_children.fromTransmission(aSequence, aOffset, aLength);
                    this._responsibility = a_children;
                    return;
                }
                catch (BadCrcChecksumException | BadMagicBytesException transmissionException) {
                }
            }
        }
        throw new TransmissionSequenceException(aSequence, aOffset, "There are no segments to which to transmit the given sequence!");
    }

    @Override
    public void receiveFrom(InputStream aInputStream, int aLength, OutputStream aReturnStream) throws IOException {
        if (this._children != null) {
            BufferedInputStream theInputStream = new BufferedInputStream(aInputStream);
            theInputStream.mark(this._readLimit);
            for (Section a_children : (Section[])this._children) {
                try {
                    a_children.receiveFrom(theInputStream, aLength, aReturnStream);
                    this._responsibility = a_children;
                    return;
                }
                catch (BadCrcChecksumException | BadMagicBytesException ignore) {
                    theInputStream.reset();
                }
            }
        }
        throw new TransmissionException("There are no segments to which to transmit the given transmission to!");
    }
}

