/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.data.DaemonLoopSleepTime;
import org.refcodes.mixin.InputStreamAccessor;
import org.refcodes.mixin.OutputStreamAccessor;
import org.refcodes.serial.AbstractPort;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.PortMetrics;
import org.refcodes.serial.Sequence;

public class LoopbackPort
extends AbstractPort<PortMetrics> {
    protected ByteArraySequence _transmitSequence = new ByteArraySequence();
    protected LoopbackPort _crossoverPort = this;

    public LoopbackPort(String aAlias) {
        this(aAlias, null);
    }

    public LoopbackPort(String aAlias, ExecutorService aExecutorService) {
        super(aAlias, new PortMetrics(){}, aExecutorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transmitSequence(Sequence aSequence) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Cannot transmit data as the connection is in status <" + String.valueOf((Object)this.getConnectionStatus()) + ">!");
        }
        OutputStreamAccessor outputStreamAccessor = this._transmitSequence;
        synchronized (outputStreamAccessor) {
            this._transmitSequence.append(aSequence);
        }
        outputStreamAccessor = this._crossoverPort;
        synchronized (outputStreamAccessor) {
            this._crossoverPort.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveBytes(byte[] aBuffer, int aOffset, int aLength) throws IOException {
        InputStreamAccessor inputStreamAccessor;
        if (!this.isOpened()) {
            throw new IOException("Cannot receive data as the connection is in status <" + String.valueOf((Object)this.getConnectionStatus()) + ">!");
        }
        while (this.available() < aLength && this.getConnectionStatus() == ConnectionStatus.OPENED) {
            inputStreamAccessor = this;
            synchronized (inputStreamAccessor) {
                try {
                    this.wait(DaemonLoopSleepTime.MIN.getTimeMillis());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.available() < aLength) {
            if (this.getConnectionStatus() == ConnectionStatus.CLOSED) {
                throw new IOException("Connection is closed and only <" + this.available() + "> bytes out of requested <" + aLength + "> bytes are available!");
            }
            throw new IOException("Only <" + this.available() + "> bytes out of requested <" + aLength + "> bytes are available!");
        }
        inputStreamAccessor = this._crossoverPort._transmitSequence;
        synchronized (inputStreamAccessor) {
            this._crossoverPort._transmitSequence.toBytes(0, aLength, aBuffer, aOffset);
            byte[] theBytes = this._crossoverPort._transmitSequence.toBytes(aLength, this._crossoverPort._transmitSequence.getLength() - aLength);
            this._crossoverPort._transmitSequence.replace(theBytes);
        }
    }

    @Override
    public PortMetrics getPortMetrics() {
        return this._portMetrics;
    }

    @Override
    public String getAlias() {
        return this._alias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() {
        ByteArraySequence byteArraySequence = this._crossoverPort._transmitSequence;
        synchronized (byteArraySequence) {
            return this._crossoverPort._transmitSequence.getLength();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws IOException {
        super.open();
        LoopbackPort loopbackPort = this;
        synchronized (loopbackPort) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        super.close();
        this._transmitSequence.empty();
        try {
            this.skipAvailable();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LoopbackPort loopbackPort = this;
        synchronized (loopbackPort) {
            this.notifyAll();
        }
    }

    @Override
    public LoopbackPort withOpen() throws IOException {
        this.open();
        return this;
    }

    @Override
    public LoopbackPort withOpen(PortMetrics aPortMetrics) throws IOException {
        this.open(aPortMetrics);
        return this;
    }

    @Override
    public LoopbackPort withOpenUnchecked() {
        this.openUnchecked();
        return this;
    }

    @Override
    public LoopbackPort withOpenUnchecked(PortMetrics aPortMetrics) {
        this.openUnchecked(aPortMetrics);
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [alias=" + this._alias + ", transmitSequence=" + String.valueOf(this._transmitSequence) + ", receiveSequence=" + String.valueOf(this._crossoverPort._transmitSequence) + ", portMetrics=" + String.valueOf(this._portMetrics) + "]";
    }

    protected void setCrossoverPort(LoopbackPort aPort) {
        this._crossoverPort = aPort;
    }
}

