/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.nio.charset.Charset;
import org.refcodes.mixin.EncodingAccessor;
import org.refcodes.numerical.Endianess;
import org.refcodes.numerical.EndianessAccessor;
import org.refcodes.serial.ComplexTypeSegment;
import org.refcodes.serial.DynamicTypeTransmission;
import org.refcodes.serial.LengthWidthAccessor;
import org.refcodes.serial.Section;
import org.refcodes.serial.SequenceSection;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.struct.SimpleTypeTable;
import org.refcodes.textual.CaseStyleBuilder;

public class DynamicTypeSection
extends SequenceSection
implements Section,
LengthWidthAccessor,
EndianessAccessor,
EncodingAccessor<Charset>,
DynamicTypeTransmission {
    private static final long serialVersionUID = 1L;
    private Charset _charset;
    private Endianess _endianess;
    private int _lengthWidth;
    private ComplexTypeSegment<?> _segment = null;

    public DynamicTypeSection() {
        this(CaseStyleBuilder.asCamelCase(DynamicTypeSection.class.getSimpleName()), 4, TransmissionMetrics.DEFAULT_ENDIANESS, TransmissionMetrics.DEFAULT_ENCODING);
    }

    public DynamicTypeSection(Charset aCharset) {
        this(CaseStyleBuilder.asCamelCase(DynamicTypeSection.class.getSimpleName()), 4, TransmissionMetrics.DEFAULT_ENDIANESS, aCharset);
    }

    public DynamicTypeSection(int aLengthWidth, Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase(DynamicTypeSection.class.getSimpleName()), aLengthWidth, aEndianess, TransmissionMetrics.DEFAULT_ENCODING);
    }

    public DynamicTypeSection(int aLengthWidth, Endianess aEndianess, Charset aCharset) {
        this(CaseStyleBuilder.asCamelCase(DynamicTypeSection.class.getSimpleName()), aLengthWidth, aEndianess, aCharset);
    }

    public DynamicTypeSection(String aAlias) {
        this(aAlias, 4, TransmissionMetrics.DEFAULT_ENDIANESS, TransmissionMetrics.DEFAULT_ENCODING);
    }

    public DynamicTypeSection(String aAlias, Charset aCharset) {
        this(aAlias, 4, TransmissionMetrics.DEFAULT_ENDIANESS, aCharset);
    }

    public DynamicTypeSection(String aAlias, int aLengthWidth, Endianess aEndianess) {
        this(aAlias, aLengthWidth, aEndianess, TransmissionMetrics.DEFAULT_ENCODING);
    }

    public DynamicTypeSection(String aAlias, int aLengthWidth, Endianess aEndianess, Charset aCharset) {
        super(aAlias);
        this._lengthWidth = aLengthWidth;
        this._endianess = aEndianess;
        this._charset = aCharset;
    }

    public <T> DynamicTypeSection(String aAlias, T aValue) {
        super(aAlias);
        this.fromType(aValue);
    }

    public <T> DynamicTypeSection(String aAlias, T aValue, Charset aCharset) {
        this(aAlias, aCharset);
        this.fromType(aValue);
    }

    public <T> DynamicTypeSection(String aAlias, T aValue, Charset aCharset, String ... aAttributes) {
        this(aAlias, aCharset);
        this.fromType(aValue, aAttributes);
    }

    public <T> DynamicTypeSection(String aAlias, T aValue, int aLengthWidth, Endianess aEndianess) {
        this(aAlias, aLengthWidth, aEndianess);
        this.fromType(aValue);
    }

    public <T> DynamicTypeSection(String aAlias, T aValue, int aLengthWidth, Endianess aEndianess, Charset aCharset) {
        this(aAlias, aLengthWidth, aEndianess, aCharset);
        this.fromType(aValue);
    }

    public <T> DynamicTypeSection(String aAlias, T aValue, int aLengthWidth, Endianess aEndianess, Charset aCharset, String ... aAttributes) {
        this(aAlias, aLengthWidth, aEndianess, aCharset);
        this.fromType(aValue, aAttributes);
    }

    public <T> DynamicTypeSection(String aAlias, T aValue, int aLengthWidth, Endianess aEndianess, String ... aAttributes) {
        this(aAlias, aLengthWidth, aEndianess);
        this.fromType(aValue, aAttributes);
    }

    public <T> DynamicTypeSection(String aAlias, T aValue, String ... aAttributes) {
        super(aAlias);
        this.fromType(aValue, aAttributes);
    }

    public <T> DynamicTypeSection(String aAlias, T aValue, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, aTransmissionMetrics.getLengthWidth(), aTransmissionMetrics.getEndianess(), aTransmissionMetrics.getEncoding());
        this.fromType(aValue);
    }

    public <T> DynamicTypeSection(String aAlias, T aValue, TransmissionMetrics aTransmissionMetrics, String ... aAttributes) {
        this(aAlias, aTransmissionMetrics.getLengthWidth(), aTransmissionMetrics.getEndianess(), aTransmissionMetrics.getEncoding());
        this.fromType(aValue, aAttributes);
    }

    public DynamicTypeSection(String aAlias, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, aTransmissionMetrics.getLengthWidth(), aTransmissionMetrics.getEndianess(), aTransmissionMetrics.getEncoding());
    }

    public <T> DynamicTypeSection(T aValue) {
        this(CaseStyleBuilder.asCamelCase(DynamicTypeSection.class.getSimpleName()), aValue, 4, TransmissionMetrics.DEFAULT_ENDIANESS, TransmissionMetrics.DEFAULT_ENCODING);
    }

    public <T> DynamicTypeSection(T aValue, Charset aCharset) {
        this(CaseStyleBuilder.asCamelCase(DynamicTypeSection.class.getSimpleName()), aValue, 4, TransmissionMetrics.DEFAULT_ENDIANESS, aCharset);
    }

    public <T> DynamicTypeSection(T aValue, Charset aCharset, String ... aAttributes) {
        this(CaseStyleBuilder.asCamelCase(DynamicTypeSection.class.getSimpleName()), aValue, 4, TransmissionMetrics.DEFAULT_ENDIANESS, aCharset, aAttributes);
    }

    public <T> DynamicTypeSection(T aValue, int aLengthWidth, Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase(DynamicTypeSection.class.getSimpleName()), aValue, aLengthWidth, aEndianess, TransmissionMetrics.DEFAULT_ENCODING);
    }

    public <T> DynamicTypeSection(T aValue, int aLengthWidth, Endianess aEndianess, Charset aCharset) {
        this(CaseStyleBuilder.asCamelCase(DynamicTypeSection.class.getSimpleName()), aValue, aLengthWidth, aEndianess, aCharset);
    }

    public <T> DynamicTypeSection(T aValue, int aLengthWidth, Endianess aEndianess, Charset aCharset, String ... aAttributes) {
        this(CaseStyleBuilder.asCamelCase(DynamicTypeSection.class.getSimpleName()), aValue, aLengthWidth, aEndianess, aCharset, aAttributes);
    }

    public <T> DynamicTypeSection(T aValue, int aLengthWidth, Endianess aEndianess, String ... aAttributes) {
        this(CaseStyleBuilder.asCamelCase(DynamicTypeSection.class.getSimpleName()), aValue, aLengthWidth, aEndianess, aAttributes);
    }

    public <T> DynamicTypeSection(T aValue, String ... aAttributes) {
        this(CaseStyleBuilder.asCamelCase(DynamicTypeSection.class.getSimpleName()), aValue, 4, TransmissionMetrics.DEFAULT_ENDIANESS, TransmissionMetrics.DEFAULT_ENCODING, aAttributes);
    }

    public <T> DynamicTypeSection(T aValue, TransmissionMetrics aTransmissionMetrics) {
        this(CaseStyleBuilder.asCamelCase(DynamicTypeSection.class.getSimpleName()), aValue, aTransmissionMetrics.getLengthWidth(), aTransmissionMetrics.getEndianess(), aTransmissionMetrics.getEncoding());
    }

    public <T> DynamicTypeSection(T aValue, TransmissionMetrics aTransmissionMetrics, String ... aAttributes) {
        this(CaseStyleBuilder.asCamelCase(DynamicTypeSection.class.getSimpleName()), aValue, aTransmissionMetrics.getLengthWidth(), aTransmissionMetrics.getEndianess(), aTransmissionMetrics.getEncoding());
    }

    public DynamicTypeSection(TransmissionMetrics aTransmissionMetrics) {
        this(CaseStyleBuilder.asCamelCase(DynamicTypeSection.class.getSimpleName()), aTransmissionMetrics.getLengthWidth(), aTransmissionMetrics.getEndianess(), aTransmissionMetrics.getEncoding());
    }

    @Override
    public <T> void fromType(T aValue) {
        this._segment = new ComplexTypeSegment<T>(aValue, this._lengthWidth, this._endianess, this.getEncoding());
        this._sequence = this._segment.toSequence();
    }

    @Override
    public <T> void fromType(T aValue, String ... aAttributes) {
        ComplexTypeSegment<T> theSegment = new ComplexTypeSegment<T>(aValue, this._lengthWidth, this._endianess, this.getEncoding(), aAttributes);
        this._sequence = theSegment.toSequence();
    }

    @Override
    public Charset getEncoding() {
        return this._charset;
    }

    @Override
    public Endianess getEndianess() {
        return this._endianess;
    }

    @Override
    public int getLengthWidth() {
        return this._lengthWidth;
    }

    @Override
    public void reset() {
        this._segment.reset();
        this._sequence.clear();
    }

    @Override
    public SerialSchema toSchema() {
        return SerialSchema.builder().withAlias(this.getAlias()).withInstance(this).withValue(this.toSequence()).withLength(this.getLength()).withDescription("A segment containing a sequence as intermediate payload retrieved from a type and used for retrieving types after transmission.").build();
    }

    @Override
    public SimpleTypeTable toSimpleTypeTable() {
        return this._segment != null ? this._segment.toSimpleTypeTable() : super.toSimpleTypeTable();
    }

    @Override
    public <T> T toType(Class<T> aType) {
        ComplexTypeSegment<Class<T>> theSegment = new ComplexTypeSegment<Class<T>>(aType, this._lengthWidth, this._endianess, this.getEncoding());
        try {
            int theOffset = theSegment.fromTransmission(this._sequence);
            if (theOffset != this._sequence.getLength()) {
                throw new IllegalArgumentException("Cannot create instance of type <" + aType.getName() + "> as the processed length <" + theOffset + "> does not match the sequence's <" + this._sequence.toHexString() + "> length <" + this._sequence.getLength() + ">!");
            }
        }
        catch (TransmissionException e) {
            throw new IllegalArgumentException("Cannot create instance of type <" + aType.getName() + "> for sequence <" + this._sequence.toHexString() + ">!", e);
        }
        return (T)theSegment.getPayload();
    }

    @Override
    public <T> T toType(Class<T> aType, String ... aAttributes) {
        ComplexTypeSegment<Class<T>> theSegment = new ComplexTypeSegment<Class<T>>(aType, this._lengthWidth, this._endianess, this.getEncoding(), aAttributes);
        try {
            int theOffset = theSegment.fromTransmission(this._sequence);
            if (theOffset != this._sequence.getLength()) {
                throw new IllegalArgumentException("Cannot create instance of type <" + aType.getName() + "> as the processed length <" + theOffset + "> does not match the sequence's <" + this._sequence.toHexString() + "> length <" + this._sequence.getLength() + ">!");
            }
        }
        catch (TransmissionException e) {
            throw new IllegalArgumentException("Cannot create instance of type <" + aType.getName() + "> for sequence <" + this._sequence.toHexString() + ">!", e);
        }
        return (T)theSegment.getPayload();
    }
}

