/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import org.refcodes.serial.AbstractCipherTransmissionDecorator;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SequenceInputStream;
import org.refcodes.serial.TransmissionException;

public class CipherSegmentDecorator<DECORATEE extends Segment>
extends AbstractCipherTransmissionDecorator<DECORATEE>
implements Segment {
    private static final long serialVersionUID = 1L;

    public CipherSegmentDecorator(DECORATEE aDecoratee, Cipher aCipher) {
        super(aDecoratee, aCipher);
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        SequenceInputStream theSequenceInputStream = new SequenceInputStream(aSequence, aOffset);
        try {
            this.receiveFrom(theSequenceInputStream);
        }
        catch (IOException e) {
            throw new TransmissionException("Cannot receive transmission for sequence <" + aSequence.toHexString() + "> at offset <" + aOffset + ">!", e);
        }
        return theSequenceInputStream.getOffset();
    }

    @Override
    public void receiveFrom(InputStream aInputStream, OutputStream aReturnStream) throws IOException {
        CipherInputStream theCipherInputStream = new CipherInputStream(aInputStream, this._cipher);
        CipherOutputStream theCipherReturnStream = aReturnStream != null ? new CipherOutputStream(aReturnStream, this._cipher) : null;
        ((Segment)this._decoratee).receiveFrom(theCipherInputStream, theCipherReturnStream);
    }
}

