/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import org.refcodes.serial.AbstractPayloadSegment;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.textual.CaseStyleBuilder;

public class BooleanSegment
extends AbstractPayloadSegment<Boolean>
implements Segment {
    private static final long serialVersionUID = 1L;
    public static final int BYTES = 1;

    public BooleanSegment() {
        this(CaseStyleBuilder.asCamelCase(BooleanSegment.class.getSimpleName()));
    }

    public BooleanSegment(Boolean aValue) {
        this(CaseStyleBuilder.asCamelCase(BooleanSegment.class.getSimpleName()), aValue);
    }

    public BooleanSegment(String aAlias) {
        this(aAlias, false);
    }

    public BooleanSegment(String aAlias, Boolean aValue) {
        super(aAlias, aValue);
    }

    @Override
    public Sequence toSequence() {
        return new ByteArraySequence(new byte[]{(Boolean)this.getPayload() == true ? (byte)1 : 0});
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        boolean theBoolean = aSequence.getByteAt(aOffset) == 1;
        this.setPayload(theBoolean);
        return aOffset + 1;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public void reset() {
        this._payload = false;
    }

    @Override
    public SerialSchema toSchema() {
        return SerialSchema.builder().withAlias(this.getAlias()).withInstance(this).withValue(this.toSequence()).withLength(this.getLength()).withVerbose(String.valueOf(this.getPayload())).withDescription("A segment containing an boolean payload.").build();
    }

    @Override
    public BooleanSegment withPayload(Boolean aValue) {
        this.setPayload(aValue);
        return this;
    }
}

