/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.refcodes.component.ConnectionAutomatonImpl;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.serial.Port;
import org.refcodes.serial.PortMetrics;
import org.refcodes.serial.ReceiveSegmentConsumerDaemon;
import org.refcodes.serial.ReceiveSegmentResultDaemon;
import org.refcodes.serial.Segment;
import org.refcodes.serial.SegmentConsumer;
import org.refcodes.serial.SegmentResult;
import org.refcodes.serial.TransmitSegmentConsumerDaemon;
import org.refcodes.serial.TransmitSegmentResultDaemon;

public abstract class AbstractPort<PM extends PortMetrics>
extends ConnectionAutomatonImpl<PM>
implements Port<PM> {
    protected String _alias;
    protected PM _portMetrics;
    protected ExecutorService _executorService;

    protected AbstractPort(String aAlias, PM aPortMetrics) {
        this(aAlias, aPortMetrics, ControlFlowUtility.createCachedExecutorService(true));
    }

    protected AbstractPort(String aAlias, PM aPortMetrics, ExecutorService aExecutorService) {
        this._alias = aAlias;
        this._portMetrics = aPortMetrics;
        this._executorService = aExecutorService != null ? aExecutorService : ControlFlowUtility.createCachedExecutorService(true);
    }

    @Override
    public String getAlias() {
        return this._alias;
    }

    @Override
    public boolean isOpenable() {
        return !this.isOpened();
    }

    @Override
    public void open() throws IOException {
        this.open((PM)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(PM aConnection) throws IOException {
        if (aConnection != null) {
            this._portMetrics = aConnection;
        }
        super.open(this._portMetrics);
        AbstractPort abstractPort = this;
        synchronized (abstractPort) {
            this.notifyAll();
        }
    }

    public <HEADER extends Segment> void receiveSegment(HEADER aSegment) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Cannot receive a segment as the connection is in status <" + String.valueOf((Object)this.getConnectionStatus()) + ">!");
        }
        Port.super.receiveSegment(aSegment);
    }

    @Override
    public <SEGMENT extends Segment> void onReceiveSegment(SEGMENT aSegment, SegmentConsumer<SEGMENT> aSegmentConsumer) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Cannot receive a segment as the connection is in status <" + String.valueOf((Object)this.getConnectionStatus()) + ">!");
        }
        this._executorService.execute(new ReceiveSegmentConsumerDaemon<SEGMENT>(aSegmentConsumer, aSegment, this));
    }

    @Override
    public <SEGMENT extends Segment> SegmentResult<SEGMENT> onReceiveSegment(SEGMENT aSegment) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Cannot receive a segment as the connection is in status <" + String.valueOf((Object)this.getConnectionStatus()) + ">!");
        }
        ReceiveSegmentResultDaemon<SEGMENT> theDaemon = new ReceiveSegmentResultDaemon<SEGMENT>(aSegment, this);
        this._executorService.execute(theDaemon);
        return theDaemon.getSegmentResult();
    }

    @Override
    public <SEGMENT extends Segment> SegmentResult<SEGMENT> doTransmitSegment(SEGMENT aSegment) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Cannot receive a segment as the connection is in status <" + String.valueOf((Object)this.getConnectionStatus()) + ">!");
        }
        TransmitSegmentResultDaemon<SEGMENT> theDaemon = new TransmitSegmentResultDaemon<SEGMENT>(aSegment, this);
        this._executorService.execute(theDaemon);
        return theDaemon.getSegmentResult();
    }

    @Override
    public <SEGMENT extends Segment> void doTransmitSegment(SEGMENT aSegment, SegmentConsumer<SEGMENT> aSegmentConsumer) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Cannot transmit a segment as the connection is in status <" + String.valueOf((Object)this.getConnectionStatus()) + ">!");
        }
        this._executorService.execute(new TransmitSegmentConsumerDaemon<SEGMENT>(aSegmentConsumer, aSegment, this));
    }

    @Override
    public void close() throws IOException {
        super.close();
        this._executorService.shutdownNow();
    }
}

