/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.refcodes.exception.BugException;
import org.refcodes.io.BijectiveOutputStream;
import org.refcodes.io.InverseInputStream;
import org.refcodes.numerical.BijectiveFunction;
import org.refcodes.numerical.InverseFunction;
import org.refcodes.numerical.Invertible;
import org.refcodes.schema.Schema;
import org.refcodes.serial.AbstractTransmissionDecorator;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SequenceOutputStream;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.Transmission;

public abstract class AbstractInvertibleTransmissionDecorator<DECORATEE extends Transmission>
extends AbstractTransmissionDecorator<DECORATEE> {
    private static final long serialVersionUID = 1L;
    protected BijectiveFunction<Byte, Byte> _bijectiveFunction;
    protected InverseFunction<Byte, Byte> _inverseFunction;

    public AbstractInvertibleTransmissionDecorator(DECORATEE aDecoratee, Invertible<Byte, Byte> aInvertible) {
        super(aDecoratee);
        this._bijectiveFunction = aInvertible;
        this._inverseFunction = aInvertible;
    }

    public AbstractInvertibleTransmissionDecorator(DECORATEE aDecoratee, BijectiveFunction<Byte, Byte> aBijectiveFunction, InverseFunction<Byte, Byte> aInverseFunction) {
        super(aDecoratee);
        this._bijectiveFunction = aBijectiveFunction;
        this._inverseFunction = aInverseFunction;
    }

    @Override
    public void transmitTo(OutputStream aOutputStream, InputStream aReturnStream) throws IOException {
        BijectiveOutputStream theBijectiveOutputStream = new BijectiveOutputStream(aOutputStream, this._bijectiveFunction);
        InverseInputStream theInverseInputStream = aReturnStream != null ? new InverseInputStream(aReturnStream, this._inverseFunction) : null;
        this._decoratee.transmitTo(theBijectiveOutputStream, theInverseInputStream);
    }

    @Override
    public Sequence toSequence() {
        SequenceOutputStream theSequenceInputStream = new SequenceOutputStream();
        try {
            this.transmitTo(theSequenceInputStream);
        }
        catch (IOException e) {
            throw new BugException("Encountered an I/O related bug which cannot occur as we merely use streams in memory!", e);
        }
        return theSequenceInputStream.getSequence();
    }

    @Override
    public SerialSchema toSchema() {
        return SerialSchema.builder().withInstance(this).withValue(this.toSequence()).withLength(this.getLength()).withDescription("A transmission decorator enriching the encapsulated transmission with \"Bijectivce-Function\" as well as \"Inverse-Function\" functionality.").withChildren(new Schema[]{this.getDecoratee().toSchema()}).build();
    }
}

