/*
 * Decompiled with CFR 0.152.
 */
package club.funcodes.tty2mqtt;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.refcodes.archetype.CliHelper;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CharOption;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.ConfigOption;
import org.refcodes.cli.DebugFlag;
import org.refcodes.cli.EnumOption;
import org.refcodes.cli.Example;
import org.refcodes.cli.Flag;
import org.refcodes.cli.HelpFlag;
import org.refcodes.cli.InitFlag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.NoneOperand;
import org.refcodes.cli.Operand;
import org.refcodes.cli.QuietFlag;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.SysInfoFlag;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.exception.Trap;
import org.refcodes.exception.UnhandledEnumBugException;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.numerical.Endianess;
import org.refcodes.properties.ext.application.ApplicationProperties;
import org.refcodes.serial.AllocSectionDecoratorSegment;
import org.refcodes.serial.AsciizSegment;
import org.refcodes.serial.ByteArraySection;
import org.refcodes.serial.SerialSugar;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.alt.tty.Parity;
import org.refcodes.serial.alt.tty.StopBits;
import org.refcodes.serial.alt.tty.TtyPort;
import org.refcodes.serial.alt.tty.TtyPortHub;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.HorizAlignTextBuilder;
import org.refcodes.textual.SecretHintBuilder;
import org.refcodes.textual.VerboseTextBuilder;
import sun.misc.Unsafe;

public class Main {
    private static final RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final String NAME = "tty2mqtt";
    private static final String TITLE = "TTY.2.M\u213aTT";
    private static final String DEFAULT_CONFIG = "tty2mqtt.ini";
    private static final char[] BANNER_PALETTE;
    private static final Font BANNER_FONT;
    private static final String COPYRIGHT = "Copyright (c) by CLUB.FUNCODES | See [https://www.metacodes.pro/manpages/tty2mqtt_manpage]";
    private static final String LICENSE_NOTE = "You may choose between the LGPL v3.0 or later and the Apache License v2.0 when using this software";
    private static final String DESCRIPTION = "Tool bridging between a serial port and an MQTT message broker for publishing or subscribing messages (see [https://www.metacodes.pro/manpages/tty2mqtt_manpage]).";
    private static final String CONF_PORT = "tty/port";
    private static final String CONF_BAUD = "tty/baud";
    private static final String CONF_DATA_BITS = "tty/dataBits";
    private static final String CONF_STOP_BITS = "tty/stopBits";
    private static final String CONF_PARITY = "tty/parity";
    private static final String CONF_COMMENT_PREFIX = "tty/message/comment/prefix";
    private static final String CONF_MESSAGE_LENGTH_ENDIANESS = "tty/message/length/endianess";
    private static final String CONF_MESSAGE_LENGTH_WIDTH = "tty/message/length/width";
    private static final String CONF_MESSAGE_SUFFIX = "tty/message/suffix";
    private static final String CONF_TOPIC_PREFIX = "tty/message/topic/prefix";
    private static final String CONF_TOPIC_SEPARATOR = "tty/message/topic/separator";
    private static final String CONF_BROKER_URL = "mqtt/broker/url";
    private static final String CONF_BROKER_USER = "mqtt/broker/user";
    private static final String CONF_BROKER_SECRET = "mqtt/broker/secret";
    private static final String CONF_PUBLISHER_ID = "mqtt/publisher/id";
    private static final String CONF_PUBLISHER_RETAINED_FLAG = "mqtt/publisher/retained";
    private static final String CONF_PUBLISHER_QOS_VALUE = "mqtt/publisher/qos";
    private static final String CONF_PUBLISHER_TOPIC = "mqtt/publisher/topic";
    private static final String CONF_SUBSCRIBER_TOPIC = "mqtt/subscriber/topic";
    private static final String CONF_SUBSCRIBER_MODE = "mqtt/subscriber/mode";
    private static final int DEFAULT_QOS = 0;
    private static final boolean DEFAULT_RETAINED_FLAG = false;
    private static final int DEFAULT_BAUD_RATE = 9600;
    private static final int DEFAULT_DATA_BITS = 8;
    private static final String DEFAULT_MESSAGE_SUFFIX = "\n";
    private static final PayloadMode DEFAULT_SUBSCRIBER_MODE;
    private static final int DEFAULT_MESSAGE_LENGTH_WIDTH = 2;
    private static final Endianess DEFAULT_MESSAGE_LENGTH_ENDIANESS;

    private static void disableIllegalReflectiveAccessWarning() {
        try {
            Field theUnsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafeField.setAccessible(true);
            Unsafe theUnsafe = (Unsafe)theUnsafeField.get(null);
            Class<?> theClass = Class.forName("jdk.internal.module.IllegalAccessLogger");
            Field theLogger = theClass.getDeclaredField("logger");
            theUnsafe.putObjectVolatile(theClass, theUnsafe.staticFieldOffset(theLogger), null);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
    }

    public Main(ApplicationProperties aProperties) throws IOException, MqttException {
        Boolean isQuiet = aProperties.getBoolean("quiet");
        Boolean isDebug = aProperties.getBoolean("debug");
        Boolean isPublisherRetained = aProperties.getBooleanOr(CONF_PUBLISHER_RETAINED_FLAG, (Boolean)false);
        int thePublisherQos = aProperties.getIntOr(CONF_PUBLISHER_QOS_VALUE, (Integer)0);
        String thePublisherId = (String)aProperties.get((Object)CONF_PUBLISHER_ID);
        String thePublisherTopic = (String)aProperties.get((Object)CONF_PUBLISHER_TOPIC);
        String theSubscriberTopic = (String)aProperties.get((Object)CONF_SUBSCRIBER_TOPIC);
        int theBaudRate = aProperties.getIntOr(CONF_BAUD, (Integer)9600);
        int theDataBits = aProperties.getIntOr(CONF_DATA_BITS, (Integer)8);
        Parity theParity = aProperties.getEnumOr(Parity.class, CONF_PARITY, Parity.NONE);
        StopBits theStopBits = aProperties.getEnumOr(StopBits.class, CONF_STOP_BITS, StopBits.AUTO);
        Character theCommentPrefix = aProperties.getChar(CONF_COMMENT_PREFIX);
        String theMessageSuffix = aProperties.getOr(CONF_MESSAGE_SUFFIX, DEFAULT_MESSAGE_SUFFIX);
        Byte theEndOfMessageChar = Main.toEndOfMessageByte(theMessageSuffix);
        PayloadMode theSubscriberMode = aProperties.getEnumOr(CONF_SUBSCRIBER_MODE, DEFAULT_SUBSCRIBER_MODE);
        Endianess theMessageLengthEndianess = aProperties.getEnumOr(CONF_MESSAGE_LENGTH_ENDIANESS, DEFAULT_MESSAGE_LENGTH_ENDIANESS);
        int theMessageLengthWidth = aProperties.getIntOr(CONF_MESSAGE_LENGTH_WIDTH, (Integer)2);
        Character theTopicPrefix = aProperties.getChar(CONF_TOPIC_PREFIX);
        Character theTopicSeparator = aProperties.getChar(CONF_TOPIC_SEPARATOR);
        String theBrokerUrl = (String)aProperties.get((Object)CONF_BROKER_URL);
        String theBrokerUser = (String)aProperties.get((Object)CONF_BROKER_USER);
        String theBrokerSecret = (String)aProperties.get((Object)CONF_BROKER_SECRET);
        String thePort = (String)aProperties.get((Object)CONF_PORT);
        if (!isQuiet.booleanValue()) {
            LOGGER.info("tty/port = " + thePort);
            LOGGER.info("tty/baud = " + theBaudRate);
            LOGGER.info("tty/dataBits = " + theDataBits);
            LOGGER.info("tty/stopBits = " + String.valueOf((Object)theStopBits));
            LOGGER.info("tty/parity = " + String.valueOf((Object)theParity));
            LOGGER.info("tty/message/suffix = " + theMessageSuffix);
            LOGGER.info("tty/message/length/width = " + theMessageLengthWidth);
            LOGGER.info("tty/message/length/endianess = " + String.valueOf((Object)theMessageLengthEndianess));
            LOGGER.info("tty/message/comment/prefix = " + theCommentPrefix);
            LOGGER.info("tty/message/topic/prefix = " + theTopicPrefix);
            LOGGER.info("tty/message/topic/separator = " + theTopicSeparator);
            LOGGER.info("mqtt/publisher/id = " + thePublisherId);
            LOGGER.info("mqtt/publisher/topic = " + thePublisherTopic);
            LOGGER.info("mqtt/publisher/retained = " + isPublisherRetained);
            LOGGER.info("mqtt/publisher/qos = " + thePublisherQos);
            LOGGER.info("mqtt/subscriber/topic = " + theSubscriberTopic);
            LOGGER.info("mqtt/subscriber/mode = " + String.valueOf((Object)theSubscriberMode));
            LOGGER.info("mqtt/broker/url = " + theBrokerUrl);
            LOGGER.info("mqtt/broker/user = " + (theBrokerUser != null ? theBrokerUser : ""));
            LOGGER.info("mqtt/broker/secret = " + (theBrokerSecret != null ? SecretHintBuilder.asString(theBrokerSecret) : ""));
            LOGGER.printSeparator();
        }
        TtyPortHub theTtyPortHub = new TtyPortHub();
        TtyPort theTtyPort = ((TtyPort)theTtyPortHub.toPort(thePort)).withOpen(theBaudRate, theDataBits, theStopBits, theParity);
        try {
            MqttClient theMqttClient = new MqttClient(theBrokerUrl, thePublisherId);
            try {
                MqttConnectOptions theOptions = new MqttConnectOptions();
                theOptions.setAutomaticReconnect(true);
                theOptions.setCleanSession(true);
                theOptions.setConnectionTimeout(10);
                if (theBrokerUser != null && theBrokerUser.length() != 0) {
                    theOptions.setUserName(theBrokerUser);
                    if (theBrokerSecret != null && theBrokerSecret.length() != 0) {
                        theOptions.setPassword(theBrokerSecret.toCharArray());
                    }
                }
                theMqttClient.connect(theOptions);
                ByteArraySection theSubscribeBinaryPayload = SerialSugar.byteArraySection();
                AllocSectionDecoratorSegment<ByteArraySection> theSubscribeBinaryMessage = SerialSugar.allocSegment(theSubscribeBinaryPayload, theMessageLengthWidth, theMessageLengthEndianess);
                AsciizSegment theSubscribeAsciiMessage = SerialSugar.asciizSegment(theEndOfMessageChar);
                theMqttClient.subscribe(theSubscriberTopic, (string, msg) -> {
                    byte[] thePayload = msg.getPayload();
                    switch (theSubscriberMode.ordinal()) {
                        case 1: {
                            if (!isQuiet.booleanValue()) {
                                LOGGER.info("TTY subscriber <" + thePublisherId + "> receives \"" + new String(thePayload, StandardCharsets.US_ASCII) + "\" from topic [" + theSubscriberTopic + "]...");
                            }
                            theSubscribeAsciiMessage.setPayload(thePayload);
                            theSubscribeAsciiMessage.transmitTo(theTtyPort);
                            if (!LOGGER.isLogInfo()) break;
                            LOGGER.printSeparator();
                            break;
                        }
                        case 0: {
                            theSubscribeBinaryPayload.setPayload(thePayload);
                            if (!isQuiet.booleanValue()) {
                                LOGGER.info("TTY subscriber <" + thePublisherId + "> receives <" + theSubscribeBinaryMessage.getLength() + "> bytes from topic [" + theSubscriberTopic + "]...");
                                LOGGER.info("Length width is <" + theSubscribeBinaryMessage.getLengthWidth() + "> bytes and payload length is <" + theSubscribeBinaryPayload.getLength() + "> bytes...");
                                if (LOGGER.isLogInfo()) {
                                    LOGGER.printSeparator();
                                }
                            }
                            theSubscribeBinaryMessage.transmitTo(theTtyPort);
                            break;
                        }
                        default: {
                            throw new UnhandledEnumBugException(theSubscriberMode);
                        }
                    }
                });
                AsciizSegment thePublishSegment = SerialSugar.asciizSegment(theEndOfMessageChar);
                block14: while (true) {
                    try {
                        while (true) {
                            thePublishSegment.receiveFrom(theTtyPort);
                            String ePublishPayload = (String)thePublishSegment.getPayload();
                            if (ePublishPayload == null || ePublishPayload.length() == 0) continue;
                            if (theCommentPrefix == null || !theCommentPrefix.equals(Character.valueOf(ePublishPayload.charAt(0)))) {
                                try {
                                    Message ePublishMessage = new Message(ePublishPayload, theTopicPrefix, theTopicSeparator, thePublisherTopic);
                                    if (ePublishMessage.topic == null || ePublishMessage.topic.isEmpty()) {
                                        LOGGER.info(ePublishPayload);
                                        continue block14;
                                    }
                                    MqttMessage ePublishMqttMessage = new MqttMessage(ePublishMessage.message.getBytes());
                                    ePublishMqttMessage.setQos(thePublisherQos);
                                    ePublishMqttMessage.setRetained(isPublisherRetained);
                                    try {
                                        theMqttClient.publish(ePublishMessage.topic, ePublishMqttMessage);
                                        if (isQuiet.booleanValue()) continue block14;
                                        LOGGER.info("TTY publisher <" + thePublisherId + "> published \"" + ePublishMessage.message.trim() + "\" to topic [" + ePublishMessage.topic + "]...");
                                    }
                                    catch (MqttException e) {
                                        LOGGER.error("TTY publisher <" + thePublisherId + "> cannot publish \"" + ePublishMessage.message.trim() + "\" to topic [" + ePublishMessage.topic + "] as of: " + Trap.asMessage(e), e);
                                    }
                                    continue block14;
                                }
                                catch (IllegalArgumentException e) {
                                    LOGGER.warn("Skipping payload as of: " + Trap.asMessage(e), e);
                                    continue;
                                }
                            }
                            if (isQuiet.booleanValue() && !isDebug.booleanValue()) continue;
                            LOGGER.info(ePublishPayload);
                        }
                    }
                    catch (TransmissionException e) {
                        LOGGER.warn(e.getMessage());
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                try {
                    theMqttClient.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            if (theTtyPort != null) {
                try {
                    theTtyPort.close();
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
            }
            throw throwable;
        }
    }

    public static void main(String[] args) {
        ConfigOption theConfigArg = CliSugar.configOption();
        NoneOperand theNoneArg = CliSugar.none("Uses the default configuration (file).");
        IntOption thePublisherQosArg = CliSugar.intOption("qos", CONF_PUBLISHER_QOS_VALUE, "The QOS (\"Quality-of-Service\") value to use when publishing from TTY to MQTT (defaults to <0>).");
        CharOption theCommentPrefixArg = CliSugar.charOption("comment-prefix", CONF_COMMENT_PREFIX, "The prefix for data from TTY (COM) serial port to ignore (log with INFO level) and NOT publish via MQTT broker.");
        CharOption theTopicPrefixArg = CliSugar.charOption("topic-prefix", CONF_TOPIC_PREFIX, "The prefix identifying a MQTT topic of data from TTY (COM) serial port, the message is published to the MQTT broker with the according topic.");
        CharOption theTopicSeparatorArg = CliSugar.charOption("topic-separator", CONF_TOPIC_SEPARATOR, "The character separating the data from TTY (COM) serial port into a MQTT topic and its message.");
        StringOption theMessageSuffixArg = CliSugar.stringOption("message-suffix", CONF_MESSAGE_SUFFIX, "End of message character for serial TTY (COM) data, a hex value (e.g. 0x00) denotes the actual value, an '\\n' denotes a newline.");
        StringOption theSubscriberTopicArg = CliSugar.stringOption("subscriber-topic", CONF_SUBSCRIBER_TOPIC, "The MQTT topic to subscribe to.");
        StringOption thePublisherIdArg = CliSugar.stringOption("publisher-id", CONF_PUBLISHER_ID, "The MQTT publisher ID to use.");
        StringOption thePublisherTopicArg = CliSugar.stringOption("publisher-topic", CONF_PUBLISHER_TOPIC, "The (default) MQTT topic to publish to, in case not stated otherwise in the message from TTY (COM) serial port.");
        StringOption theBrokerUrlArg = CliSugar.stringOption("broker-url", CONF_BROKER_URL, "The URL of the MQTT broker to connect with.");
        StringOption theBrokerUserArg = CliSugar.stringOption("broker-user", CONF_BROKER_USER, "The user name to use when connecting with the MQTT broker.");
        StringOption theBrokerSecretArg = CliSugar.stringOption("broker-secret", CONF_BROKER_SECRET, "The user' password to use when connecting with the MQTT broker.");
        StringOption thePortOption = CliSugar.stringOption(Character.valueOf('p'), "port", CONF_PORT, "The COM (serial) port to operate on.");
        IntOption theBaudOption = CliSugar.intOption(Character.valueOf('b'), "baud", CONF_BAUD, "The baud rate to use for the TTY (COM) serial port.");
        IntOption theDataBitsOption = CliSugar.intOption("data-bits", CONF_DATA_BITS, "The data bits to use for the TTY (COM) serial port (usually a value of 7 or 8).");
        IntOption theMessageLengthWidthOption = CliSugar.intOption("length-width", CONF_MESSAGE_LENGTH_WIDTH, "The number of bytes to use when prefixing the length of the binary data (usually a value of 1 or 2 denting max. lengths of 256 or 65536 ).");
        EnumOption<Endianess> theMessageLengthEndianessOption = CliSugar.enumOption("length-endianess", Endianess.class, CONF_MESSAGE_LENGTH_ENDIANESS, "The endianess to use for the prefixed length of the binary data: " + VerboseTextBuilder.asString((Object[])Endianess.values()));
        EnumOption<PayloadMode> theSubscriberModeOption = CliSugar.enumOption("subscriber-mode", PayloadMode.class, CONF_SUBSCRIBER_MODE, "Denotes the mode of operation, either processing binary or textual data: " + VerboseTextBuilder.asString((Object[])PayloadMode.values()));
        EnumOption<Parity> theParityOption = CliSugar.enumOption("parity", Parity.class, CONF_PARITY, "The parity to use for the TTY (COM) serial port: " + VerboseTextBuilder.asString((Object[])Parity.values()));
        EnumOption<StopBits> theStopBitsOption = CliSugar.enumOption("stop-bits", StopBits.class, CONF_STOP_BITS, "The stop bits to use for the TTY (COM) serial port: " + VerboseTextBuilder.asString((Object[])StopBits.values()));
        InitFlag theInitFlag = CliSugar.initFlag(false);
        Flag thePublisherRetainedFlag = CliSugar.flag("retained", CONF_PUBLISHER_RETAINED_FLAG, "The retained flag to use when publishing from TTY to MQTT (defaults to <false>).");
        Flag theListPortsFlag = CliSugar.flag(Character.valueOf('l'), "list", "list", "List all detected TTY (COM) serial ports.");
        SysInfoFlag theSysInfoFlag = CliSugar.sysInfoFlag(false);
        QuietFlag theQuietFlag = CliSugar.quietFlag();
        HelpFlag theHelpFlag = CliSugar.helpFlag();
        DebugFlag theDebugFlag = CliSugar.debugFlag();
        CasesCondition theArgsSyntax = CliSugar.cases(CliSugar.xor(theNoneArg, CliSugar.any(theConfigArg, thePortOption, theBaudOption, theDataBitsOption, theStopBitsOption, theParityOption, theBrokerUrlArg, theMessageSuffixArg, theMessageLengthWidthOption, theMessageLengthEndianessOption, theCommentPrefixArg, theTopicPrefixArg, theTopicSeparatorArg, theSubscriberModeOption, theSubscriberTopicArg, thePublisherIdArg, thePublisherTopicArg, thePublisherRetainedFlag, thePublisherQosArg, theQuietFlag, theDebugFlag, CliSugar.and(theBrokerUserArg, CliSugar.any(theBrokerSecretArg)))), CliSugar.and(theListPortsFlag, CliSugar.any(theQuietFlag, theDebugFlag)), CliSugar.and(theInitFlag, CliSugar.any(theConfigArg, theQuietFlag, theDebugFlag)), CliSugar.xor(theHelpFlag, CliSugar.and(theSysInfoFlag, CliSugar.any(theQuietFlag))));
        Example[] theExamples = CliSugar.examples(CliSugar.example("List all available TTY (COM) ports", theListPortsFlag), CliSugar.example("Create an initial configuration file", theInitFlag, theConfigArg), CliSugar.example("Specific configuration file to use", theConfigArg), CliSugar.example("Open the TTY (COM) serial port with given settings", thePortOption, theBaudOption, theDataBitsOption, theParityOption), CliSugar.example("Prefix and separator to parse TTY (COM) serial data", theTopicPrefixArg, theTopicSeparatorArg), CliSugar.example("Just log TTY (COM) serial data when prefixed", theCommentPrefixArg), CliSugar.example("Uses the default configuration (file)", new Operand[0]), CliSugar.example("To show the help text", theHelpFlag), CliSugar.example("To print the system info", theSysInfoFlag));
        CliHelper theCliHelper = ((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)CliHelper.builder().withArgs(args)).withArgsSyntax(theArgsSyntax)).withExamples(theExamples)).withFilePath(DEFAULT_CONFIG)).withResourceClass((Class)Main.class)).withName(NAME)).withTitle(TITLE)).withDescription(DESCRIPTION)).withLicense(LICENSE_NOTE)).withCopyright(COPYRIGHT)).withBannerFont(BANNER_FONT)).withBannerFontPalette(BANNER_PALETTE)).withLogger(LOGGER)).build();
        ApplicationProperties theArgsProperties = theCliHelper.getApplicationProperties();
        try {
            if (theArgsProperties.getBoolean((Object)theListPortsFlag).booleanValue()) {
                Main.listSerialPorts(theQuietFlag.isEnabled());
                System.exit(0);
            }
            new Main(theArgsProperties);
        }
        catch (Throwable e) {
            theCliHelper.exitOnException(e);
        }
    }

    private static void listSerialPorts(boolean isQuiet) throws IOException {
        TtyPortHub theTtyPortHub = new TtyPortHub();
        TtyPort[] thePorts = theTtyPortHub.ports();
        if (isQuiet) {
            for (TtyPort ePort : thePorts) {
                System.out.println(ePort.getAlias() + "\t" + ePort.getPortMetrics().getBaudRate() + " baud\t" + ePort.getDescription() + "\t" + ePort.getName());
            }
        } else if (thePorts.length != 0) {
            int theMaxWidth = 0;
            for (TtyPort ePort : thePorts) {
                int eWidth = ePort.getAlias().length();
                if (theMaxWidth >= eWidth) continue;
                theMaxWidth = eWidth;
            }
            HorizAlignTextBuilder theBuilder = new HorizAlignTextBuilder().withColumnWidth(theMaxWidth);
            for (TtyPort ePort : thePorts) {
                LOGGER.info("[" + theBuilder.toString(new String[]{ePort.getAlias()}) + "] " + ePort.getName() + ": \"" + ePort.getDescription() + "\" (" + ePort.getPortMetrics().getBaudRate() + " baud)");
            }
        } else {
            LOGGER.info("No serial (COM) ports found.");
        }
    }

    static Byte toEndOfMessageByte(String aMessageSuffix) {
        String theMessageSuffix = aMessageSuffix.replaceAll("\\\\n", DEFAULT_MESSAGE_SUFFIX).replaceAll("\\\\t", "\t").replaceAll("\\\\r", "\r").replaceAll("\\\\f", "\f").replaceAll("\\\\b", "\b");
        Byte theEndOfMessageChar = null;
        try {
            if (theMessageSuffix.startsWith("0x")) {
                theEndOfMessageChar = (byte)Integer.parseInt(theMessageSuffix.substring(2), 16);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (theEndOfMessageChar == null && theMessageSuffix.length() == 1) {
            theEndOfMessageChar = (byte)theMessageSuffix.charAt(0);
        }
        if (theEndOfMessageChar == null) {
            throw new IllegalArgumentException("Cannot convert property 'tty/message/suffix' with value \"" + aMessageSuffix + "\" to valid message suffix char.");
        }
        return theEndOfMessageChar;
    }

    static {
        Main.disableIllegalReflectiveAccessWarning();
        BANNER_PALETTE = AsciiColorPalette.MAX_LEVEL_GRAY.getPalette();
        BANNER_FONT = new Font(FontFamily.DIALOG, FontStyle.BOLD);
        DEFAULT_SUBSCRIBER_MODE = PayloadMode.ASCII;
        DEFAULT_MESSAGE_LENGTH_ENDIANESS = Endianess.LITTLE;
    }

    private static enum PayloadMode {
        BINARY,
        ASCII;

    }

    static class Message {
        public String topic = null;
        public String message = null;

        public Message(String aPayload, Character aTopicPrefix, Character aMessageSeparator, String aDefaultTopic) {
            if (aTopicPrefix != null && aTopicPrefix.equals(Character.valueOf(aPayload.charAt(0)))) {
                int eIndex = aPayload.indexOf(aMessageSeparator.charValue());
                if (eIndex == -1) {
                    throw new IllegalArgumentException("Unable to distinguish topic using separator '" + aMessageSeparator + "' from payload: \"" + aPayload + "\".");
                }
                this.topic = aPayload.substring(1, eIndex);
                this.message = aPayload.substring(eIndex + 1);
            } else {
                this.topic = aDefaultTopic;
                this.message = aPayload;
            }
        }
    }
}

