/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.refcodes.data.Delimiter;
import org.refcodes.data.Scheme;
import org.refcodes.mixin.CredentialsAccessor;
import org.refcodes.mixin.PathAccessor;
import org.refcodes.mixin.PortAccessor;
import org.refcodes.net.IpAddress;
import org.refcodes.net.IpAddressAccessor;
import org.refcodes.web.FormFields;
import org.refcodes.web.FragmentAccessor;
import org.refcodes.web.HostAccessor;
import org.refcodes.web.QueryFieldsAccessor;
import org.refcodes.web.SchemeAccessor;

public class Url
implements SchemeAccessor,
HostAccessor,
IpAddressAccessor,
PortAccessor,
PathAccessor,
QueryFieldsAccessor,
FragmentAccessor,
CredentialsAccessor {
    protected Scheme _scheme = null;
    protected String _protocol = null;
    protected String _host = null;
    protected int[] _ipAddress = null;
    protected String _path = null;
    protected int _port = -1;
    protected FormFields _queryFields = null;
    protected String _identity = null;
    protected String _secret = null;
    protected String _fragment = null;

    protected Url() {
    }

    public Url(Url aUrl) {
        this._scheme = aUrl.getScheme();
        if (this._scheme == null) {
            this._protocol = aUrl.toProtocol();
        }
        this._host = aUrl.getHost();
        this._ipAddress = aUrl.getIpAddress();
        this.setPath(aUrl.getPath());
        this._port = aUrl.getPort();
        this._queryFields = new FormFields(aUrl.getQueryFields());
        this._identity = aUrl.getIdentity();
        this._secret = aUrl.getSecret();
        this._fragment = aUrl.getFragment();
    }

    public Url(String aUrl) throws MalformedURLException {
        this.fromUrl(aUrl);
    }

    public Url(String aUrl, FormFields aQueryFields) throws MalformedURLException {
        this.fromUrl(aUrl);
        this._queryFields = aQueryFields;
    }

    public Url(String aUrl, FormFields aQueryFields, String aFragment) throws MalformedURLException {
        this.fromUrl(aUrl);
        this._queryFields = aQueryFields;
        this._fragment = aFragment;
    }

    public Url(URL aURL) {
        this.fromURL(aURL);
    }

    public Url(Scheme aScheme, String aHost) {
        this._scheme = aScheme;
        this._host = aHost;
    }

    public Url(Scheme aScheme, String aHost, int aPort) {
        this._scheme = aScheme;
        this._host = aHost;
        this._port = aPort;
    }

    public Url(Scheme aScheme, String aHost, int aPort, String aPath) {
        this._scheme = aScheme;
        this._host = aHost;
        this._port = aPort;
        this.setPath(aPath);
    }

    public Url(Scheme aScheme, String aHost, int aPort, String aPath, FormFields aQueryFields) {
        this._scheme = aScheme;
        this._host = aHost;
        this._port = aPort;
        this.setPath(aPath);
        this._queryFields = aQueryFields;
    }

    public Url(Scheme aScheme, String aHost, int aPort, String aPath, FormFields aQueryFields, String aFragment) {
        this._scheme = aScheme;
        this._host = aHost;
        this._port = aPort;
        this.setPath(aPath);
        this._queryFields = aQueryFields;
        this._fragment = aFragment;
    }

    public Url(String aProtocol, String aHost) {
        this.setProtocol(aProtocol);
        this._host = aHost;
    }

    public Url(String aProtocol, String aHost, int aPort) {
        this.setProtocol(aProtocol);
        this._host = aHost;
        this._port = aPort;
    }

    public Url(String aProtocol, String aHost, int aPort, String aPath) {
        this.setProtocol(aProtocol);
        this._host = aHost;
        this._port = aPort;
        this.setPath(aPath);
    }

    public Url(String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields) {
        this.setProtocol(aProtocol);
        this._host = aHost;
        this._port = aPort;
        this.setPath(aPath);
        this._queryFields = aQueryFields;
    }

    public Url(String aProtocol, String aHost, int aPort, String aPath, FormFields aQueryFields, String aFragment) {
        this.setProtocol(aProtocol);
        this._host = aHost;
        this._port = aPort;
        this.setPath(aPath);
        this._queryFields = aQueryFields;
        this._fragment = aFragment;
    }

    public Url(Scheme aScheme, String aHost, String aPath) {
        this._scheme = aScheme;
        this._host = aHost;
        this.setPath(aPath);
    }

    public Url(Scheme aScheme, String aHost, String aPath, FormFields aQueryFields) {
        this._scheme = aScheme;
        this._host = aHost;
        this.setPath(aPath);
        this._queryFields = aQueryFields;
    }

    public Url(Scheme aScheme, String aHost, String aPath, FormFields aQueryFields, String aFragment) {
        this._scheme = aScheme;
        this._host = aHost;
        this.setPath(aPath);
        this._queryFields = aQueryFields;
        this._fragment = aFragment;
    }

    public Url(String aProtocol, String aHost, String aPath) {
        this.setProtocol(aProtocol);
        this._host = aHost;
        this.setPath(aPath);
    }

    public Url(String aProtocol, String aHost, String aPath, FormFields aQueryFields) {
        this.setProtocol(aProtocol);
        this._host = aHost;
        this.setPath(aPath);
        this._queryFields = aQueryFields;
    }

    public Url(Url aUrl, Url aOtherUrl) {
        this(aUrl != null ? aUrl : aOtherUrl);
        if (aUrl != null) {
            String theOtherPath;
            if (aOtherUrl.getScheme() != null) {
                this.setScheme(aOtherUrl.getScheme());
            } else if (aOtherUrl.toProtocol() != null) {
                this.setProtocol(aOtherUrl.toProtocol());
            }
            if (aOtherUrl.getIdentity() != null) {
                this._identity = aOtherUrl.getIdentity();
            }
            if (aOtherUrl.getSecret() != null) {
                this._secret = aOtherUrl.getSecret();
            }
            if (aOtherUrl.getHost() != null) {
                this.setHost(aOtherUrl.getHost());
            }
            if ((theOtherPath = aOtherUrl.getPath()) != null) {
                String thePath = this.getPath();
                if (thePath == null) {
                    thePath = "";
                }
                thePath = Url.toTruncatePathSuffix(thePath);
                theOtherPath = Url.toTruncatePathPrefix(theOtherPath);
                this.setPath(thePath + Delimiter.PATH.getChar() + theOtherPath);
            }
            this.getQueryFields().putAll(aOtherUrl.getQueryFields());
            if (aOtherUrl.getFragment() != null) {
                this._fragment = aOtherUrl.getFragment();
            }
        }
    }

    public Url(String aProtocol, String aHost, String aPath, FormFields aQueryFields, String aFragment) {
        this.setProtocol(aProtocol);
        this._host = aHost;
        this.setPath(aPath);
        this._queryFields = aQueryFields;
        this._fragment = aFragment;
    }

    public Url(Url aUrl, String ... aPaths) {
        this(aUrl);
        this._path = this._path != null && this._path.length() != 0 ? Url.toTruncatePathSuffix(this._path) : "" + Delimiter.PATH.getChar();
        Object thePath = "";
        for (String ePath : aPaths) {
            if (((String)thePath).length() > 0) {
                thePath = (String)thePath + Delimiter.PATH.getChar();
            }
            thePath = (String)thePath + Url.toTruncatePath(ePath);
        }
        this._path = this._path + Delimiter.PATH.getChar() + (String)thePath;
    }

    @Override
    public String getFragment() {
        return this._fragment;
    }

    @Override
    public String getHost() {
        return this._host;
    }

    @Override
    public String getIdentity() {
        return this._identity;
    }

    @Override
    public int[] getIpAddress() {
        return this._ipAddress;
    }

    @Override
    public String getPath() {
        return this._path;
    }

    @Override
    public int getPort() {
        return this._port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FormFields getQueryFields() {
        if (this._queryFields == null) {
            Url url = this;
            synchronized (url) {
                if (this._queryFields == null) {
                    this._queryFields = new FormFields();
                }
            }
        }
        return this._queryFields;
    }

    @Override
    public Scheme getScheme() {
        return this._scheme;
    }

    @Override
    public String getSecret() {
        return this._secret;
    }

    @Override
    public String toProtocol() {
        return this._scheme != null ? this._scheme.toProtocol() : this._protocol;
    }

    public String toHost() {
        String theHost = this.getHost();
        String theCidrNotation = this.toCidrNotation();
        if (theHost != null && theHost.length() > 0 && theCidrNotation != null && theCidrNotation.length() > 0) {
            throw new IllegalStateException("Either the <host> or the <IP-Address> can be set, but not both of them: Host := <" + theHost + ">, IP-Address = <" + theCidrNotation + ">. Make sure only one ofd them is set!");
        }
        return theHost != null ? theHost : theCidrNotation;
    }

    public String toHttpUrl() {
        String theFragment;
        String theQueryString;
        FormFields theFields;
        String thePath;
        String theIdentity;
        StringBuilder theBuilder = new StringBuilder();
        String theScheme = this.toProtocol();
        if (theScheme != null && theScheme.length() != 0) {
            theBuilder.append(theScheme);
        }
        if ((theIdentity = this.getIdentity()) != null) {
            theBuilder.append(theIdentity);
            if (this.getSecret() != null) {
                theBuilder.append(Delimiter.URL_CREDENTIALS.getChar());
                theBuilder.append(this.getSecret());
            }
            theBuilder.append(Delimiter.URL_USER_INFO.getChar());
        } else if (this.getSecret() != null) {
            throw new IllegalStateException("The <secret> property requires an <identiry> property not being null or of an empty length!");
        }
        String theHost = this.toHost();
        if (theHost != null && theHost.length() != 0) {
            theBuilder.append(theHost);
            int thePort = this.getPort();
            if (thePort != -1) {
                theBuilder.append(Delimiter.URL_PORT.getChar());
                theBuilder.append(thePort);
            }
        }
        if ((thePath = this.getPath()) != null) {
            while (thePath.length() > 0 && thePath.charAt(0) == Delimiter.PATH.getChar()) {
                thePath = thePath.substring(1);
            }
            if (!theBuilder.toString().endsWith("" + Delimiter.PATH.getChar())) {
                theBuilder.append(Delimiter.PATH.getChar());
            }
            theBuilder.append(thePath);
        }
        if ((theFields = this.getQueryFields()) != null && theFields.size() > 0 && (theQueryString = theFields.toUrlQueryString()) != null && theQueryString.length() > 0) {
            theBuilder.append(theQueryString);
        }
        if ((theFragment = this.getFragment()) != null && theFragment.length() > 0) {
            theBuilder.append(Delimiter.URL_FRAGMENT.getChar());
            theBuilder.append(theFragment);
        }
        return theBuilder.toString();
    }

    public String toLocator() {
        String thePath;
        String theIdentity;
        StringBuilder theBuilder = new StringBuilder();
        String theScheme = this.toProtocol();
        if (theScheme != null && theScheme.length() != 0) {
            theBuilder.append(theScheme);
        }
        if ((theIdentity = this.getIdentity()) != null) {
            theBuilder.append(theIdentity);
            if (this.getSecret() != null) {
                theBuilder.append(Delimiter.URL_CREDENTIALS.getChar());
                theBuilder.append(this.getSecret());
            }
            theBuilder.append(Delimiter.URL_USER_INFO.getChar());
        } else if (this.getSecret() != null) {
            throw new IllegalStateException("The <secret> property requires an <identiry> property not being null or of an empty length!");
        }
        String theHost = this.toHost();
        if (theHost != null && theHost.length() != 0) {
            theBuilder.append(theHost);
            int thePort = this.getPort();
            if (thePort != -1) {
                theBuilder.append(Delimiter.URL_PORT.getChar());
                theBuilder.append(thePort);
            }
        }
        if ((thePath = this.getPath()) != null) {
            while (thePath.length() > 0 && thePath.charAt(0) == Delimiter.PATH.getChar()) {
                thePath = thePath.substring(1);
            }
            if (!theBuilder.toString().endsWith("" + Delimiter.PATH.getChar())) {
                theBuilder.append(Delimiter.PATH.getChar());
            }
            theBuilder.append(thePath);
        }
        return theBuilder.toString();
    }

    public URL toURL() throws MalformedURLException {
        return Url.toURL(this.toHttpUrl());
    }

    public String toString() {
        return this.toHttpUrl();
    }

    protected void fromUrl(String aUrl) throws MalformedURLException {
        try {
            int i;
            int index;
            String theUrl = aUrl;
            Scheme theScheme = Scheme.fromScheme(theUrl);
            if (theScheme != null) {
                this.setScheme(theScheme);
                theUrl = theUrl.substring(theScheme.toProtocol().length());
            }
            if ((index = theUrl.indexOf(Delimiter.URL_USER_INFO.getChar())) != -1) {
                String theUserInfo = theUrl.substring(0, index);
                if (theUserInfo.length() > 0) {
                    i = theUserInfo.indexOf(Delimiter.URL_CREDENTIALS.getChar());
                    if (i == -1) {
                        this._identity = theUserInfo;
                    } else {
                        this._identity = theUserInfo.substring(0, i);
                        this._secret = theUserInfo.substring(i + 1);
                    }
                }
                theUrl = theUrl.substring(index + 1);
            }
            if ((index = theUrl.indexOf(Delimiter.PATH.getChar())) != 0) {
                if (index == -1 && (index = theUrl.indexOf(Delimiter.URL_QUERY.getChar())) == -1) {
                    index = theUrl.indexOf(Delimiter.URL_FRAGMENT.getChar());
                }
                if (index == -1) {
                    this.setHost(theUrl);
                    theUrl = null;
                } else {
                    String theHost = theUrl.substring(0, index);
                    if (theHost != null && theHost.length() > 0) {
                        i = theHost.indexOf(Delimiter.URL_PORT.getChar());
                        if (i == -1) {
                            this.setHost(theHost);
                        } else {
                            this.setHost(theHost.substring(0, i));
                            this.setPort(Integer.parseInt(theHost.substring(i + 1)));
                        }
                    }
                    theUrl = theUrl.substring(index);
                }
            }
            if (theUrl != null && theUrl.length() > 0) {
                index = theUrl.indexOf(Delimiter.URL_QUERY.getChar(), 1);
                if (index == -1) {
                    index = theUrl.indexOf(Delimiter.URL_FRAGMENT.getChar(), 1);
                }
                if (index == -1) {
                    this.setPath(theUrl);
                } else {
                    String thePath = theUrl.substring(0, index);
                    this.setPath(thePath);
                    theUrl = theUrl.substring(index);
                    if (theUrl.length() > 0) {
                        if (theUrl.charAt(0) == Delimiter.URL_QUERY.getChar()) {
                            FormFields theQueryFields;
                            index = theUrl.indexOf(Delimiter.URL_FRAGMENT.getChar());
                            String theQueryString = index == -1 ? theUrl : theUrl.substring(0, index);
                            this._queryFields = theQueryFields = new FormFields(theQueryString);
                        }
                        if ((index = theUrl.indexOf(Delimiter.URL_FRAGMENT.getChar())) != -1) {
                            String theFragment;
                            this._fragment = theFragment = theUrl.substring(index + 1);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.fromURL(Url.toURL(aUrl));
        }
    }

    protected void fromURL(URL aUrl) {
        String thePath;
        Scheme theScheme = Scheme.fromName(aUrl.getProtocol());
        if (theScheme == null) {
            theScheme = Scheme.fromProtocol(aUrl.getProtocol());
        }
        this.setScheme(theScheme);
        this.setHost(aUrl.getHost());
        this.setPort(aUrl.getPort());
        String theUserInfo = aUrl.getUserInfo();
        if (theUserInfo != null && theUserInfo.length() > 0) {
            int index = theUserInfo.indexOf(Delimiter.URL_CREDENTIALS.getChar());
            if (index == -1) {
                this._identity = theUserInfo;
            } else {
                this._identity = theUserInfo.substring(0, index);
                this._secret = theUserInfo.substring(index + 1);
            }
        }
        if ((thePath = aUrl.getPath()) != null && thePath.length() > 0) {
            this.setPath(thePath);
        }
        if (aUrl.getQuery() != null && aUrl.getQuery().length() > 0) {
            FormFields theFormFields;
            this._queryFields = theFormFields = new FormFields(aUrl.getQuery());
        }
        if (aUrl.getRef() != null && aUrl.getRef().length() > 0) {
            this._fragment = aUrl.getRef();
        }
    }

    protected void setScheme(Scheme aScheme) {
        this._scheme = aScheme;
        this._protocol = null;
    }

    protected void setProtocol(String aProtocol) {
        Scheme theScheme = Scheme.fromProtocol(aProtocol);
        if (theScheme != null) {
            this._scheme = theScheme;
            this._protocol = null;
        } else {
            this._scheme = null;
            this._protocol = aProtocol;
        }
    }

    protected void setHost(String aHost) {
        try {
            int[] theIpAddress = IpAddress.fromAnyCidrNotation(aHost);
            if (theIpAddress != null && theIpAddress.length > 0) {
                this._ipAddress = theIpAddress;
                this._host = null;
            } else {
                this._ipAddress = null;
                this._host = aHost;
            }
        }
        catch (IllegalArgumentException e) {
            this._host = aHost;
            this._ipAddress = null;
        }
    }

    protected void setIpAddress(int[] aIpAddress) {
        IpAddress.toString(aIpAddress);
        this._ipAddress = aIpAddress;
        this._host = null;
    }

    protected void setPort(int aPort) {
        this._port = aPort;
    }

    protected void setPath(String aPath) {
        if (aPath != null && ((String)aPath).length() != 0 && ((String)aPath).charAt(0) != Delimiter.PATH.getChar()) {
            aPath = Delimiter.PATH.getChar() + (String)aPath;
        }
        this._path = aPath;
    }

    protected static String toTruncatePathPrefix(String aPath) {
        if (aPath != null) {
            while (aPath.length() > 0 && aPath.charAt(0) == Delimiter.PATH.getChar()) {
                aPath = aPath.substring(1);
            }
        }
        return aPath;
    }

    protected static String toTruncatePathSuffix(String aPath) {
        if (aPath != null) {
            while (aPath.length() > 0 && aPath.charAt(aPath.length() - 1) == Delimiter.PATH.getChar()) {
                aPath = aPath.substring(0, aPath.length() - 1);
            }
        }
        return aPath;
    }

    protected static String toTruncatePath(String aPath) {
        return Url.toTruncatePathPrefix(Url.toTruncatePathSuffix(aPath));
    }

    private static URL toURL(String aStr) throws MalformedURLException {
        try {
            return URI.create(aStr).toURL();
        }
        catch (IllegalArgumentException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }
}

