/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.factory.MarshalFactory;
import org.refcodes.factory.UnmarshalFactory;
import org.refcodes.struct.ImmutablePathTable;
import org.refcodes.struct.ext.factory.DocumentOptions;
import org.refcodes.web.MediaTypesAccessor;

public interface MediaTypeFactory
extends UnmarshalFactory.UnmarshalFactoryComposite.ConfigurableUnmarshalFactoryComposite<String, InputStream, DocumentOptions>,
MarshalFactory.MarshalFactoryComposite.ConfigurableMarshalFactoryComposite<String, InputStream, DocumentOptions>,
MediaTypesAccessor {
    public static final String VALUE_SELECTOR = "value";
    public static final String ARRAY_SELECTOR = "array";
    public static final String COLLECTION_SELECTOR = "collection";
    public static final String MAP_SELECTOR = "map";
    public static final String TYPE_ANNOTATION = ImmutablePathTable.ANNOTATOR + "type";

    @Override
    default public <T> T fromMarshaled(InputStream aMarshaled, Class<T> aType) throws UnmarshalException {
        BufferedReader theBuffer = new BufferedReader(new InputStreamReader(aMarshaled));
        String theHttpBody = theBuffer.lines().collect(Collectors.joining("\n"));
        return this.toUnmarshaled(theHttpBody, aType);
    }

    @Override
    default public Object fromMarshaled(InputStream aMarshaled, Class<?> ... aTypes) throws UnmarshalException {
        BufferedReader theBuffer = new BufferedReader(new InputStreamReader(aMarshaled));
        String theHttpBody = theBuffer.lines().collect(Collectors.joining("\n"));
        return this.toUnmarshaled(theHttpBody, aTypes);
    }

    @Override
    default public Object fromMarshaled(InputStream aMarshaled, DocumentOptions aOptions, Class<?> ... aTypes) throws UnmarshalException {
        BufferedReader theBuffer = new BufferedReader(new InputStreamReader(aMarshaled));
        String theHttpBody = theBuffer.lines().collect(Collectors.joining("\n"));
        return this.toUnmarshaled(theHttpBody, aOptions, aTypes);
    }

    @Override
    default public <MAR> MAR fromMarshaled(InputStream aMarshaled, Class<MAR> aType, DocumentOptions aOptions) throws UnmarshalException {
        BufferedReader theBuffer = new BufferedReader(new InputStreamReader(aMarshaled));
        String theHttpBody = theBuffer.lines().collect(Collectors.joining("\n"));
        return this.toUnmarshaled(theHttpBody, aType, aOptions);
    }

    @Override
    default public <UN> InputStream fromUnmarshaled(UN aUnmarshaled) throws MarshalException {
        return new ByteArrayInputStream(((String)this.toMarshaled(aUnmarshaled)).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    default public <UN> InputStream fromUnmarshaled(UN aUnmarshaled, DocumentOptions aOptions) throws MarshalException {
        return new ByteArrayInputStream(((String)this.toMarshaled(aUnmarshaled, aOptions)).getBytes(StandardCharsets.UTF_8));
    }
}

