/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.util.Collection;
import java.util.regex.Pattern;
import org.refcodes.struct.ImmutablePathTable;
import org.refcodes.struct.MapCanonicalTable;
import org.refcodes.struct.Property;
import org.refcodes.struct.Relation;
import org.refcodes.web.HttpStatusCode;

public class HttpBodyTable
extends MapCanonicalTable {
    private static final long serialVersionUID = 1L;
    public static final String STATUS_CODE_PATH = "/status/code";
    public static final String STATUS_ALIAS_PATH = "/status/alias";
    public static final String STATUS_MESSAGE_PATH = "/status/aMessage";
    public static final String STATUS_EXCEPTION_PATH = "/status/exception";
    public static final String STATUS_TIMESTAMP_PATH = "/status/timestamp";

    public HttpBodyTable() {
    }

    public HttpBodyTable(Object aObj) {
        super(aObj);
    }

    public HttpBodyTable(String aToPath, Object aObj) {
        super(aToPath, aObj);
    }

    public HttpBodyTable(Object aObj, String aFromPath) {
        super(aObj, aFromPath);
    }

    public HttpBodyTable(String aToPath, Object aObj, String aFromPath) {
        super(aToPath, aObj, aFromPath);
    }

    private HttpBodyTable(ImmutablePathTable<String> aPathTable) {
        for (String ePath : aPathTable.paths()) {
            this.put(ePath, (String)aPathTable.get((Object)ePath));
        }
    }

    @Override
    public HttpBodyTable retrieveFrom(String aFromPath) {
        return new HttpBodyTable(super.retrieveFrom(aFromPath));
    }

    @Override
    public HttpBodyTable retrieveTo(String aToPath) {
        return new HttpBodyTable(super.retrieveTo(aToPath));
    }

    @Override
    public HttpBodyTable retrieveBetween(String aFromPath, String aToPath) {
        return new HttpBodyTable(super.retrieveBetween(aFromPath, aToPath));
    }

    @Override
    public HttpBodyTable withPut(String aKey, String aValue) {
        this.put(aKey, aValue);
        return this;
    }

    @Override
    public HttpBodyTable getDirAt(int aIndex) {
        return this.getDirAt(this.getRootPath(), aIndex);
    }

    @Override
    public HttpBodyTable getDirAt(String aPath, int aIndex) {
        return this.retrieveFrom(aPath, aIndex);
    }

    public String getStatusAlias() {
        return (String)this.get((Object)STATUS_ALIAS_PATH);
    }

    public HttpStatusCode getStatusCode() {
        return HttpStatusCode.toHttpStatusCode(this.getInt(STATUS_CODE_PATH));
    }

    public Class<?> getStatusException() {
        try {
            return Class.forName((String)this.get((Object)STATUS_EXCEPTION_PATH));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public String getStatusMessage() {
        return (String)this.get((Object)STATUS_MESSAGE_PATH);
    }

    public Long getStatusTimeStamp() {
        return this.getLong(STATUS_TIMESTAMP_PATH);
    }

    public boolean hasStatusAlias() {
        try {
            return this.getStatusAlias() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasStatusCode() {
        try {
            return this.getStatusCode() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasStatusException() {
        try {
            return Class.forName((String)this.get((Object)STATUS_EXCEPTION_PATH)) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasStatusMessage() {
        return this.containsKey((Object)STATUS_MESSAGE_PATH);
    }

    public boolean hasStatusTimeStamp() {
        try {
            return this.getStatusTimeStamp() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public HttpBodyTable putDirAt(Collection<?> aPathElements, int aIndex, Object aDir) {
        return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
    }

    @Override
    public HttpBodyTable putDirAt(Collection<?> aPathElements, int aIndex, ImmutablePathTable<String> aDir) {
        return this.putDirAt(this.toPath(aPathElements), aIndex, (ImmutablePathTable)aDir);
    }

    @Override
    public HttpBodyTable putDirAt(int aIndex, Object aDir) {
        return this.putDirAt(this.getRootPath(), aIndex, aDir);
    }

    @Override
    public HttpBodyTable putDirAt(int aIndex, ImmutablePathTable<String> aDir) {
        return this.putDirAt(this.getRootPath(), aIndex, (ImmutablePathTable)aDir);
    }

    @Override
    public HttpBodyTable putDirAt(Object aPath, int aIndex, Object aDir) {
        return this.putDirAt(this.toPath(aPath), aIndex, aDir);
    }

    @Override
    public HttpBodyTable putDirAt(Object aPath, int aIndex, ImmutablePathTable<String> aDir) {
        return this.putDirAt(this.toPath(aPath), aIndex, (ImmutablePathTable)aDir);
    }

    @Override
    public HttpBodyTable putDirAt(Object[] aPathElements, int aIndex, Object aDir) {
        return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
    }

    @Override
    public HttpBodyTable putDirAt(Object[] aPathElements, int aIndex, ImmutablePathTable<String> aDir) {
        return this.putDirAt(this.toPath(aPathElements), aIndex, (ImmutablePathTable)aDir);
    }

    @Override
    public HttpBodyTable putDirAt(String aPath, int aIndex, Object aDir) {
        HttpBodyTable theReplaced = this.removeDirAt(aPath, aIndex);
        this.insertTo(this.toPath(aPath, aIndex), aDir);
        return theReplaced;
    }

    @Override
    public HttpBodyTable putDirAt(String aPath, int aIndex, ImmutablePathTable<String> aDir) {
        HttpBodyTable theReplaced = this.removeDirAt(aPath, aIndex);
        this.insertTo(this.toPath(aPath, aIndex), aDir);
        return theReplaced;
    }

    @Override
    public HttpBodyTable putDirAt(String[] aPathElements, int aIndex, Object aDir) {
        return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
    }

    @Override
    public HttpBodyTable putDirAt(String[] aPathElements, int aIndex, ImmutablePathTable<String> aDir) {
        return this.putDirAt(this.toPath(aPathElements), aIndex, (ImmutablePathTable)aDir);
    }

    public String putStatusAlias(HttpStatusCode aStatusCode) {
        return this.put(STATUS_ALIAS_PATH, aStatusCode.toVerbose());
    }

    public String putStatusAlias(String aStatusAlias) {
        return this.put(STATUS_ALIAS_PATH, aStatusAlias);
    }

    public String putStatusCode(HttpStatusCode aStatusCode) {
        return (String)this.putInt(STATUS_CODE_PATH, aStatusCode.getStatusCode());
    }

    public String putStatusCode(int aStatusCode) {
        return (String)this.putInt(STATUS_CODE_PATH, (Integer)aStatusCode);
    }

    public String putStatusException(Class<Exception> aStatusException) {
        return this.put(STATUS_EXCEPTION_PATH, aStatusException.getName());
    }

    public String putStatusException(Exception aStatusException) {
        return this.put(STATUS_EXCEPTION_PATH, aStatusException.getClass().getName());
    }

    public String putStatusMessage(String aStatusMessage) {
        return this.put(STATUS_MESSAGE_PATH, aStatusMessage);
    }

    public String putStatusTimeStamp() {
        return (String)this.putLong(STATUS_TIMESTAMP_PATH, (Long)System.currentTimeMillis());
    }

    public String putStatusTimeStamp(long aStatusTimeStamp) {
        return (String)this.putLong(STATUS_TIMESTAMP_PATH, (Long)aStatusTimeStamp);
    }

    @Override
    public HttpBodyTable query(Collection<?> aQueryElements) {
        return this.query(this.toPath(aQueryElements));
    }

    @Override
    public HttpBodyTable query(Object ... aQueryElements) {
        return this.query(this.toPath(aQueryElements));
    }

    @Override
    public HttpBodyTable query(String aPathQuery) {
        return new HttpBodyTable(super.query(aPathQuery));
    }

    @Override
    public HttpBodyTable query(Pattern aRegExp) {
        return new HttpBodyTable(super.query(aRegExp));
    }

    @Override
    public HttpBodyTable query(String ... aQueryElements) {
        return this.query(this.toPath(aQueryElements));
    }

    @Override
    public HttpBodyTable queryBetween(Collection<?> aFromPath, Collection<?> aPathQuery, Collection<?> aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    @Override
    public HttpBodyTable queryBetween(Object aFromPath, Object aPathQuery, Object aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    @Override
    public HttpBodyTable queryBetween(Object[] aFromPath, Object[] aPathQuery, Object[] aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    @Override
    public HttpBodyTable queryBetween(String aFromPath, String aPathQuery, String aToPath) {
        return new HttpBodyTable(super.queryBetween(aFromPath, aPathQuery, aToPath));
    }

    @Override
    public HttpBodyTable queryBetween(String aFromPath, Pattern aRegExp, String aToPath) {
        return new HttpBodyTable(super.queryBetween(aFromPath, aRegExp, aToPath));
    }

    @Override
    public HttpBodyTable queryBetween(String[] aFromPath, String[] aPathQuery, String[] aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    @Override
    public HttpBodyTable queryFrom(Collection<?> aPathQuery, Collection<?> aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    @Override
    public HttpBodyTable queryFrom(Object aPathQuery, Object aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    @Override
    public HttpBodyTable queryFrom(Object[] aPathQuery, Object[] aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    @Override
    public HttpBodyTable queryFrom(String aPathQuery, String aFromPath) {
        return new HttpBodyTable(super.queryFrom(aPathQuery, aFromPath));
    }

    @Override
    public HttpBodyTable queryFrom(Pattern aRegExp, String aFromPath) {
        return new HttpBodyTable(super.queryFrom(aRegExp, aFromPath));
    }

    @Override
    public HttpBodyTable queryFrom(String[] aPathQuery, String[] aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    @Override
    public HttpBodyTable queryTo(Collection<?> aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), this.toPath((Object)aToPath));
    }

    @Override
    public HttpBodyTable queryTo(Object aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), this.toPath((Object)aToPath));
    }

    @Override
    public HttpBodyTable queryTo(Object[] aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), this.toPath((Object)aToPath));
    }

    @Override
    public HttpBodyTable queryTo(String aPathQuery, String aToPath) {
        return new HttpBodyTable(super.queryTo(aPathQuery, aToPath));
    }

    @Override
    public HttpBodyTable queryTo(Pattern aRegExp, String aToPath) {
        return new HttpBodyTable(super.queryTo(aRegExp, aToPath));
    }

    @Override
    public HttpBodyTable queryTo(String[] aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), this.toPath((Object)aToPath));
    }

    @Override
    public HttpBodyTable removePaths(Collection<?> aPaths) {
        return new HttpBodyTable(super.removePaths((Collection)aPaths));
    }

    @Override
    public HttpBodyTable removePaths(String ... aPaths) {
        return new HttpBodyTable(super.removePaths(aPaths));
    }

    @Override
    public HttpBodyTable removeAll(String ... aPathQueryElements) {
        return new HttpBodyTable(super.removeAll(aPathQueryElements));
    }

    @Override
    public HttpBodyTable removeAll(Object ... aPathQueryElements) {
        return new HttpBodyTable(super.removeAll(aPathQueryElements));
    }

    @Override
    public HttpBodyTable removeAll(Collection<?> aPathQueryElements) {
        return new HttpBodyTable(super.removeAll((Collection)aPathQueryElements));
    }

    @Override
    public HttpBodyTable removeAll(String aPathQuery) {
        return new HttpBodyTable(super.removeAll(aPathQuery));
    }

    @Override
    public HttpBodyTable removeAll(Pattern aRegExp) {
        return new HttpBodyTable(super.removeAll(aRegExp));
    }

    @Override
    public HttpBodyTable removeAll(Object aPathQuery) {
        return new HttpBodyTable(super.removeAll(aPathQuery));
    }

    @Override
    public HttpBodyTable removeDirAt(int aIndex) {
        return new HttpBodyTable(super.removeDirAt(aIndex));
    }

    @Override
    public HttpBodyTable removeDirAt(Object aPath, int aIndex) {
        return new HttpBodyTable(super.removeDirAt(aPath, aIndex));
    }

    @Override
    public HttpBodyTable removeDirAt(Object[] aPathElements, int aIndex) {
        return new HttpBodyTable(super.removeDirAt(aPathElements, aIndex));
    }

    @Override
    public HttpBodyTable removeDirAt(String aPath, int aIndex) {
        return new HttpBodyTable(super.removeDirAt(aPath, aIndex));
    }

    @Override
    public HttpBodyTable removeDirAt(String[] aPathElements, int aIndex) {
        return new HttpBodyTable(super.removeDirAt(aPathElements, aIndex));
    }

    @Override
    public HttpBodyTable removeFrom(Object ... aPathElements) {
        return new HttpBodyTable(super.removeFrom(aPathElements));
    }

    @Override
    public HttpBodyTable removeFrom(Object aPath) {
        return new HttpBodyTable(super.removeFrom(aPath));
    }

    @Override
    public HttpBodyTable removeFrom(String aPath) {
        return new HttpBodyTable(super.removeFrom(aPath));
    }

    @Override
    public HttpBodyTable removeFrom(String ... aPathElements) {
        return new HttpBodyTable(super.removeFrom(aPathElements));
    }

    @Override
    public HttpBodyTable retrieveBetween(Collection<?> aFromPath, Collection<?> aToPath) {
        return this.retrieveBetween(this.toPath(aFromPath), this.toPath(aToPath));
    }

    @Override
    public HttpBodyTable retrieveBetween(Object aFromPath, Object aToPath) {
        return this.retrieveBetween(this.toPath(aFromPath), this.toPath(aToPath));
    }

    @Override
    public HttpBodyTable retrieveBetween(Object[] aFromPath, Object[] aToPath) {
        return this.retrieveBetween(this.toPath(aFromPath), this.toPath(aToPath));
    }

    @Override
    public HttpBodyTable retrieveBetween(String[] aFromPath, String[] aToPath) {
        return this.retrieveBetween(this.toPath(aFromPath), this.toPath(aToPath));
    }

    @Override
    public HttpBodyTable retrieveFrom(Collection<?> aPathElements) {
        return this.retrieveFrom(this.toPath(aPathElements));
    }

    @Override
    public HttpBodyTable retrieveFrom(Object aParentPath) {
        return this.retrieveFrom(this.toPath(aParentPath));
    }

    @Override
    public HttpBodyTable retrieveFrom(Object ... aPathElements) {
        return this.retrieveFrom(this.toPath(aPathElements));
    }

    @Override
    public HttpBodyTable retrieveFrom(String ... aPathElements) {
        return this.retrieveFrom(this.toPath(aPathElements));
    }

    @Override
    public HttpBodyTable retrieveTo(Collection<?> aToPathElements) {
        return this.retrieveTo(this.toPath(aToPathElements));
    }

    @Override
    public HttpBodyTable retrieveTo(Object aToPath) {
        return this.retrieveTo(this.toPath(aToPath));
    }

    @Override
    public HttpBodyTable retrieveTo(Object ... aToPathElements) {
        return this.retrieveTo(this.toPath(aToPathElements));
    }

    @Override
    public HttpBodyTable retrieveTo(String ... aToPathElements) {
        return this.retrieveTo(this.toPath(aToPathElements));
    }

    public HttpBodyTable withPutStatusAlias(HttpStatusCode aStatusCode) {
        this.put(STATUS_ALIAS_PATH, aStatusCode.toVerbose());
        return this;
    }

    public HttpBodyTable withPutStatusAlias(String aStatusAlias) {
        this.put(STATUS_ALIAS_PATH, aStatusAlias);
        return this;
    }

    public HttpBodyTable withPutStatusCode(HttpStatusCode aStatusCode) {
        this.putInt(STATUS_CODE_PATH, aStatusCode.getStatusCode());
        return this;
    }

    public HttpBodyTable withPutStatusCode(int aStatusCode) {
        this.putInt(STATUS_CODE_PATH, (Integer)aStatusCode);
        return this;
    }

    @Override
    public HttpBodyTable withPut(Collection<?> aPathElements, String aValue) {
        this.put(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPut(Object[] aPathElements, String aValue) {
        this.put(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPut(Relation<String, String> aProperty) {
        this.put(aProperty);
        return this;
    }

    @Override
    public HttpBodyTable withPut(Property aProperty) {
        this.put(aProperty);
        return this;
    }

    @Override
    public HttpBodyTable withPut(String[] aKey, String aValue) {
        this.put(aKey, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutBoolean(Collection<?> aPathElements, Boolean aValue) {
        this.putBoolean(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutBoolean(Object aKey, Boolean aValue) {
        this.putBoolean(aKey, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutBoolean(Object[] aPathElements, Boolean aValue) {
        this.putBoolean(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutBoolean(String aKey, Boolean aValue) {
        this.putBoolean(aKey, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutBoolean(String[] aPathElements, Boolean aValue) {
        this.putBoolean(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutByte(Collection<?> aPathElements, Byte aValue) {
        this.putByte(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutByte(Object aKey, Byte aValue) {
        this.putByte(aKey, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutByte(Object[] aPathElements, Byte aValue) {
        this.putByte(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutByte(String aKey, Byte aValue) {
        this.putByte(aKey, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutByte(String[] aPathElements, Byte aValue) {
        this.putByte(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutChar(Collection<?> aPathElements, Character aValue) {
        this.putChar(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutChar(Object aKey, Character aValue) {
        this.putChar(aKey, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutChar(Object[] aPathElements, Character aValue) {
        this.putChar(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutChar(String aKey, Character aValue) {
        this.putChar(aKey, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutChar(String[] aPathElements, Character aValue) {
        this.putChar(aPathElements, aValue);
        return this;
    }

    @Override
    public <C> HttpBodyTable withPutClass(Collection<?> aPathElements, Class<C> aValue) {
        this.putClass(aPathElements, aValue);
        return this;
    }

    @Override
    public <C> HttpBodyTable withPutClass(Object aKey, Class<C> aValue) {
        this.putClass(aKey, aValue);
        return this;
    }

    @Override
    public <C> HttpBodyTable withPutClass(Object[] aPathElements, Class<C> aValue) {
        this.putClass(aPathElements, aValue);
        return this;
    }

    @Override
    public <C> HttpBodyTable withPutClass(String aKey, Class<C> aValue) {
        this.putClass(aKey, aValue);
        return this;
    }

    @Override
    public <C> HttpBodyTable withPutClass(String[] aPathElements, Class<C> aValue) {
        this.putClass(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutDouble(Collection<?> aPathElements, Double aValue) {
        this.putDouble(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutDouble(Object aKey, Double aValue) {
        this.putDouble(aKey, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutDouble(Object[] aPathElements, Double aValue) {
        this.putDouble(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutDouble(String aKey, Double aValue) {
        this.putDouble(aKey, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutDouble(String[] aPathElements, Double aValue) {
        this.putDouble(aPathElements, aValue);
        return this;
    }

    @Override
    public <E extends Enum<E>> HttpBodyTable withPutEnum(Collection<?> aPathElements, E aValue) {
        this.putEnum(aPathElements, aValue);
        return this;
    }

    @Override
    public <E extends Enum<E>> HttpBodyTable withPutEnum(Object aKey, E aValue) {
        this.putEnum(aKey, aValue);
        return this;
    }

    @Override
    public <E extends Enum<E>> HttpBodyTable withPutEnum(Object[] aPathElements, E aValue) {
        this.putEnum(aPathElements, aValue);
        return this;
    }

    @Override
    public <E extends Enum<E>> HttpBodyTable withPutEnum(String aKey, E aValue) {
        this.putEnum(aKey, aValue);
        return this;
    }

    @Override
    public <E extends Enum<E>> HttpBodyTable withPutEnum(String[] aPathElements, E aValue) {
        this.putEnum(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutFloat(Collection<?> aPathElements, Float aValue) {
        this.putFloat(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutFloat(Object aKey, Float aValue) {
        this.putFloat(aKey, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutFloat(Object[] aPathElements, Float aValue) {
        this.putFloat(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutFloat(String aKey, Float aValue) {
        this.putFloat(aKey, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutFloat(String[] aPathElements, Float aValue) {
        this.putFloat(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutInt(Collection<?> aPathElements, Integer aValue) {
        this.putInt(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutInt(Object aKey, Integer aValue) {
        this.putInt(aKey, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutInt(Object[] aPathElements, Integer aValue) {
        this.putInt(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutInt(String aKey, Integer aValue) {
        this.putInt(aKey, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutInt(String[] aPathElements, Integer aValue) {
        this.putInt(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutLong(Collection<?> aPathElements, Long aValue) {
        this.putLong(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutLong(Object aKey, Long aValue) {
        this.putLong(aKey, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutLong(Object[] aPathElements, Long aValue) {
        this.putLong(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutLong(String aKey, Long aValue) {
        this.putLong(aKey, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutLong(String[] aPathElements, Long aValue) {
        this.putLong(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutShort(Collection<?> aPathElements, Short aValue) {
        this.putShort(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutShort(Object aKey, Short aValue) {
        this.putShort(aKey, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutShort(Object[] aPathElements, Short aValue) {
        this.putShort(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutShort(String aKey, Short aValue) {
        this.putShort(aKey, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutShort(String[] aPathElements, Short aValue) {
        this.putShort(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutString(Collection<?> aPathElements, String aValue) {
        this.putString(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutString(Object aKey, String aValue) {
        this.putString(aKey, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutString(Object[] aPathElements, String aValue) {
        this.putString(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutString(String aKey, String aValue) {
        this.putString(aKey, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withPutString(String[] aPathElements, String aValue) {
        this.putString(aPathElements, aValue);
        return this;
    }

    @Override
    public HttpBodyTable withInsert(Object aObj) {
        this.insert(aObj);
        return this;
    }

    @Override
    public HttpBodyTable withInsert(ImmutablePathTable<String> aFrom) {
        this.insert(aFrom);
        return this;
    }

    @Override
    public HttpBodyTable withInsertBetween(Collection<?> aToPathElements, Object aFrom, Collection<?> aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public HttpBodyTable withInsertBetween(Collection<?> aToPathElements, ImmutablePathTable<String> aFrom, Collection<?> aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public HttpBodyTable withInsertBetween(Object aToPath, Object aFrom, Object aFromPath) {
        this.insertBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public HttpBodyTable withInsertBetween(Object aToPath, ImmutablePathTable<String> aFrom, Object aFromPath) {
        this.insertBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public HttpBodyTable withInsertBetween(Object[] aToPathElements, Object aFrom, Object[] aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public HttpBodyTable withInsertBetween(Object[] aToPathElements, ImmutablePathTable<String> aFrom, Object[] aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public HttpBodyTable withInsertBetween(String aToPath, Object aFrom, String aFromPath) {
        this.insertBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public HttpBodyTable withInsertBetween(String aToPath, ImmutablePathTable<String> aFrom, String aFromPath) {
        this.insertBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public HttpBodyTable withInsertBetween(String[] aToPathElements, Object aFrom, String[] aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public HttpBodyTable withInsertBetween(String[] aToPathElements, ImmutablePathTable<String> aFrom, String[] aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public HttpBodyTable withInsertFrom(Object aFrom, Collection<?> aFromPathElements) {
        this.insertFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public HttpBodyTable withInsertFrom(Object aFrom, Object aFromPath) {
        this.insertFrom(aFrom, aFromPath);
        return this;
    }

    @Override
    public HttpBodyTable withInsertFrom(Object aFrom, Object ... aFromPathElements) {
        this.withInsertFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public HttpBodyTable withInsertFrom(Object aFrom, String aFromPath) {
        this.insertFrom(aFrom, aFromPath);
        return this;
    }

    @Override
    public HttpBodyTable withInsertFrom(Object aFrom, String ... aFromPathElements) {
        this.insertFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public HttpBodyTable withInsertFrom(ImmutablePathTable<String> aFrom, Collection<?> aFromPathElements) {
        this.insertFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public HttpBodyTable withInsertFrom(ImmutablePathTable<String> aFrom, Object aFromPath) {
        this.insertFrom((Object)aFrom, aFromPath);
        return this;
    }

    @Override
    public HttpBodyTable withInsertFrom(ImmutablePathTable<String> aFrom, Object ... aFromPathElements) {
        this.withInsertFrom((ImmutablePathTable)aFrom, aFromPathElements);
        return this;
    }

    @Override
    public HttpBodyTable withInsertFrom(ImmutablePathTable<String> aFrom, String aFromPath) {
        this.insertFrom((Object)aFrom, aFromPath);
        return this;
    }

    @Override
    public HttpBodyTable withInsertFrom(ImmutablePathTable<String> aFrom, String ... aFromPathElements) {
        this.insertFrom((Object)aFrom, aFromPathElements);
        return this;
    }

    @Override
    public HttpBodyTable withInsertTo(Collection<?> aToPathElements, Object aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public HttpBodyTable withInsertTo(Collection<?> aToPathElements, ImmutablePathTable<String> aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public HttpBodyTable withInsertTo(Object aToPath, Object aFrom) {
        this.insertTo(aToPath, aFrom);
        return this;
    }

    @Override
    public HttpBodyTable withInsertTo(Object aToPath, ImmutablePathTable<String> aFrom) {
        this.insertTo(aToPath, aFrom);
        return this;
    }

    @Override
    public HttpBodyTable withInsertTo(Object[] aToPathElements, Object aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public HttpBodyTable withInsertTo(Object[] aToPathElements, ImmutablePathTable<String> aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public HttpBodyTable withInsertTo(String aToPath, Object aFrom) {
        this.insertTo(aToPath, aFrom);
        return this;
    }

    @Override
    public HttpBodyTable withInsertTo(String aToPath, ImmutablePathTable<String> aFrom) {
        this.insertTo(aToPath, aFrom);
        return this;
    }

    @Override
    public HttpBodyTable withInsertTo(String[] aToPathElements, Object aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public HttpBodyTable withInsertTo(String[] aToPathElements, ImmutablePathTable<String> aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public HttpBodyTable withMerge(Object aObj) {
        this.merge(aObj);
        return this;
    }

    @Override
    public HttpBodyTable withMerge(ImmutablePathTable<String> aFrom) {
        this.merge(aFrom);
        return this;
    }

    @Override
    public HttpBodyTable withMergeBetween(Collection<?> aToPathElements, Object aFrom, Collection<?> aFromPathElements) {
        this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public HttpBodyTable withMergeBetween(Collection<?> aToPathElements, ImmutablePathTable<String> aFrom, Collection<?> aFromPathElements) {
        this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public HttpBodyTable withMergeBetween(Object aToPath, Object aFrom, Object aFromPath) {
        this.mergeBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public HttpBodyTable withMergeBetween(Object aToPath, ImmutablePathTable<String> aFrom, Object aFromPath) {
        this.mergeBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public HttpBodyTable withMergeBetween(Object[] aToPathElements, Object aFrom, Object[] aFromPathElements) {
        this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public HttpBodyTable withMergeBetween(Object[] aToPathElements, ImmutablePathTable<String> aFrom, Object[] aFromPathElements) {
        this.mergeBetween(aToPathElements, (Object)aFromPathElements, aFromPathElements);
        return this;
    }

    @Override
    public HttpBodyTable withMergeBetween(String aToPath, Object aFrom, String aFromPath) {
        this.mergeBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public HttpBodyTable withMergeBetween(String aToPath, ImmutablePathTable<String> aFrom, String aFromPath) {
        this.mergeBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public HttpBodyTable withMergeBetween(String[] aToPathElements, Object aFrom, String[] aFromPathElements) {
        this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public HttpBodyTable withMergeBetween(String[] aToPathElements, ImmutablePathTable<String> aFrom, String[] aFromPathElements) {
        this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public HttpBodyTable withMergeFrom(Object aFrom, Collection<?> aFromPathElements) {
        this.mergeFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public HttpBodyTable withMergeFrom(Object aFrom, Object aFromPath) {
        this.mergeFrom(aFrom, aFromPath);
        return this;
    }

    @Override
    public HttpBodyTable withMergeFrom(Object aFrom, Object ... aFromPathElements) {
        this.mergeFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public HttpBodyTable withMergeFrom(Object aFrom, String aFromPath) {
        this.mergeFrom(aFrom, aFromPath);
        return this;
    }

    @Override
    public HttpBodyTable withMergeFrom(Object aFrom, String ... aFromPathElements) {
        this.mergeFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public HttpBodyTable withMergeFrom(ImmutablePathTable<String> aFrom, Collection<?> aFromPathElements) {
        this.mergeFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public HttpBodyTable withMergeFrom(ImmutablePathTable<String> aFrom, Object aFromPath) {
        this.mergeFrom((Object)aFrom, aFromPath);
        return this;
    }

    @Override
    public HttpBodyTable withMergeFrom(ImmutablePathTable<String> aFrom, Object ... aFromPathElements) {
        this.mergeFrom((Object)aFrom, aFromPathElements);
        return this;
    }

    @Override
    public HttpBodyTable withMergeFrom(ImmutablePathTable<String> aFrom, String aFromPath) {
        this.mergeFrom((Object)aFrom, aFromPath);
        return this;
    }

    @Override
    public HttpBodyTable withMergeFrom(ImmutablePathTable<String> aFrom, String ... aFromPathElements) {
        this.mergeFrom((Object)aFrom, aFromPathElements);
        return this;
    }

    @Override
    public HttpBodyTable withMergeTo(Collection<?> aToPathElements, Object aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public HttpBodyTable withMergeTo(Collection<?> aToPathElements, ImmutablePathTable<String> aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public HttpBodyTable withMergeTo(Object aToPath, Object aFrom) {
        this.mergeTo(aToPath, aFrom);
        return this;
    }

    @Override
    public HttpBodyTable withMergeTo(Object aToPath, ImmutablePathTable<String> aFrom) {
        this.mergeTo(aToPath, aFrom);
        return this;
    }

    @Override
    public HttpBodyTable withMergeTo(Object[] aToPathElements, Object aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public HttpBodyTable withMergeTo(Object[] aToPathElements, ImmutablePathTable<String> aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public HttpBodyTable withMergeTo(String aToPath, Object aFrom) {
        this.mergeTo(aToPath, aFrom);
        return this;
    }

    @Override
    public HttpBodyTable withMergeTo(String aToPath, ImmutablePathTable<String> aFrom) {
        this.mergeTo(aToPath, aFrom);
        return this;
    }

    @Override
    public HttpBodyTable withMergeTo(String[] aToPathElements, Object aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public HttpBodyTable withMergeTo(String[] aToPathElements, ImmutablePathTable<String> aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public HttpBodyTable withPutDirAt(Collection<?> aPathElements, int aIndex, Object aDir) {
        this.putDirAt((Collection)aPathElements, aIndex, aDir);
        return this;
    }

    @Override
    public HttpBodyTable withPutDirAt(Collection<?> aPathElements, int aIndex, ImmutablePathTable<String> aDir) {
        this.putDirAt((Collection)aPathElements, aIndex, (ImmutablePathTable)aDir);
        return this;
    }

    @Override
    public HttpBodyTable withPutDirAt(int aIndex, Object aDir) {
        this.putDirAt(aIndex, aDir);
        return this;
    }

    @Override
    public HttpBodyTable withPutDirAt(int aIndex, ImmutablePathTable<String> aDir) {
        this.putDirAt(aIndex, (ImmutablePathTable)aDir);
        return this;
    }

    @Override
    public HttpBodyTable withPutDirAt(Object aPath, int aIndex, Object aDir) {
        this.putDirAt(aPath, aIndex, aDir);
        return this;
    }

    @Override
    public HttpBodyTable withPutDirAt(Object aPath, int aIndex, ImmutablePathTable<String> aDir) {
        this.putDirAt(aPath, aIndex, (ImmutablePathTable)aDir);
        return this;
    }

    @Override
    public HttpBodyTable withPutDirAt(Object[] aPathElements, int aIndex, Object aDir) {
        this.putDirAt(aPathElements, aIndex, aDir);
        return this;
    }

    @Override
    public HttpBodyTable withPutDirAt(Object[] aPathElements, int aIndex, ImmutablePathTable<String> aDir) {
        this.putDirAt(aPathElements, aIndex, (ImmutablePathTable)aDir);
        return this;
    }

    @Override
    public HttpBodyTable withPutDirAt(String aPath, int aIndex, Object aDir) {
        this.putDirAt(aPath, aIndex, aDir);
        return this;
    }

    @Override
    public HttpBodyTable withPutDirAt(String aPath, int aIndex, ImmutablePathTable<String> aDir) {
        this.putDirAt(aPath, aIndex, (ImmutablePathTable)aDir);
        return this;
    }

    @Override
    public HttpBodyTable withPutDirAt(String[] aPathElements, int aIndex, Object aDir) {
        this.putDirAt(aPathElements, aIndex, aDir);
        return this;
    }

    @Override
    public HttpBodyTable withPutDirAt(String[] aPathElements, int aIndex, ImmutablePathTable<String> aDir) {
        this.putDirAt(aPathElements, aIndex, (ImmutablePathTable)aDir);
        return this;
    }

    @Override
    public HttpBodyTable withRemoveFrom(Collection<?> aPathElements) {
        this.removeFrom((Collection)aPathElements);
        return this;
    }

    @Override
    public HttpBodyTable withRemoveFrom(Object aPath) {
        this.removeFrom(aPath);
        return this;
    }

    @Override
    public HttpBodyTable withRemoveFrom(Object ... aPathElements) {
        this.removeFrom(aPathElements);
        return this;
    }

    @Override
    public HttpBodyTable withRemoveFrom(String aPath) {
        this.removeFrom(aPath);
        return this;
    }

    @Override
    public HttpBodyTable withRemoveFrom(String ... aPathElements) {
        this.removeFrom(aPathElements);
        return this;
    }

    @Override
    public HttpBodyTable withRemovePaths(String ... aPathElements) {
        this.removeFrom(aPathElements);
        return this;
    }
}

