/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.struct.CanonicalTable;
import org.refcodes.struct.MapCanonicalTable;
import org.refcodes.struct.ext.factory.DocumentOptions;
import org.refcodes.struct.ext.factory.HtmlCanonicalTableFactorySingleton;
import org.refcodes.web.HttpBodyTable;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeFactory;

public class HtmlMediaTypeFactory
implements MediaTypeFactory {
    private static final MediaType[] MEDIA_TYPES = new MediaType[]{MediaType.TEXT_HTML, MediaType.APPLICATION_XHTML_XML};

    @Override
    public MediaType[] getMediaTypes() {
        return MEDIA_TYPES;
    }

    @Override
    public <SRC> String toMarshaled(SRC aObject, DocumentOptions aOptions) throws MarshalException {
        MapCanonicalTable theCanoniocalMap = new MapCanonicalTable(aObject);
        if (aObject.getClass().isArray()) {
            theCanoniocalMap = new MapCanonicalTable(theCanoniocalMap.retrieveTo("html", "body", "value"));
            theCanoniocalMap.put(new String[]{"html", "body", TYPE_ANNOTATION}, aObject.getClass().getName());
        } else if (Collection.class.isAssignableFrom(aObject.getClass())) {
            theCanoniocalMap = new MapCanonicalTable(theCanoniocalMap.retrieveTo("html", "body", "value"));
            theCanoniocalMap.put(new String[]{"html", "body", TYPE_ANNOTATION}, aObject.getClass().getName());
        } else if (Map.class.isAssignableFrom(aObject.getClass()) && theCanoniocalMap.dirs().size() == 0) {
            theCanoniocalMap = new MapCanonicalTable(theCanoniocalMap.retrieveTo("html", "body", "value"));
            theCanoniocalMap.put(new String[]{"html", "body", TYPE_ANNOTATION}, aObject.getClass().getName());
        }
        return HtmlCanonicalTableFactorySingleton.getInstance().toMarshaled(theCanoniocalMap, aOptions);
    }

    @Override
    public <T> T toUnmarshaled(String aHttpBody, Class<T> aType, DocumentOptions aOptions) throws UnmarshalException {
        CanonicalTable theCanoniocalMap = HtmlCanonicalTableFactorySingleton.getInstance().toUnmarshaled(aHttpBody, aOptions);
        if (aType.isArray()) {
            theCanoniocalMap = theCanoniocalMap.retrieveFrom("html", "body", "value");
        } else if (Collection.class.isAssignableFrom(aType)) {
            theCanoniocalMap = theCanoniocalMap.retrieveFrom("html", "body", "value");
        } else if (Map.class.isAssignableFrom(aType) && theCanoniocalMap.dirs().size() == 1 && theCanoniocalMap.leaves().size() == 0 && theCanoniocalMap.isDir("html", "body", "value") && theCanoniocalMap.dirs("html", "body").size() == 1) {
            theCanoniocalMap = theCanoniocalMap.retrieveFrom("html", "body", "value");
        } else {
            if (aType.isAssignableFrom(HttpBodyTable.class)) {
                return (T)new HttpBodyTable((Object)theCanoniocalMap);
            }
            theCanoniocalMap = theCanoniocalMap.hasValue("html", "body", "value") && theCanoniocalMap.leaves().size() == 1 && theCanoniocalMap.dirs().size() == 0 || theCanoniocalMap.isDir("html", "body", "value") && theCanoniocalMap.leaves().size() == 0 && theCanoniocalMap.dirs().size() == 1 ? theCanoniocalMap.retrieveFrom("html", "body", "value") : theCanoniocalMap.retrieveFrom("html", "body");
        }
        return theCanoniocalMap.toType(aType);
    }

    @Override
    public Object fromMarshaled(InputStream aContentInputStream, DocumentOptions aOptions, Class<?> ... aTypes) throws UnmarshalException {
        CanonicalTable theBuilder = HtmlCanonicalTableFactorySingleton.getInstance().fromMarshaled(aContentInputStream, aOptions);
        for (Class<?> eType : aTypes) {
            try {
                return theBuilder.toType(eType);
            }
            catch (Exception exception) {
            }
        }
        throw new UnmarshalException("Unable to unmarshal the input stream to fit into one of the provided types.");
    }
}

