/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial.alt.tty;

import com.fazecast.jSerialComm.SerialPort;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.serial.NoSuchPortExcpetion;
import org.refcodes.serial.PortHub;
import org.refcodes.serial.alt.tty.TtyPort;
import org.refcodes.serial.alt.tty.TtyPortMetrics;

public class TtyPortHub
implements PortHub<TtyPort, TtyPortMetrics> {
    private ExecutorService _executorService;

    public TtyPortHub() {
        this(ControlFlowUtility.createCachedExecutorService(true));
    }

    public TtyPortHub(ExecutorService aExecutorService) {
        this._executorService = aExecutorService != null ? aExecutorService : ControlFlowUtility.createCachedExecutorService(true);
    }

    public TtyPort[] ports() throws IOException {
        SerialPort[] theSerialPorts = SerialPort.getCommPorts();
        if (theSerialPorts != null) {
            Object[] theTtyPorts = new TtyPort[theSerialPorts.length];
            for (int i = 0; i < theSerialPorts.length; ++i) {
                theTtyPorts[i] = this.toTtyPort(theSerialPorts[i], new TtyPortMetrics(theSerialPorts[i]));
            }
            Arrays.sort(theTtyPorts);
            return theTtyPorts;
        }
        return new TtyPort[0];
    }

    @Override
    public TtyPort toPort(String aAlias, TtyPortMetrics aPortMetrics) throws IOException {
        SerialPort theSerialPort;
        block2: {
            SerialPort[] theSerialPorts;
            theSerialPort = SerialPort.getCommPort(aAlias);
            if (theSerialPort == null && (theSerialPorts = SerialPort.getCommPorts()) != null) {
                for (int i = 0; i < theSerialPorts.length; ++i) {
                    if (!aAlias.equalsIgnoreCase(theSerialPorts[i].getSystemPortName())) continue;
                    theSerialPort = theSerialPorts[i];
                    break block2;
                }
                throw new NoSuchPortExcpetion(aAlias, "No such port with the given alias <" + aAlias + "> found!");
            }
        }
        return this.toTtyPort(theSerialPort, aPortMetrics != null ? aPortMetrics : new TtyPortMetrics(theSerialPort));
    }

    private TtyPort toTtyPort(SerialPort aSerialPort, TtyPortMetrics aPortMetrics) {
        return new TtyPort(aSerialPort.getSystemPortName(), aPortMetrics != null ? aPortMetrics : new TtyPortMetrics(aSerialPort), aSerialPort.getDescriptivePortName(), aSerialPort.getPortDescription(), aSerialPort, this._executorService);
    }
}

