/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.refcodes.data.AckTimeout;
import org.refcodes.data.IoHeurisitcsTimeToLive;
import org.refcodes.data.IoRetryCount;
import org.refcodes.data.IoTimeout;
import org.refcodes.mixin.BlockSizeAccessor;
import org.refcodes.mixin.ConcatenateMode;
import org.refcodes.mixin.EncodingAccessor;
import org.refcodes.mixin.ReadTimeoutMillisAccessor;
import org.refcodes.mixin.WriteTimeoutMillisAccessor;
import org.refcodes.numerical.ChecksumValidationMode;
import org.refcodes.numerical.ChecksumValidationModeAccessor;
import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.CrcAlgorithmAccessor;
import org.refcodes.numerical.CrcChecksumConcatenateModeAccessor;
import org.refcodes.numerical.CrcStandard;
import org.refcodes.numerical.Endianess;
import org.refcodes.numerical.EndianessAccessor;
import org.refcodes.serial.AcknowledgeMagicBytesAccessor;
import org.refcodes.serial.AcknowledgeRetryNumberAccessor;
import org.refcodes.serial.AcknowledgeSegmentPackagerAccessor;
import org.refcodes.serial.AcknowledgeTimeoutMillisAccessor;
import org.refcodes.serial.ClearToSendMagicBytesAccessor;
import org.refcodes.serial.ClearToSendSegmentPackagerAccessor;
import org.refcodes.serial.ClearToSendTimeoutMillisAccessor;
import org.refcodes.serial.CrcSegmentPackager;
import org.refcodes.serial.EndOfStringByteAccessor;
import org.refcodes.serial.EnquiryStandbyTimeMillisAccessor;
import org.refcodes.serial.IoHeuristicsTimeToLiveMillisAccessor;
import org.refcodes.serial.LengthWidthAccessor;
import org.refcodes.serial.MagicBytes;
import org.refcodes.serial.MagicBytesLengthAccessor;
import org.refcodes.serial.PacketLengthWidthAccessor;
import org.refcodes.serial.PacketMagicBytesAccessor;
import org.refcodes.serial.PacketSegmentPackagerAccessor;
import org.refcodes.serial.PingMagicBytesAccessor;
import org.refcodes.serial.PingRetryNumberAccessor;
import org.refcodes.serial.PingTimeoutMillisAccessor;
import org.refcodes.serial.PongMagicBytesAccessor;
import org.refcodes.serial.ReadyToReceiveMagicBytesAccessor;
import org.refcodes.serial.ReadyToReceiveRetryNumberAccessor;
import org.refcodes.serial.ReadyToReceiveSegmentPackagerAccessor;
import org.refcodes.serial.ReadyToReceiveTimeoutMillisAccessor;
import org.refcodes.serial.ReadyToSendMagicBytesAccessor;
import org.refcodes.serial.ReadyToSendRetryNumberAccessor;
import org.refcodes.serial.ReadyToSendSegmentPackagerAccessor;
import org.refcodes.serial.ReadyToSendTimeoutMillisAccessor;
import org.refcodes.serial.SegmentPackager;
import org.refcodes.serial.SequenceNumberConcatenateModeAccessor;
import org.refcodes.serial.SequenceNumberInitValueAccessor;
import org.refcodes.serial.SequenceNumberWidthAccessor;
import org.refcodes.serial.TransmissionRetryNumberAccessor;
import org.refcodes.serial.TransmissionTimeoutMillisAccessor;

public class TransmissionMetrics
implements AcknowledgeMagicBytesAccessor,
AcknowledgeTimeoutMillisAccessor,
AcknowledgeRetryNumberAccessor,
TransmissionTimeoutMillisAccessor,
TransmissionRetryNumberAccessor,
LengthWidthAccessor,
CrcAlgorithmAccessor,
ChecksumValidationModeAccessor,
EndianessAccessor,
BlockSizeAccessor,
SequenceNumberWidthAccessor,
SequenceNumberInitValueAccessor,
ReadTimeoutMillisAccessor,
WriteTimeoutMillisAccessor,
SequenceNumberConcatenateModeAccessor,
CrcChecksumConcatenateModeAccessor,
MagicBytesLengthAccessor,
EncodingAccessor<Charset>,
AcknowledgeSegmentPackagerAccessor,
PacketSegmentPackagerAccessor,
ReadyToReceiveSegmentPackagerAccessor,
ReadyToReceiveTimeoutMillisAccessor,
ReadyToReceiveMagicBytesAccessor,
ReadyToReceiveRetryNumberAccessor,
EnquiryStandbyTimeMillisAccessor,
ReadyToSendTimeoutMillisAccessor,
ReadyToSendMagicBytesAccessor,
ReadyToSendRetryNumberAccessor,
ReadyToSendSegmentPackagerAccessor,
ClearToSendTimeoutMillisAccessor,
ClearToSendMagicBytesAccessor,
ClearToSendSegmentPackagerAccessor,
EndOfStringByteAccessor,
PacketMagicBytesAccessor,
PacketLengthWidthAccessor,
PingMagicBytesAccessor,
PingTimeoutMillisAccessor,
PingRetryNumberAccessor,
PongMagicBytesAccessor,
IoHeuristicsTimeToLiveMillisAccessor {
    public static final byte[] DEFAULT_ACKNOWLEDGE_MAGIC_BYTES = MagicBytes.ACKNOWLEDGE.getMagicBytes();
    public static final byte[] DEFAULT_CLEAR_TO_SEND_MAGIC_BYTES = MagicBytes.CLEAR_TO_SEND.getMagicBytes();
    public static final byte[] DEFAULT_PACKET_MAGIC_BYTES = MagicBytes.PACKET.getMagicBytes();
    public static final byte[] DEFAULT_LAST_PACKET_MAGIC_BYTES = MagicBytes.LAST_PACKET.getMagicBytes();
    public static final byte[] DEFAULT_READY_TO_RECEIVE_MAGIC_BYTES = MagicBytes.READY_TO_RECEIVE.getMagicBytes();
    public static final byte[] DEFAULT_READY_TO_SEND_MAGIC_BYTES = MagicBytes.READY_TO_SEND.getMagicBytes();
    private static final byte[] DEFAULT_PONG_MAGIC_BYTES = MagicBytes.PONG.getMagicBytes();
    private static final byte[] DEFAULT_PING_MAGIC_BYTES = MagicBytes.PING.getMagicBytes();
    public static final int DEFAULT_ACKNOWLEDGE_RETRY_NUMBER = IoRetryCount.NORM.getValue();
    public static final long DEFAULT_ACKNOWLEDGE_TIMEOUT_IN_MS = AckTimeout.NORM.getTimeMillis();
    public static final int DEFAULT_PING_RETRY_NUMBER = IoRetryCount.MIN.getValue();
    public static final long DEFAULT_PING_TIMEOUT_IN_MS = AckTimeout.MIN.getTimeMillis();
    public static final int DEFAULT_BLOCK_SIZE = 1024;
    public static final long DEFAULT_CLEAR_TO_SEND_TIMEOUT_IN_MS = AckTimeout.NORM.getTimeMillis();
    public static final CrcAlgorithm DEFAULT_CRC_ALGORITHM = CrcStandard.CRC_16_X25;
    public static final ConcatenateMode DEFAULT_CRC_CHECKSUM_CONCATENATE_MODE = ConcatenateMode.APPEND;
    public static final ChecksumValidationMode DEFAULT_CHECKSUM_VALIDATION_MODE = ChecksumValidationMode.ENFORCE_VALID_CHECKSUM;
    public static final Charset DEFAULT_ENCODING = StandardCharsets.UTF_8;
    public static final byte DEFAULT_END_OF_STRING_BYTE = 0;
    public static final Endianess DEFAULT_ENDIANESS = Endianess.LITTLE;
    public static final long DEFAULT_ENQUIERY_STRANDBY_TIME_IN_MS = -1L;
    public static final int DEFAULT_LENGTH_WIDTH = 4;
    public static final int DEFAULT_TRUNCATE_LENGTH_WIDTH = 4;
    public static final int DEFAULT_MAGIC_BYTES_LENGTH = 4;
    public static final long DEFAULT_READ_TIMEOUT_IN_MS = IoTimeout.NORM.getTimeMillis();
    public static final int DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER = IoRetryCount.MAX.getValue();
    public static final long DEFAULT_READY_TO_RECEIVE_TIMEOUT_IN_MS = AckTimeout.NORM.getTimeMillis();
    public static final int DEFAULT_READY_TO_SEND_RETRY_NUMBER = IoRetryCount.MAX.getValue();
    public static final long DEFAULT_READY_TO_SEND_TIMEOUT_IN_MS = AckTimeout.NORM.getTimeMillis();
    public static final ConcatenateMode DEFAULT_SEQUENCE_NUMBER_CONCATENATE_MODE = ConcatenateMode.PREPEND;
    public static final int DEFAULT_SEQUENCE_NUMBER_INIT_VALUE = -1;
    public static final int DEFAULT_SEQUENCE_NUMBER_WIDTH = 4;
    public static final int DEFAULT_TRANSMISSION_RETRY_NUMBER = IoRetryCount.NORM.getValue();
    public static final long DEFAULT_TRANSMISSION_TIMEOUT_IN_MS = AckTimeout.NORM.getTimeMillis();
    public static final long DEFAULT_WRITE_TIMEOUT_IN_MS = IoTimeout.NORM.getTimeMillis();
    public static final long DEFAULT_IO_HEURISTICS_TIME_TO_LIVE_IN_MS = IoHeurisitcsTimeToLive.NORM.getTimeMillis();
    protected byte[] _acknowledgeMagicBytes = DEFAULT_ACKNOWLEDGE_MAGIC_BYTES;
    protected byte[] _clearToSendMagicBytes = DEFAULT_CLEAR_TO_SEND_MAGIC_BYTES;
    protected byte[] _packetMagicBytes = DEFAULT_PACKET_MAGIC_BYTES;
    protected byte[] _readyToReceiveMagicBytes = DEFAULT_READY_TO_RECEIVE_MAGIC_BYTES;
    protected byte[] _readyToSendMagicBytes = DEFAULT_READY_TO_SEND_MAGIC_BYTES;
    protected byte[] _pingMagicBytes = DEFAULT_PING_MAGIC_BYTES;
    protected byte[] _pongMagicBytes = DEFAULT_PONG_MAGIC_BYTES;
    protected SegmentPackager _acknowledgeSegmentPackager;
    protected int _acknowledgeRetryNumber = DEFAULT_ACKNOWLEDGE_RETRY_NUMBER;
    protected long _acknowledgeTimeoutInMs = DEFAULT_ACKNOWLEDGE_TIMEOUT_IN_MS;
    protected int _pingRetryNumber = DEFAULT_PING_RETRY_NUMBER;
    protected long _pingTimeoutInMs = DEFAULT_PING_TIMEOUT_IN_MS;
    protected int _blockSize = 1024;
    protected ChecksumValidationMode _checksumValidationMode = DEFAULT_CHECKSUM_VALIDATION_MODE;
    protected SegmentPackager _clearToSendSegmentPackager;
    protected long _clearToSendTimeoutInMs = DEFAULT_CLEAR_TO_SEND_TIMEOUT_IN_MS;
    protected CrcAlgorithm _crcAlgorithm = DEFAULT_CRC_ALGORITHM;
    protected ConcatenateMode _crcChecksumConcatenateMode = DEFAULT_CRC_CHECKSUM_CONCATENATE_MODE;
    protected Charset _encoding = DEFAULT_ENCODING;
    protected Endianess _endianess = DEFAULT_ENDIANESS;
    protected byte _endOfStringByte = 0;
    protected long _enquiryStandbyTimeInMs = -1L;
    protected int _lengthWidth = 4;
    protected int _packetLengthWidth = 4;
    protected int _magicBytesLength = 4;
    protected SegmentPackager _packetSegmentPackager;
    protected long _readTimeoutInMs = DEFAULT_READ_TIMEOUT_IN_MS;
    protected int _readyToReceiveRetryNumber = DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER;
    protected SegmentPackager _readyToReceiveSegmentPackager;
    protected long _readyToReceiveTimeoutInMs = DEFAULT_READY_TO_RECEIVE_TIMEOUT_IN_MS;
    protected int _readyToSendRetryNumber = DEFAULT_READY_TO_SEND_RETRY_NUMBER;
    protected SegmentPackager _readyToSendSegmentPackager;
    protected long _readyToSendTimeoutInMs = DEFAULT_READY_TO_SEND_TIMEOUT_IN_MS;
    protected ConcatenateMode _sequenceNumberConcatenateMode = DEFAULT_SEQUENCE_NUMBER_CONCATENATE_MODE;
    protected int _sequenceNumberInitValue = -1;
    protected int _sequenceNumberWidth = 4;
    protected int _transmissionRetryNumber = DEFAULT_TRANSMISSION_RETRY_NUMBER;
    protected long _transmissionTimeoutInMs = DEFAULT_TRANSMISSION_TIMEOUT_IN_MS;
    protected long _writeTimeoutInMs = DEFAULT_WRITE_TIMEOUT_IN_MS;
    protected long _ioHeuristicsTimeToLiveInMs = DEFAULT_IO_HEURISTICS_TIME_TO_LIVE_IN_MS;

    protected TransmissionMetrics(Builder aBuilder) {
        this._pingMagicBytes = aBuilder.pingMagicBytes;
        this._pongMagicBytes = aBuilder.pongMagicBytes;
        this._acknowledgeMagicBytes = aBuilder.acknowledgeMagicBytes;
        this._clearToSendMagicBytes = aBuilder.clearToSendMagicBytes;
        this._packetMagicBytes = aBuilder.packetMagicBytes;
        this._readyToReceiveMagicBytes = aBuilder.readyToReceiveMagicBytes;
        this._readyToSendMagicBytes = aBuilder.readyToSendMagicBytes;
        this._acknowledgeSegmentPackager = aBuilder.acknowledgeSegmentPackager;
        this._acknowledgeRetryNumber = aBuilder.acknowledgeRetryNumber;
        this._acknowledgeTimeoutInMs = aBuilder.acknowledgeTimeoutInMs;
        this._pingRetryNumber = aBuilder.pingRetryNumber;
        this._pingTimeoutInMs = aBuilder.pingTimeoutInMs;
        this._blockSize = aBuilder.blockSize;
        this._clearToSendSegmentPackager = aBuilder.clearToSendSegmentPackager;
        this._clearToSendTimeoutInMs = aBuilder.clearToSendTimeoutInMs;
        this._crcAlgorithm = aBuilder.crcAlgorithm;
        this._crcChecksumConcatenateMode = aBuilder.crcChecksumConcatenateMode;
        this._checksumValidationMode = aBuilder.checksumValidationMode;
        this._encoding = aBuilder.encoding;
        this._endianess = aBuilder.endianess;
        this._endOfStringByte = aBuilder.endOfStringByte;
        this._enquiryStandbyTimeInMs = aBuilder.enquiryStandbyTimeInMs;
        this._lengthWidth = aBuilder.lengthWidth;
        this._packetLengthWidth = aBuilder.packetLengthWidth;
        this._magicBytesLength = aBuilder.magicBytesLength;
        this._packetSegmentPackager = aBuilder.packetSegmentPackager;
        this._readTimeoutInMs = aBuilder.readTimeoutInMs;
        this._readyToReceiveRetryNumber = aBuilder.readyToReceiveRetryNumber;
        this._readyToReceiveSegmentPackager = aBuilder.readyToReceiveSegmentPackager;
        this._readyToReceiveTimeoutInMs = aBuilder.readyToReceiveTimeoutInMs;
        this._readyToSendRetryNumber = aBuilder.readyToSendRetryNumber;
        this._readyToSendSegmentPackager = aBuilder.readyToSendSegmentPackager;
        this._readyToSendTimeoutInMs = aBuilder.readyToSendTimeoutInMs;
        this._sequenceNumberConcatenateMode = aBuilder.sequenceNumberConcatenateMode;
        this._sequenceNumberInitValue = aBuilder.sequenceNumberInitValue;
        this._sequenceNumberWidth = aBuilder.sequenceNumberWidth;
        this._transmissionRetryNumber = aBuilder.transmissionRetryNumber;
        this._transmissionTimeoutInMs = aBuilder.transmissionTimeoutInMs;
        this._writeTimeoutInMs = aBuilder.writeTimeoutInMs;
        this._ioHeuristicsTimeToLiveInMs = aBuilder.ioHeuristicsTimeToLiveInMs;
    }

    public TransmissionMetrics() {
    }

    public SegmentPackager toAckSegmentPackager() {
        if (this.getAcknowledgeSegmentPackager() != null) {
            return this.getAcknowledgeSegmentPackager();
        }
        if (this.getCrcAlgorithm() != null || this.getChecksumValidationMode() != null) {
            CrcAlgorithm theCrcAlgorithm = this.getCrcAlgorithm() != null ? this.getCrcAlgorithm() : DEFAULT_CRC_ALGORITHM;
            ChecksumValidationMode theCrcChecksumValidationMode = this.getChecksumValidationMode() != null ? this.getChecksumValidationMode() : DEFAULT_CHECKSUM_VALIDATION_MODE;
            ConcatenateMode theCrcChecksumConcatenateMode = this.getCrcChecksumConcatenateMode() != null ? this.getCrcChecksumConcatenateMode() : DEFAULT_CRC_CHECKSUM_CONCATENATE_MODE;
            Endianess theEndianess = this.getEndianess() != null ? this.getEndianess() : DEFAULT_ENDIANESS;
            return new CrcSegmentPackager(theCrcAlgorithm, theCrcChecksumConcatenateMode, theCrcChecksumValidationMode, theEndianess);
        }
        return new SegmentPackager.DummySegmentPackager();
    }

    public SegmentPackager toPacketSegmentPackager() {
        if (this.getPacketSegmentPackager() != null) {
            return this.getPacketSegmentPackager();
        }
        if (this.getCrcAlgorithm() != null || this.getChecksumValidationMode() != null) {
            CrcAlgorithm theCrcAlgorithm = this.getCrcAlgorithm() != null ? this.getCrcAlgorithm() : DEFAULT_CRC_ALGORITHM;
            ChecksumValidationMode theCrcChecksumValidationMode = this.getChecksumValidationMode() != null ? this.getChecksumValidationMode() : DEFAULT_CHECKSUM_VALIDATION_MODE;
            ConcatenateMode theCrcChecksumConcatenateMode = this.getCrcChecksumConcatenateMode() != null ? this.getCrcChecksumConcatenateMode() : DEFAULT_CRC_CHECKSUM_CONCATENATE_MODE;
            Endianess theEndianess = this.getEndianess() != null ? this.getEndianess() : DEFAULT_ENDIANESS;
            return new CrcSegmentPackager(theCrcAlgorithm, theCrcChecksumConcatenateMode, theCrcChecksumValidationMode, theEndianess);
        }
        return new SegmentPackager.DummySegmentPackager();
    }

    @Override
    public byte[] getPongMagicBytes() {
        return this._pongMagicBytes;
    }

    @Override
    public byte[] getPingMagicBytes() {
        return this._pingMagicBytes;
    }

    @Override
    public int getPacketLengthWidth() {
        return this._packetLengthWidth;
    }

    @Override
    public byte[] getAcknowledgeMagicBytes() {
        return this._acknowledgeMagicBytes;
    }

    @Override
    public SegmentPackager getAcknowledgeSegmentPackager() {
        return this._acknowledgeSegmentPackager;
    }

    @Override
    public int getAcknowledgeRetryNumber() {
        return this._acknowledgeRetryNumber;
    }

    @Override
    public long getAcknowledgeTimeoutMillis() {
        return this._acknowledgeTimeoutInMs;
    }

    @Override
    public long getPingTimeoutMillis() {
        return this._pingTimeoutInMs;
    }

    @Override
    public int getPingRetryNumber() {
        return this._pingRetryNumber;
    }

    @Override
    public int getBlockSize() {
        return this._blockSize;
    }

    @Override
    public byte[] getClearToSendMagicBytes() {
        return this._clearToSendMagicBytes;
    }

    @Override
    public SegmentPackager getClearToSendSegmentPackager() {
        return this._clearToSendSegmentPackager;
    }

    @Override
    public long getClearToSendTimeoutMillis() {
        return this._clearToSendTimeoutInMs;
    }

    @Override
    public CrcAlgorithm getCrcAlgorithm() {
        return this._crcAlgorithm;
    }

    @Override
    public ConcatenateMode getCrcChecksumConcatenateMode() {
        return this._crcChecksumConcatenateMode;
    }

    @Override
    public ChecksumValidationMode getChecksumValidationMode() {
        return this._checksumValidationMode;
    }

    @Override
    public Charset getEncoding() {
        return this._encoding;
    }

    @Override
    public Endianess getEndianess() {
        return this._endianess;
    }

    @Override
    public byte getEndOfStringByte() {
        return this._endOfStringByte;
    }

    @Override
    public long getEnquiryStandbyTimeMillis() {
        return this._enquiryStandbyTimeInMs;
    }

    @Override
    public int getLengthWidth() {
        return this._lengthWidth;
    }

    @Override
    public int getMagicBytesLength() {
        return this._magicBytesLength;
    }

    @Override
    public byte[] getPacketMagicBytes() {
        return this._packetMagicBytes;
    }

    @Override
    public SegmentPackager getPacketSegmentPackager() {
        return this._packetSegmentPackager;
    }

    @Override
    public long getReadTimeoutMillis() {
        return this._readTimeoutInMs;
    }

    @Override
    public byte[] getReadyToReceiveMagicBytes() {
        return this._readyToReceiveMagicBytes;
    }

    @Override
    public int getReadyToReceiveRetryNumber() {
        return this._readyToReceiveRetryNumber;
    }

    @Override
    public SegmentPackager getReadyToReceiveSegmentPackager() {
        return this._readyToReceiveSegmentPackager;
    }

    @Override
    public long getReadyToReceiveTimeoutMillis() {
        return this._readyToReceiveTimeoutInMs;
    }

    @Override
    public byte[] getReadyToSendMagicBytes() {
        return this._readyToSendMagicBytes;
    }

    @Override
    public int getReadyToSendRetryNumber() {
        return this._readyToSendRetryNumber;
    }

    @Override
    public SegmentPackager getReadyToSendSegmentPackager() {
        return this._readyToSendSegmentPackager;
    }

    @Override
    public long getReadyToSendTimeoutMillis() {
        return this._readyToSendTimeoutInMs;
    }

    @Override
    public ConcatenateMode getSequenceNumberConcatenateMode() {
        return this._sequenceNumberConcatenateMode;
    }

    @Override
    public int getSequenceNumberInitValue() {
        return this._sequenceNumberInitValue;
    }

    @Override
    public int getSequenceNumberWidth() {
        return this._sequenceNumberWidth;
    }

    @Override
    public int getTransmissionRetryNumber() {
        return this._transmissionRetryNumber;
    }

    @Override
    public long getTransmissionTimeoutMillis() {
        return this._transmissionTimeoutInMs;
    }

    @Override
    public long getWriteTimeoutMillis() {
        return this._writeTimeoutInMs;
    }

    @Override
    public long getIoHeuristicsTimeToLiveMillis() {
        return this._ioHeuristicsTimeToLiveInMs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements AcknowledgeMagicBytesAccessor.AcknowledgeMagicBytesBuilder<Builder>,
    AcknowledgeTimeoutMillisAccessor.AcknowledgeTimeoutMillisBuilder<Builder>,
    AcknowledgeRetryNumberAccessor.AcknowledgeRetryNumberBuilder<Builder>,
    TransmissionTimeoutMillisAccessor.TransmissionTimeoutMillisBuilder<Builder>,
    TransmissionRetryNumberAccessor.TransmissionRetryNumberBuilder<Builder>,
    LengthWidthAccessor.LengthWidthBuilder<Builder>,
    CrcAlgorithmAccessor.CrcAlgorithmBuilder<Builder>,
    ChecksumValidationModeAccessor.ChecksumValidationModeBuilder<Builder>,
    EndianessAccessor.EndianessBuilder<Builder>,
    BlockSizeAccessor.BlockSizeBuilder<Builder>,
    SequenceNumberWidthAccessor.SequenceNumberWidthBuilder<Builder>,
    SequenceNumberInitValueAccessor.SequenceNumberInitValueBuilder<Builder>,
    ReadTimeoutMillisAccessor.ReadTimeoutMillisBuilder<Builder>,
    WriteTimeoutMillisAccessor.WriteTimeoutMillisBuilder<Builder>,
    SequenceNumberConcatenateModeAccessor.SequenceNumberConcatenateModeBuilder<Builder>,
    CrcChecksumConcatenateModeAccessor.CrcChecksumConcatenateModeBuilder<Builder>,
    MagicBytesLengthAccessor.MagicBytesLengthBuilder<Builder>,
    EncodingAccessor.EncodingBuilder<Charset, Builder>,
    AcknowledgeSegmentPackagerAccessor.AcknowledgeSegmentPackagerBuilder<Builder>,
    PacketSegmentPackagerAccessor.PacketSegmentPackagerBuilder<Builder>,
    ReadyToReceiveSegmentPackagerAccessor.ReadyToReceiveSegmentPackagerBuilder<Builder>,
    ReadyToReceiveTimeoutMillisAccessor.ReadyToReceiveTimeoutMillisBuilder<Builder>,
    ReadyToReceiveMagicBytesAccessor.ReadyToReceiveMagicBytesBuilder<Builder>,
    ReadyToReceiveRetryNumberAccessor.ReadyToReceiveRetryNumberBuilder<Builder>,
    EnquiryStandbyTimeMillisAccessor.EnquiryStandbyTimeMillisBuilder<Builder>,
    ReadyToSendTimeoutMillisAccessor.ReadyToSendTimeoutMillisBuilder<Builder>,
    ReadyToSendMagicBytesAccessor.ReadyToSendMagicBytesBuilder<Builder>,
    ReadyToSendRetryNumberAccessor.ReadyToSendRetryNumberBuilder<Builder>,
    ReadyToSendSegmentPackagerAccessor.ReadyToSendSegmentPackagerBuilder<Builder>,
    ClearToSendTimeoutMillisAccessor.ClearToSendTimeoutMillisBuilder<Builder>,
    ClearToSendMagicBytesAccessor.ClearToSendMagicBytesBuilder<Builder>,
    ClearToSendSegmentPackagerAccessor.ClearToSendSegmentPackagerBuilder<Builder>,
    EndOfStringByteAccessor.EndOfStringByteBuilder<Builder>,
    PacketMagicBytesAccessor.PacketMagicBytesBuilder<Builder>,
    PacketLengthWidthAccessor.PacketLengthWidthBuilder<Builder>,
    PingMagicBytesAccessor.PingMagicBytesBuilder<Builder>,
    PingRetryNumberAccessor.PingRetryNumberBuilder<Builder>,
    PingTimeoutMillisAccessor.PingTimeoutMillisBuilder<Builder>,
    PongMagicBytesAccessor.PongMagicBytesBuilder<Builder>,
    IoHeuristicsTimeToLiveMillisAccessor.IoHeuristicsTimeToLiveMillisBuilder<Builder> {
        protected byte[] acknowledgeMagicBytes = DEFAULT_ACKNOWLEDGE_MAGIC_BYTES;
        protected byte[] clearToSendMagicBytes = DEFAULT_CLEAR_TO_SEND_MAGIC_BYTES;
        protected byte[] packetMagicBytes = DEFAULT_PACKET_MAGIC_BYTES;
        protected byte[] readyToReceiveMagicBytes = DEFAULT_READY_TO_RECEIVE_MAGIC_BYTES;
        protected byte[] readyToSendMagicBytes = DEFAULT_READY_TO_SEND_MAGIC_BYTES;
        protected byte[] pingMagicBytes = DEFAULT_PING_MAGIC_BYTES;
        protected byte[] pongMagicBytes = DEFAULT_PONG_MAGIC_BYTES;
        protected SegmentPackager acknowledgeSegmentPackager;
        protected long acknowledgeTimeoutInMs = DEFAULT_ACKNOWLEDGE_TIMEOUT_IN_MS;
        protected int acknowledgeRetryNumber = DEFAULT_ACKNOWLEDGE_RETRY_NUMBER;
        protected long pingTimeoutInMs = DEFAULT_PING_TIMEOUT_IN_MS;
        protected int pingRetryNumber = DEFAULT_PING_RETRY_NUMBER;
        protected int blockSize = 1024;
        protected SegmentPackager clearToSendSegmentPackager;
        protected long clearToSendTimeoutInMs = DEFAULT_CLEAR_TO_SEND_TIMEOUT_IN_MS;
        protected CrcAlgorithm crcAlgorithm = DEFAULT_CRC_ALGORITHM;
        protected ConcatenateMode crcChecksumConcatenateMode = DEFAULT_CRC_CHECKSUM_CONCATENATE_MODE;
        protected ChecksumValidationMode checksumValidationMode = DEFAULT_CHECKSUM_VALIDATION_MODE;
        protected Charset encoding = DEFAULT_ENCODING;
        protected Endianess endianess = DEFAULT_ENDIANESS;
        protected byte endOfStringByte = 0;
        protected long enquiryStandbyTimeInMs = -1L;
        protected int lengthWidth = 4;
        protected int packetLengthWidth = 4;
        protected int magicBytesLength = 4;
        protected SegmentPackager packetSegmentPackager;
        protected long readTimeoutInMs = DEFAULT_READ_TIMEOUT_IN_MS;
        protected int readyToReceiveRetryNumber = DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER;
        protected SegmentPackager readyToReceiveSegmentPackager;
        protected long readyToReceiveTimeoutInMs = DEFAULT_READY_TO_RECEIVE_TIMEOUT_IN_MS;
        protected int readyToSendRetryNumber = DEFAULT_READY_TO_SEND_RETRY_NUMBER;
        protected SegmentPackager readyToSendSegmentPackager;
        protected long readyToSendTimeoutInMs = DEFAULT_READY_TO_SEND_TIMEOUT_IN_MS;
        protected ConcatenateMode sequenceNumberConcatenateMode = DEFAULT_SEQUENCE_NUMBER_CONCATENATE_MODE;
        protected int sequenceNumberInitValue = -1;
        protected int sequenceNumberWidth = 4;
        protected int transmissionRetryNumber = DEFAULT_TRANSMISSION_RETRY_NUMBER;
        protected long transmissionTimeoutInMs = DEFAULT_TRANSMISSION_TIMEOUT_IN_MS;
        protected long writeTimeoutInMs = DEFAULT_WRITE_TIMEOUT_IN_MS;
        protected long ioHeuristicsTimeToLiveInMs = DEFAULT_IO_HEURISTICS_TIME_TO_LIVE_IN_MS;

        protected Builder() {
        }

        @Override
        public Builder withAcknowledgeMagicBytes(byte[] aAcknowledgeMagicBytes) {
            this.acknowledgeMagicBytes = aAcknowledgeMagicBytes;
            return this;
        }

        @Override
        public Builder withClearToSendMagicBytes(byte[] aClearToSendMagicBytes) {
            this.clearToSendMagicBytes = aClearToSendMagicBytes;
            return this;
        }

        @Override
        public Builder withPacketMagicBytes(byte[] aPacketMagicBytes) {
            this.packetMagicBytes = aPacketMagicBytes;
            return this;
        }

        @Override
        public Builder withReadyToReceiveMagicBytes(byte[] aReadyToReceiveMagicBytes) {
            this.readyToReceiveMagicBytes = aReadyToReceiveMagicBytes;
            return this;
        }

        @Override
        public Builder withReadyToSendMagicBytes(byte[] aReadyToSendMagicBytes) {
            this.readyToSendMagicBytes = aReadyToSendMagicBytes;
            return this;
        }

        @Override
        public Builder withAcknowledgeSegmentPackager(SegmentPackager aAcknowledgeSegmentPackager) {
            this.acknowledgeSegmentPackager = aAcknowledgeSegmentPackager;
            return this;
        }

        @Override
        public Builder withAcknowledgeRetryNumber(int aAcknowledgeRetryNumber) {
            this.acknowledgeRetryNumber = aAcknowledgeRetryNumber;
            return this;
        }

        @Override
        public Builder withAcknowledgeTimeoutMillis(long aAcknowledgeTimeoutInMs) {
            this.acknowledgeTimeoutInMs = aAcknowledgeTimeoutInMs;
            return this;
        }

        @Override
        public Builder withPingRetryNumber(int aPingRetryNumber) {
            this.pingRetryNumber = aPingRetryNumber;
            return this;
        }

        @Override
        public Builder withPingTimeoutMillis(long aPingTimeoutInMs) {
            this.pingTimeoutInMs = aPingTimeoutInMs;
            return this;
        }

        @Override
        public Builder withBlockSize(int aBlockSize) {
            this.blockSize = aBlockSize;
            return this;
        }

        @Override
        public Builder withChecksumValidationMode(ChecksumValidationMode aChecksumValidationMode) {
            this.checksumValidationMode = aChecksumValidationMode;
            return this;
        }

        @Override
        public Builder withClearToSendSegmentPackager(SegmentPackager aClearToSendSegmentPackager) {
            this.clearToSendSegmentPackager = aClearToSendSegmentPackager;
            return this;
        }

        @Override
        public Builder withClearToSendTimeoutMillis(long aClearToSendTimeoutInMs) {
            this.clearToSendTimeoutInMs = aClearToSendTimeoutInMs;
            return this;
        }

        @Override
        public Builder withCrcAlgorithm(CrcAlgorithm aCrcAlgorithm) {
            this.crcAlgorithm = aCrcAlgorithm;
            return this;
        }

        @Override
        public Builder withCrcChecksumConcatenateMode(ConcatenateMode aChecksumConcatenateMode) {
            this.crcChecksumConcatenateMode = aChecksumConcatenateMode;
            return this;
        }

        @Override
        public Builder withEncoding(Charset aEncoding) {
            this.encoding = aEncoding;
            return this;
        }

        @Override
        public Builder withEndianess(Endianess aEndianess) {
            this.endianess = aEndianess;
            return this;
        }

        @Override
        public Builder withEndOfStringByte(byte aEndOfStringByte) {
            this.endOfStringByte = aEndOfStringByte;
            return this;
        }

        @Override
        public Builder withEnquiryStandbyTimeMillis(long aEnquiryStandbyTimeInMs) {
            this.enquiryStandbyTimeInMs = aEnquiryStandbyTimeInMs;
            return this;
        }

        @Override
        public Builder withLengthWidth(int aLengthWidth) {
            this.lengthWidth = aLengthWidth;
            return this;
        }

        @Override
        public Builder withPacketLengthWidth(int aPacketLengthWidth) {
            this.packetLengthWidth = aPacketLengthWidth;
            return this;
        }

        @Override
        public Builder withMagicBytesLength(int aMagicBytesLength) {
            this.magicBytesLength = aMagicBytesLength;
            return this;
        }

        @Override
        public Builder withPacketSegmentPackager(SegmentPackager aPacketSegmentPackager) {
            this.packetSegmentPackager = aPacketSegmentPackager;
            return this;
        }

        @Override
        public Builder withReadTimeoutMillis(long aReadTimeoutInMs) {
            this.readTimeoutInMs = aReadTimeoutInMs;
            return this;
        }

        @Override
        public Builder withReadyToReceiveRetryNumber(int aReadyToReceiveRetryNumber) {
            this.readyToReceiveRetryNumber = aReadyToReceiveRetryNumber;
            return this;
        }

        @Override
        public Builder withReadyToReceiveSegmentPackager(SegmentPackager aReadyToReceiveSegmentPackager) {
            this.readyToReceiveSegmentPackager = aReadyToReceiveSegmentPackager;
            return this;
        }

        @Override
        public Builder withReadyToReceiveTimeoutMillis(long aReadyToReceiveTimeoutInMs) {
            this.readyToReceiveTimeoutInMs = aReadyToReceiveTimeoutInMs;
            return this;
        }

        @Override
        public Builder withReadyToSendRetryNumber(int aReadyToSendRetryNumber) {
            this.readyToSendRetryNumber = aReadyToSendRetryNumber;
            return this;
        }

        @Override
        public Builder withReadyToSendSegmentPackager(SegmentPackager aReadyToSendSegmentPackager) {
            this.readyToSendSegmentPackager = aReadyToSendSegmentPackager;
            return this;
        }

        @Override
        public Builder withReadyToSendTimeoutMillis(long aReadyToSendTimeoutInMs) {
            this.readyToSendTimeoutInMs = aReadyToSendTimeoutInMs;
            return this;
        }

        @Override
        public Builder withSequenceNumberConcatenateMode(ConcatenateMode aSequenceNumberConcatenateMode) {
            this.sequenceNumberConcatenateMode = aSequenceNumberConcatenateMode;
            return this;
        }

        @Override
        public Builder withSequenceNumberInitValue(int aSequenceNumberInitValue) {
            this.sequenceNumberInitValue = aSequenceNumberInitValue;
            return this;
        }

        @Override
        public Builder withSequenceNumberWidth(int aSequenceNumberWidth) {
            this.sequenceNumberWidth = aSequenceNumberWidth;
            return this;
        }

        @Override
        public Builder withTransmissionRetryNumber(int aTransmissionRetryNumber) {
            this.transmissionRetryNumber = aTransmissionRetryNumber;
            return this;
        }

        @Override
        public Builder withTransmissionTimeoutMillis(long aTransmissionTimeoutInMs) {
            this.transmissionTimeoutInMs = aTransmissionTimeoutInMs;
            return this;
        }

        @Override
        public Builder withWriteTimeoutMillis(long aWriteTimeoutInMs) {
            this.writeTimeoutInMs = aWriteTimeoutInMs;
            return this;
        }

        @Override
        public Builder withPongMagicBytes(byte[] aPongMagicBytes) {
            this.pongMagicBytes = aPongMagicBytes;
            return this;
        }

        @Override
        public Builder withPingMagicBytes(byte[] aPingMagicBytes) {
            this.pingMagicBytes = aPingMagicBytes;
            return this;
        }

        @Override
        public Builder withIoHeuristicsTimeToLiveMillis(long aIoHeuristicsTimeToLiveInMs) {
            this.ioHeuristicsTimeToLiveInMs = aIoHeuristicsTimeToLiveInMs;
            return this;
        }

        public TransmissionMetrics build() {
            return new TransmissionMetrics(this);
        }
    }
}

