/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import org.refcodes.mixin.ChildrenAccessor;
import org.refcodes.schema.Schema;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.Transmission;
import org.refcodes.struct.MapSimpleTypeTable;
import org.refcodes.struct.SimpleTypeTable;

public interface TransmissionComposite<CHILD extends Transmission>
extends Transmission,
ChildrenAccessor<CHILD[]> {
    @Override
    default public Sequence toSequence() {
        ByteArraySequence theSequence = new ByteArraySequence();
        if (this.getChildren() != null) {
            for (int i = 0; i < ((Transmission[])this.getChildren()).length; ++i) {
                Transmission eChild = ((Transmission[])this.getChildren())[i];
                Sequence eTransmission = eChild.toSequence();
                theSequence.append(eTransmission);
            }
        }
        return theSequence;
    }

    @Override
    default public SimpleTypeTable toSimpleTypeTable() {
        MapSimpleTypeTable theBuilder = new MapSimpleTypeTable();
        if (this.getChildren() != null && ((Transmission[])this.getChildren()).length != 0) {
            for (int i = 0; i < ((Transmission[])this.getChildren()).length; ++i) {
                theBuilder.insert(((Transmission[])this.getChildren())[i].toSimpleTypeTable());
            }
        }
        return theBuilder;
    }

    @Override
    default public SerialSchema toSchema() {
        Schema[] theSchemas = null;
        if (this.getChildren() != null && ((Transmission[])this.getChildren()).length != 0) {
            theSchemas = new SerialSchema[((Transmission[])this.getChildren()).length];
            for (int i = 0; i < theSchemas.length; ++i) {
                theSchemas[i] = ((Transmission[])this.getChildren())[i].toSchema();
            }
        }
        return SerialSchema.builder().withInstance(this).withValue(this.toSequence()).withLength(this.getLength()).withDescription("A parent segment containing child elements.").withChildren(theSchemas).build();
    }

    @Override
    default public int getLength() {
        int theLength = 0;
        if (this.getChildren() != null) {
            for (int i = 0; i < ((Transmission[])this.getChildren()).length; ++i) {
                theLength += ((Transmission[])this.getChildren())[i].getLength();
            }
        }
        return theLength;
    }
}

