/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import org.refcodes.component.LinkComponent;
import org.refcodes.io.BytesTransmitter;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.Segment;
import org.refcodes.serial.SegmentTransmitter;
import org.refcodes.serial.Sequence;

public interface SerialTransmitter
extends BytesTransmitter,
SegmentTransmitter,
LinkComponent.LinkAutomaton {
    @Override
    default public void transmitBytes(byte[] aBytes) throws IOException {
        this.transmitSequence(new ByteArraySequence(aBytes));
    }

    @Override
    default public void transmitBytes(byte[] aBytes, int aOffset, int aLength) throws IOException {
        this.transmitSequence(new ByteArraySequence(aBytes, aOffset, aLength));
    }

    default public void transmitSequence(Sequence aSequence, int aOffset, int aLength) throws IOException {
        if (aOffset == 0 && aLength == aSequence.getLength()) {
            this.transmitSequence(aSequence);
        } else {
            this.transmitBytes(aSequence.toBytes(aOffset, aLength));
        }
    }

    public void transmitSequence(Sequence var1) throws IOException;

    @Override
    default public <SEGMENT extends Segment> void transmitSegment(SEGMENT aSegment) throws IOException {
        aSegment.transmitTo(this.getOutputStream(), null);
    }

    @Override
    default public void flush() throws IOException {
    }
}

