/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import org.refcodes.factory.TypeFactory;
import org.refcodes.serial.AbstractArrayTransmission;
import org.refcodes.serial.ArraySection;
import org.refcodes.serial.Section;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.Transmission;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionSequenceException;

public class SegmentArraySection<ARRAY extends Segment>
extends AbstractArrayTransmission<ARRAY>
implements Section,
ArraySection<ARRAY> {
    private static final long serialVersionUID = 1L;

    public SegmentArraySection(Class<ARRAY> aSegmentClass) {
        super(aSegmentClass);
    }

    public SegmentArraySection(Collection<ARRAY> aSegments) {
        super(aSegments);
    }

    @SafeVarargs
    public SegmentArraySection(ARRAY ... aSegments) {
        super(aSegments);
    }

    public SegmentArraySection(String aAlias, Class<ARRAY> aSegmentClass) {
        super(aAlias, aSegmentClass);
    }

    public SegmentArraySection(String aAlias, Collection<ARRAY> aSegments) {
        super(aAlias, aSegments);
    }

    @SafeVarargs
    public SegmentArraySection(String aAlias, ARRAY ... aSegments) {
        super(aAlias, aSegments);
    }

    public SegmentArraySection(String aAlias, TypeFactory<ARRAY> aSegmentFactory, Collection<ARRAY> aSegments) {
        super(aAlias, aSegmentFactory, aSegments);
    }

    @SafeVarargs
    public SegmentArraySection(String aAlias, TypeFactory<ARRAY> aSegmentFactory, ARRAY ... aSegments) {
        super(aAlias, aSegmentFactory, aSegments);
    }

    public SegmentArraySection(String aAlias, TypeFactory<ARRAY> aSegmentFactory) {
        super(aAlias, aSegmentFactory);
    }

    public SegmentArraySection(TypeFactory<ARRAY> aSegmentFactory, Collection<ARRAY> aSegments) {
        super(aSegmentFactory, aSegments);
    }

    @SafeVarargs
    public SegmentArraySection(TypeFactory<ARRAY> aSegmentFactory, ARRAY ... aSegments) {
        super(aSegmentFactory, aSegments);
    }

    public SegmentArraySection(TypeFactory<ARRAY> aSegmentFactory) {
        super(aSegmentFactory);
    }

    @Override
    public SegmentArraySection<ARRAY> withArray(ARRAY[] aValue) {
        this.setArray(aValue);
        return this;
    }

    @Override
    public void fromTransmission(Sequence aSequence, int aOffset, int aLength) throws TransmissionException {
        if (aLength != 0) {
            int theOffset;
            Segment eSegment;
            ArrayList<Segment> theSegments = new ArrayList<Segment>();
            for (theOffset = aOffset; theOffset < aOffset + aLength; theOffset += eSegment.getLength()) {
                eSegment = (Segment)this._sequenceableFactory.create();
                eSegment.fromTransmission(aSequence, theOffset);
                theSegments.add(eSegment);
            }
            if (theOffset - aOffset != aLength) {
                throw new TransmissionSequenceException(aSequence, "The sequence with length <" + aLength + "> at the offset <" + aOffset + "> results in <" + (theOffset - aOffset) + "> bytes consumed, which is not the expected length <" + aLength + ">!");
            }
            this._array = theSegments.size() != 0 ? (Transmission[])theSegments.toArray((Segment[])Array.newInstance(((Segment)theSegments.get(0)).getClass(), theSegments.size())) : (Transmission[])theSegments.toArray((Segment[])Array.newInstance(this._sequenceableFactory.getType(), 0));
        }
    }
}

