/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.refcodes.data.Ascii;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.MagicBytesAccessor;

public enum MagicBytes implements MagicBytesAccessor
{
    ACKNOWLEDGE(Ascii.ACK.getCode()),
    CLEAR_TO_SEND(Ascii.ACK.getCode()),
    LAST_PACKET(Ascii.ETX.getCode()),
    PACKET(Ascii.STX.getCode()),
    READY_TO_RECEIVE(Ascii.ENQ.getCode()),
    READY_TO_SEND(Ascii.ENQ.getCode()),
    TRANSMISSION(Ascii.NULL.getCode()),
    REQUEST(Ascii.ENQ.getCode()),
    RESPONSE(Ascii.EOT.getCode()),
    RESPONSE_ACKNOWLEDGE(Ascii.EM.getCode()),
    ACKNOWLEDGEABLE_TRANSMISSION(Ascii.SYN.getCode()),
    ACKNOWLEDGEABLE_REQUEST(Ascii.STX.getCode()),
    ACKNOWLEDGEABLE_RESPONSE(Ascii.ETX.getCode()),
    TRANSMISSION_DISMISSED(Ascii.NAK.getCode()),
    REQUEST_DISMISSED(Ascii.CAN.getCode()),
    PING("?"),
    PONG("!");

    private byte[] _magicBytes;

    private MagicBytes(byte ... aMagicBytes) {
        this._magicBytes = aMagicBytes;
    }

    private MagicBytes(String aMagicBytes) {
        this._magicBytes = aMagicBytes.getBytes(StandardCharsets.US_ASCII);
    }

    private MagicBytes(String aMagicBytes, Charset aCharset) {
        this._magicBytes = aMagicBytes.getBytes(aCharset);
    }

    @Override
    public byte[] getMagicBytes() {
        return this._magicBytes;
    }

    public static byte[] toMagicBytes(MagicBytes ... aMagicBytes) {
        ByteArraySequence theMagicBytes = new ByteArraySequence();
        for (MagicBytes eMagicBytes : aMagicBytes) {
            theMagicBytes.append(eMagicBytes.getMagicBytes());
        }
        return theMagicBytes.toBytes();
    }
}

