/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.refcodes.io.BijectiveOutputStream;
import org.refcodes.io.InverseInputStream;
import org.refcodes.numerical.BijectiveFunction;
import org.refcodes.numerical.InverseFunction;
import org.refcodes.numerical.Invertible;
import org.refcodes.serial.AbstractInvertibleTransmissionDecorator;
import org.refcodes.serial.Section;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SequenceInputStream;
import org.refcodes.serial.TransmissionException;

public class InvertibleSectionDecorator<DECORATEE extends Section>
extends AbstractInvertibleTransmissionDecorator<DECORATEE>
implements Section {
    private static final long serialVersionUID = 1L;

    public InvertibleSectionDecorator(DECORATEE aDecoratee, BijectiveFunction<Byte, Byte> aBijectiveFunction, InverseFunction<Byte, Byte> aInverseFunction) {
        super(aDecoratee, aBijectiveFunction, aInverseFunction);
    }

    public InvertibleSectionDecorator(DECORATEE aDecoratee, Invertible<Byte, Byte> aInvertible) {
        super(aDecoratee, aInvertible);
    }

    @Override
    public void fromTransmission(Sequence aSequence, int aOffset, int aLength) throws TransmissionException {
        SequenceInputStream theSequenceInputStream = new SequenceInputStream(aSequence, aOffset);
        try {
            this.receiveFrom(theSequenceInputStream, aLength, null);
        }
        catch (IOException e) {
            throw new TransmissionException("Cannot receive transmission for sequence <" + aSequence.toHexString() + "> at offset <" + aOffset + "> with length <" + aLength + ">!", e);
        }
        if (aLength + aOffset != theSequenceInputStream.getOffset()) {
            throw new TransmissionException("The number of bytes <" + aLength + "> to be read at offset <" + aOffset + "> from the sequence <" + aSequence.toHexString() + "> is exceeded by the actual number of bytes read <" + (theSequenceInputStream.getOffset() - aOffset) + ">!");
        }
    }

    @Override
    public void receiveFrom(InputStream aInputStream, int aLength, OutputStream aReturnStream) throws IOException {
        InverseInputStream theInverseInputStream = new InverseInputStream(aInputStream, this._inverseFunction);
        BijectiveOutputStream theBijectiveReturnStream = aReturnStream != null ? new BijectiveOutputStream(aReturnStream, this._bijectiveFunction) : null;
        ((Section)this._decoratee).receiveFrom(theInverseInputStream, aLength, theBijectiveReturnStream);
    }
}

