/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import org.refcodes.numerical.Endianess;
import org.refcodes.serial.AbstractPayloadSegment;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.textual.CaseStyleBuilder;

public class IntSegment
extends AbstractPayloadSegment<Integer>
implements Segment {
    private static final long serialVersionUID = 1L;
    public static final String ENDIANESS = "ENDIANESS";
    public static final int BYTES = 4;
    private Endianess _endianess;

    public IntSegment(TransmissionMetrics aTransmissionMetrics) {
        this(aTransmissionMetrics.getEndianess());
    }

    public IntSegment(Integer aValue, TransmissionMetrics aTransmissionMetrics) {
        this(aValue, aTransmissionMetrics.getEndianess());
    }

    public IntSegment(String aAlias, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, aTransmissionMetrics.getEndianess());
    }

    public IntSegment(String aAlias, Integer aValue, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, aValue, aTransmissionMetrics.getEndianess());
    }

    public IntSegment() {
        this(CaseStyleBuilder.asCamelCase(IntSegment.class.getSimpleName()));
    }

    public IntSegment(Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase(IntSegment.class.getSimpleName()), aEndianess);
    }

    public IntSegment(Integer aValue) {
        this(CaseStyleBuilder.asCamelCase(IntSegment.class.getSimpleName()), aValue);
    }

    public IntSegment(Integer aValue, Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase(IntSegment.class.getSimpleName()), aValue, aEndianess);
    }

    public IntSegment(String aAlias) {
        this(aAlias, (Integer)0, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public IntSegment(String aAlias, Endianess aEndianess) {
        this(aAlias, (Integer)0, aEndianess);
    }

    public IntSegment(String aAlias, Integer aValue) {
        this(aAlias, aValue, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public IntSegment(String aAlias, Integer aValue, Endianess aEndianess) {
        super(aAlias, aValue);
        this._endianess = aEndianess;
    }

    @Override
    public Sequence toSequence() {
        return new ByteArraySequence(this._endianess.toBytes((Integer)this.getPayload(), 4));
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        byte[] theRecord = aSequence.toBytes(aOffset, 4);
        this.setPayload(this._endianess.toInteger(theRecord));
        return aOffset + 4;
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public void reset() {
        this._payload = 0;
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema theSchema = SerialSchema.builder().withAlias(this.getAlias()).withInstance(this).withValue(this.toSequence()).withLength(this.getLength()).withVerbose(Integer.toString((Integer)this.getPayload())).withDescription("A body containing an integer payload.").build();
        theSchema.put(ENDIANESS, this._endianess);
        return theSchema;
    }

    @Override
    public IntSegment withPayload(Integer aValue) {
        this.setPayload(aValue);
        return this;
    }
}

