/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.util.Arrays;
import org.refcodes.numerical.Endianess;
import org.refcodes.serial.AbstractPayloadSection;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.serial.TransmissionSequenceException;
import org.refcodes.textual.CaseStyleBuilder;

public class FloatArraySection
extends AbstractPayloadSection<float[]> {
    private static final long serialVersionUID = 1L;
    public static final String ENDIANESS = "ENDIANESS";
    private Endianess _endianess;

    public FloatArraySection(TransmissionMetrics aTransmissionMetrics) {
        this(aTransmissionMetrics.getEndianess());
    }

    public FloatArraySection(TransmissionMetrics aTransmissionMetrics, float ... aValue) {
        this(aTransmissionMetrics.getEndianess(), aValue);
    }

    public FloatArraySection(TransmissionMetrics aTransmissionMetrics, Float ... aValue) {
        this(aTransmissionMetrics.getEndianess(), aValue);
    }

    public FloatArraySection(String aAlias, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, aTransmissionMetrics.getEndianess());
    }

    public FloatArraySection(String aAlias, TransmissionMetrics aTransmissionMetrics, float ... aValue) {
        this(aAlias, aTransmissionMetrics.getEndianess(), aValue);
    }

    public FloatArraySection(String aAlias, TransmissionMetrics aTransmissionMetrics, Float ... aValue) {
        this(aAlias, aTransmissionMetrics.getEndianess(), aValue);
    }

    public FloatArraySection() {
        this(CaseStyleBuilder.asCamelCase(FloatArraySection.class.getSimpleName()));
    }

    public FloatArraySection(Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase(FloatArraySection.class.getSimpleName()), aEndianess);
    }

    public FloatArraySection(float ... aValue) {
        this(CaseStyleBuilder.asCamelCase(FloatArraySection.class.getSimpleName()), aValue);
    }

    public FloatArraySection(Float ... aValue) {
        this(CaseStyleBuilder.asCamelCase(FloatArraySection.class.getSimpleName()), aValue);
    }

    public FloatArraySection(Endianess aEndianess, float ... aValue) {
        this(CaseStyleBuilder.asCamelCase(FloatArraySection.class.getSimpleName()), aEndianess, aValue);
    }

    public FloatArraySection(Endianess aEndianess, Float ... aValue) {
        this(CaseStyleBuilder.asCamelCase(FloatArraySection.class.getSimpleName()), aEndianess, FloatArraySection.toPrimitiveArray(aValue));
    }

    public FloatArraySection(String aAlias) {
        this(aAlias, TransmissionMetrics.DEFAULT_ENDIANESS, new float[0]);
    }

    public FloatArraySection(String aAlias, Endianess aEndianess) {
        this(aAlias, aEndianess, new float[0]);
    }

    public FloatArraySection(String aAlias, float ... aValue) {
        this(aAlias, TransmissionMetrics.DEFAULT_ENDIANESS, aValue);
    }

    public FloatArraySection(String aAlias, Float ... aValue) {
        this(aAlias, TransmissionMetrics.DEFAULT_ENDIANESS, aValue);
    }

    public FloatArraySection(String aAlias, Endianess aEndianess, float ... aValue) {
        super(aAlias, aValue);
        this._endianess = aEndianess;
    }

    public FloatArraySection(String aAlias, Endianess aEndianess, Float ... aValue) {
        super(aAlias, FloatArraySection.toPrimitiveArray(aValue));
        this._endianess = aEndianess;
    }

    @Override
    public Sequence toSequence() {
        byte[] theBytes = new byte[((float[])this.getPayload()).length * 4];
        for (int i = 0; i < ((float[])this.getPayload()).length; ++i) {
            byte[] eRecord = this._endianess.toBytes(((float[])this.getPayload())[i]);
            for (int j = 0; j < eRecord.length; ++j) {
                theBytes[i * 4 + j] = eRecord[j];
            }
        }
        return new ByteArraySequence(theBytes);
    }

    @Override
    public void fromTransmission(Sequence aSequence, int aOffset, int aLength) throws TransmissionException {
        if (aLength % 4 != 0) {
            throw new TransmissionSequenceException(aSequence, "The length dedicated <" + aLength + "> does not match a multiple float length <4> for retrieving an float array from the given sequence at the offset <" + aOffset + ">!");
        }
        float[] theValues = new float[aLength / 4];
        for (int i = 0; i < theValues.length; ++i) {
            byte[] eRecord = aSequence.toBytes(aOffset + i * 4, 4);
            theValues[i] = this._endianess.toFloat(eRecord);
        }
        this.setPayload(theValues);
    }

    @Override
    public int getLength() {
        return this.getPayload() != null ? ((float[])this.getPayload()).length * 4 : 0;
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema theSchema = SerialSchema.builder().withAlias(this.getAlias()).withInstance(this).withValue(this.toSequence()).withLength(this.getLength()).withDescription("A body containing an float payload.").build();
        theSchema.put(ENDIANESS, this._endianess);
        return theSchema;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [alias=" + this._alias + ", value=" + Arrays.toString((float[])this.getPayload()) + "]";
    }

    @Override
    public FloatArraySection withPayload(float[] aValue) {
        this.setPayload(aValue);
        return this;
    }

    @Override
    public void setPayload(Float[] aPayload) {
        this.setPayload(FloatArraySection.toPrimitiveArray(aPayload));
    }

    @Override
    public FloatArraySection withPayload(Float[] aPayload) {
        this.setPayload(FloatArraySection.toPrimitiveArray(aPayload));
        return this;
    }

    private static float[] toPrimitiveArray(Float[] aPayload) {
        float[] theResult = new float[aPayload.length];
        for (int i = 0; i < theResult.length; ++i) {
            theResult[i] = aPayload[i].floatValue();
        }
        return theResult;
    }
}

