/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import org.refcodes.numerical.Endianess;
import org.refcodes.serial.AbstractPayloadSegment;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.textual.CaseStyleBuilder;

public class DoubleSegment
extends AbstractPayloadSegment<Double>
implements Segment {
    private static final long serialVersionUID = 1L;
    public static final String ENDIANESS = "ENDIANESS";
    public static final int BYTES = 8;
    private Endianess _endianess;

    public DoubleSegment(TransmissionMetrics aTransmissionMetrics) {
        this(aTransmissionMetrics.getEndianess());
    }

    public DoubleSegment(Double aValue, TransmissionMetrics aTransmissionMetrics) {
        this(aValue, aTransmissionMetrics.getEndianess());
    }

    public DoubleSegment(String aAlias, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, aTransmissionMetrics.getEndianess());
    }

    public DoubleSegment(String aAlias, Double aValue, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, aValue, aTransmissionMetrics.getEndianess());
    }

    public DoubleSegment() {
        this(CaseStyleBuilder.asCamelCase(DoubleSegment.class.getSimpleName()), 0.0);
    }

    public DoubleSegment(Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase(DoubleSegment.class.getSimpleName()), (Double)0.0, aEndianess);
    }

    public DoubleSegment(Double aValue) {
        this(CaseStyleBuilder.asCamelCase(DoubleSegment.class.getSimpleName()), aValue);
    }

    public DoubleSegment(Double aValue, Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase(DoubleSegment.class.getSimpleName()), aValue, aEndianess);
    }

    public DoubleSegment(String aAlias) {
        this(aAlias, (Double)0.0, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public DoubleSegment(String aAlias, Endianess aEndianess) {
        this(aAlias, (Double)0.0, aEndianess);
    }

    public DoubleSegment(String aAlias, Double aValue) {
        this(aAlias, aValue, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public DoubleSegment(String aAlias, Double aValue, Endianess aEndianess) {
        super(aAlias, aValue);
        this._endianess = aEndianess;
    }

    @Override
    public Sequence toSequence() {
        return new ByteArraySequence(this._endianess.toBytes((Double)this.getPayload()));
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        byte[] theRecord = aSequence.toBytes(aOffset, 8);
        this.setPayload(this._endianess.toDouble(theRecord));
        return aOffset + 8;
    }

    @Override
    public int getLength() {
        return 8;
    }

    @Override
    public void reset() {
        this._payload = 0.0;
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema theSchema = SerialSchema.builder().withAlias(this.getAlias()).withInstance(this).withValue(this.toSequence()).withLength(this.getLength()).withVerbose(Double.toString((Double)this.getPayload())).withDescription("A body containing an double payload.").build();
        theSchema.put(ENDIANESS, this._endianess);
        return theSchema;
    }

    @Override
    public DoubleSegment withPayload(Double aValue) {
        this.setPayload(aValue);
        return this;
    }
}

