/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.refcodes.exception.UnhandledEnumBugException;
import org.refcodes.mixin.ConcatenateMode;
import org.refcodes.numerical.ChecksumValidationMode;
import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.Endianess;
import org.refcodes.serial.AbstractCrcTransmissionDecorator;
import org.refcodes.serial.BadCrcChecksumException;
import org.refcodes.serial.BadCrcChecksumSequenceException;
import org.refcodes.serial.DecoratorSection;
import org.refcodes.serial.Section;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;

public class CrcSectionDecorator<DECORATEE extends Section>
extends AbstractCrcTransmissionDecorator<DECORATEE>
implements DecoratorSection<DECORATEE> {
    private static final long serialVersionUID = 1L;

    public CrcSectionDecorator(DECORATEE aDecoratee, TransmissionMetrics aTransmissionMetrics) {
        super(aDecoratee, aTransmissionMetrics);
    }

    public CrcSectionDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm) {
        super(aDecoratee, aCrcAlgorithm);
    }

    public CrcSectionDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm, ChecksumValidationMode aChecksumValidationMode) {
        super(aDecoratee, aCrcAlgorithm, aChecksumValidationMode);
    }

    public CrcSectionDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm, Endianess aEndianess) {
        super(aDecoratee, aCrcAlgorithm);
    }

    public CrcSectionDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm, ChecksumValidationMode aChecksumValidationMode, Endianess aEndianess) {
        super(aDecoratee, aCrcAlgorithm, aChecksumValidationMode, aEndianess);
    }

    public CrcSectionDecorator(DECORATEE aDecoratee, ConcatenateMode aCrcChecksumConcatenateMode) {
        super(aDecoratee, aCrcChecksumConcatenateMode);
    }

    public CrcSectionDecorator(DECORATEE aDecoratee, ConcatenateMode aCrcChecksumConcatenateMode, Endianess aEndianess) {
        super(aDecoratee, aCrcChecksumConcatenateMode, aEndianess);
    }

    public CrcSectionDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode) {
        super(aDecoratee, aCrcAlgorithm, aCrcChecksumConcatenateMode);
    }

    public CrcSectionDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode, ChecksumValidationMode aChecksumValidationMode) {
        super(aDecoratee, aCrcAlgorithm, aCrcChecksumConcatenateMode, aChecksumValidationMode);
    }

    public CrcSectionDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode, Endianess aEndianess) {
        super(aDecoratee, aCrcAlgorithm, aCrcChecksumConcatenateMode, aEndianess);
    }

    public CrcSectionDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode, ChecksumValidationMode aChecksumValidationMode, Endianess aEndianess) {
        super(aDecoratee, aCrcAlgorithm, aCrcChecksumConcatenateMode, aChecksumValidationMode, aEndianess);
    }

    @Override
    public void fromTransmission(Sequence aSequence, int aOffset, int aLength) throws TransmissionException {
        long theCrcChecksum;
        switch (this._crcChecksumConcatenateMode) {
            case PREPEND: {
                byte[] theBytes = aSequence.toBytes(aOffset, this._crcAlgorithm.getCrcWidth());
                ((Section)this._decoratee).fromTransmission(aSequence, aOffset += this._crcAlgorithm.getCrcWidth(), aLength -= this._crcAlgorithm.getCrcWidth());
                this._crcChecksum = this.getEndianess().toUnsignedLong(theBytes);
                break;
            }
            case APPEND: {
                ((Section)this._decoratee).fromTransmission(aSequence, aOffset, aLength -= this._crcAlgorithm.getCrcWidth());
                byte[] theBytes = aSequence.toBytes(aOffset += aLength, this._crcAlgorithm.getCrcWidth());
                this._crcChecksum = this.getEndianess().toUnsignedLong(theBytes);
                break;
            }
            default: {
                throw new UnhandledEnumBugException(this._crcChecksumConcatenateMode);
            }
        }
        if (this._checksumValidationMode == ChecksumValidationMode.ENFORCE_VALID_CHECKSUM && (theCrcChecksum = ((Section)this._decoratee).toSequence().toCrcChecksum(this._crcAlgorithm)) != this._crcChecksum) {
            throw new BadCrcChecksumSequenceException(this._crcChecksum, theCrcChecksum, aSequence, "The CRC checksum <" + this._crcChecksum + "> at offset <" + aOffset + "> does not match the calculated CRC checksum <" + theCrcChecksum + ">.");
        }
    }

    @Override
    public void receiveFrom(InputStream aInputStream, int aLength, OutputStream aReturnStream) throws IOException {
        long theCrcChecksum;
        byte[] theBytes = new byte[this._crcAlgorithm.getCrcWidth()];
        switch (this._crcChecksumConcatenateMode) {
            case PREPEND: {
                aInputStream.read(theBytes, 0, this._crcAlgorithm.getCrcWidth());
                ((Section)this._decoratee).receiveFrom(aInputStream, aLength -= this._crcAlgorithm.getCrcWidth(), aReturnStream);
                this._crcChecksum = this.getEndianess().toUnsignedLong(theBytes);
                break;
            }
            case APPEND: {
                ((Section)this._decoratee).receiveFrom(aInputStream, aLength -= this._crcAlgorithm.getCrcWidth(), aReturnStream);
                aInputStream.read(theBytes, 0, this._crcAlgorithm.getCrcWidth());
                this._crcChecksum = this.getEndianess().toUnsignedLong(theBytes);
                break;
            }
            default: {
                throw new UnhandledEnumBugException(this._crcChecksumConcatenateMode);
            }
        }
        if (this._checksumValidationMode == ChecksumValidationMode.ENFORCE_VALID_CHECKSUM && (theCrcChecksum = ((Section)this._decoratee).toSequence().toCrcChecksum(this._crcAlgorithm)) != this._crcChecksum) {
            throw new BadCrcChecksumException(this._crcChecksum, theCrcChecksum, "The CRC checksum <" + this._crcChecksum + "> at offset <0> does not match the calculated CRC checksum <" + theCrcChecksum + ">.");
        }
    }
}

