/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.refcodes.io.BoundedInputStream;
import org.refcodes.mixin.ConcatenateMode;
import org.refcodes.mixin.LengthAccessor;
import org.refcodes.mixin.TruncateMode;
import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.Endianess;
import org.refcodes.serial.Sequence;
import org.refcodes.struct.BoundedIterator;

public class BoundedSequenceDecorator
implements Sequence,
LengthAccessor.LengthProperty {
    private final Sequence _sequence;
    private int _lengthBounds = -1;

    public BoundedSequenceDecorator(Sequence aSequence, int aLengthBounds) {
        this._sequence = aSequence;
        this._lengthBounds = aLengthBounds;
    }

    public BoundedSequenceDecorator(Sequence aSequence) {
        this._sequence = aSequence;
    }

    @Override
    public int getLength() {
        return this._lengthBounds == -1 ? this._sequence.getLength() : (this._lengthBounds < this._sequence.getLength() ? this._lengthBounds : this._sequence.getLength());
    }

    @Override
    public void setLength(int aLength) {
        this._lengthBounds = aLength;
    }

    @Override
    public Iterator<Byte> iterator() {
        return new BoundedIterator<Byte>(this._sequence.iterator(), this._lengthBounds);
    }

    @Override
    public void forEach(Consumer<? super Byte> aAction) {
        Iterator<Byte> e = this.iterator();
        while (e.hasNext()) {
            aAction.accept(e.next());
        }
    }

    @Override
    public void append(byte ... aBytes) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public void append(byte[] aBytes, int aOffset, int aLength) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public Spliterator<Byte> spliterator() {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public void append(Sequence aSequence) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public void clear(byte aValue) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public void concatenate(ConcatenateMode aConcatenateMode, byte ... aBytes) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public void concatenate(ConcatenateMode aConcatenateMode, byte[] aBytes, int aOffset, int aLength) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public void concatenate(Sequence aSequence, ConcatenateMode aConcatenateMode) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public void empty() {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public byte getByteAt(int aIndex) {
        if (aIndex >= this._lengthBounds) {
            throw new IndexOutOfBoundsException(aIndex);
        }
        return this._sequence.getByteAt(aIndex);
    }

    @Override
    public InputStream getInputStream() {
        return new BoundedInputStream(this._sequence.getInputStream(), this._lengthBounds);
    }

    @Override
    public OutputStream getOutputStream() {
        return this._sequence.getOutputStream();
    }

    @Override
    public void overwrite(byte[] aBytes) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public void overwrite(byte[] aBytes, int aLength) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public void overwrite(int aOffset, byte[] aBytes) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public void overwrite(int aOffset, byte[] aBytes, int aBytesOffset, int aLength) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public void overwrite(int aOffset, Sequence aSequence) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public void overwrite(int aOffset, Sequence aSequence, int aSequenceOffset, int aLength) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public void overwrite(Sequence aSequence) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public void overwrite(Sequence aSequence, int aLength) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public void prepend(byte ... aBytes) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public void prepend(byte[] aBytes, int aOffset, int aLength) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public void prepend(Sequence aSequence) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public void replace(byte[] aBytes) {
        if (aBytes.length > this._lengthBounds) {
            throw new IndexOutOfBoundsException(this._lengthBounds);
        }
        this._sequence.replace(aBytes);
    }

    @Override
    public void replace(byte[] aBytes, int aLength) {
        if (aLength > this._lengthBounds) {
            throw new IndexOutOfBoundsException(this._lengthBounds);
        }
        this._sequence.replace(aBytes, aLength);
    }

    @Override
    public void replace(byte[] aBytes, int aOffset, int aLength) {
        if (aOffset + aLength > this._lengthBounds) {
            throw new IndexOutOfBoundsException(this._lengthBounds);
        }
        this._sequence.replace(aBytes, aOffset, aLength);
    }

    @Override
    public void replace(Sequence aSequence) {
        if (aSequence.getLength() > this._lengthBounds) {
            throw new IndexOutOfBoundsException(this._lengthBounds);
        }
        this._sequence.replace(aSequence);
    }

    @Override
    public void replace(Sequence aSequence, int aLength) {
        if (aLength > this._lengthBounds) {
            throw new IndexOutOfBoundsException(this._lengthBounds);
        }
        this._sequence.replace(aSequence, aLength);
    }

    @Override
    public void replace(Sequence aSequence, int aOffset, int aLength) {
        if (aOffset + aLength > this._lengthBounds) {
            throw new IndexOutOfBoundsException(this._lengthBounds);
        }
        this._sequence.replace(aSequence, aOffset, aLength);
    }

    @Override
    public void setByteAt(int aIndex, byte aByte) {
        if (aIndex >= this._lengthBounds) {
            throw new IndexOutOfBoundsException(aIndex);
        }
        this._sequence.setByteAt(aIndex, aByte);
    }

    @Override
    public Sequence toAppend(byte ... aBytes) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public Sequence toAppend(byte[] aBytes, int aOffset, int aLength) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public Sequence toAppend(Sequence aSequence) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public byte[] toBytes() {
        return this._sequence.toBytes(0, this._sequence.getLength() < this._lengthBounds ? this._sequence.getLength() : this._lengthBounds);
    }

    @Override
    public byte[] toBytes(int aOffset, int aLength) {
        if (aOffset + aLength >= this._lengthBounds) {
            throw new IndexOutOfBoundsException(this._lengthBounds);
        }
        return this._sequence.toBytes(aOffset, aLength);
    }

    @Override
    public void toBytes(int aOffset, int aLength, byte[] aBytes, int aBytesOffset) {
        if (aOffset + aLength >= this._lengthBounds) {
            throw new IndexOutOfBoundsException(this._lengthBounds);
        }
        this._sequence.toBytes(aOffset, aLength, aBytes, aBytesOffset);
    }

    @Override
    public Sequence toClone() {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public Sequence toConcatenate(ConcatenateMode aConcatenateMode, byte ... aBytes) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public Sequence toConcatenate(ConcatenateMode aConcatenateMode, byte[] aBytes, int aOffset, int aLength) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public Sequence toConcatenate(Sequence aSequence, ConcatenateMode aConcatenateMode) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public byte[] toCrcBytes(CrcAlgorithm aCrcAlgorithm, Endianess aEndianess) {
        long theChecksum = 0L;
        for (int i = 0; i < this.getLength(); ++i) {
            theChecksum = aCrcAlgorithm.toCrcChecksum(theChecksum, this.getByteAt(i));
        }
        return aEndianess.toBytes(theChecksum, aCrcAlgorithm.getCrcWidth());
    }

    @Override
    public byte[] toCrcBytes(long aCrcChecksum, CrcAlgorithm aCrcAlgorithm, Endianess aEndianess) {
        for (int i = 0; i < this.getLength(); ++i) {
            aCrcChecksum = aCrcAlgorithm.toCrcChecksum(aCrcChecksum, this.getByteAt(i));
        }
        return aEndianess.toBytes(aCrcChecksum, aCrcAlgorithm.getCrcWidth());
    }

    @Override
    public long toCrcChecksum(CrcAlgorithm aCrcAlgorithm) {
        long theChecksum = 0L;
        for (int i = 0; i < this.getLength(); ++i) {
            theChecksum = aCrcAlgorithm.toCrcChecksum(theChecksum, this.getByteAt(i));
        }
        return theChecksum;
    }

    @Override
    public long toCrcChecksum(long aCrcChecksum, CrcAlgorithm aCrcAlgorithm) {
        for (int i = 0; i < this.getLength(); ++i) {
            aCrcChecksum = aCrcAlgorithm.toCrcChecksum(aCrcChecksum, this.getByteAt(i));
        }
        return aCrcChecksum;
    }

    @Override
    public InputStream toInputStream() {
        return new BoundedInputStream(this._sequence.toInputStream(), this._lengthBounds);
    }

    @Override
    public Sequence toOverwrite(byte[] aBytes) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public Sequence toOverwrite(byte[] aBytes, int aLength) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public Sequence toOverwrite(int aOffset, byte[] aBytes) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public Sequence toOverwrite(int aOffset, byte[] aBytes, int aBytesOffset, int aLength) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public Sequence toOverwrite(int aOffset, Sequence aSequence) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public Sequence toOverwrite(int aOffset, Sequence aSequence, int aBytesOffset, int aLength) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public Sequence toOverwrite(Sequence aSequence) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public Sequence toOverwrite(Sequence aSequence, int aLength) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public Sequence toPrepend(byte ... aBytes) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public Sequence toPrepend(byte[] aBytes, int aOffset, int aLength) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public Sequence toPrepend(Sequence aSequence) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public Sequence toSequence(int aOffset, int aLength) {
        if (aOffset + aLength >= this._lengthBounds) {
            throw new IndexOutOfBoundsException(this._lengthBounds);
        }
        return this._sequence.toSequence(aOffset, aLength);
    }

    @Override
    public Sequence toTruncate(int aLength, TruncateMode aTruncateMode) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public Sequence toTruncateHead(int aLength) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public Sequence toTruncateTail(int aLength) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public void truncate(int aLength, TruncateMode aTruncateMode) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public void truncateHead(int aLength) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public void truncateTail(int aLength) {
        throw new UnsupportedOperationException("Bounding this operation is not supported by this implementation!");
    }

    @Override
    public Sequence withAppend(byte ... aBytes) {
        this.append(aBytes);
        return this;
    }

    @Override
    public Sequence withAppend(byte[] aBytes, int aOffset, int aLength) {
        this._sequence.append(aBytes, aOffset, aLength);
        return this;
    }

    @Override
    public Sequence withAppend(Sequence aSequence) {
        this.append(aSequence);
        return this;
    }

    @Override
    public Sequence withConcatenate(ConcatenateMode aConcatenateMode, byte ... aBytes) {
        this.concatenate(aConcatenateMode, aBytes);
        return this;
    }

    @Override
    public Sequence withConcatenate(Sequence aSequence, ConcatenateMode aConcatenateMode) {
        this.concatenate(aSequence, aConcatenateMode);
        return this;
    }

    @Override
    public Sequence withOverwrite(byte[] aBytes) {
        this.overwrite(aBytes);
        return this;
    }

    @Override
    public Sequence withOverwrite(byte[] aBytes, int aLength) {
        this.overwrite(aBytes, aLength);
        return this;
    }

    @Override
    public Sequence withOverwrite(int aOffset, byte[] aBytes) {
        this.overwrite(aOffset, aBytes);
        return this;
    }

    @Override
    public Sequence withOverwrite(int aOffset, byte[] aBytes, int aBytesOffset, int aLength) {
        this.overwrite(aOffset, aBytes, aBytesOffset, aLength);
        return this;
    }

    @Override
    public Sequence withOverwrite(int aOffset, Sequence aSequence) {
        this.overwrite(aOffset, aSequence);
        return this;
    }

    @Override
    public Sequence withOverwrite(int aOffset, Sequence aSequence, int aSequenceOffset, int aLength) {
        this.overwrite(aOffset, aSequence, aSequenceOffset, aLength);
        return this;
    }

    @Override
    public Sequence withOverwrite(Sequence aSequence) {
        this.overwrite(aSequence);
        return this;
    }

    @Override
    public Sequence withOverwrite(Sequence aSequence, int aLength) {
        this.overwrite(aSequence, aLength);
        return this;
    }

    @Override
    public Sequence withPrepend(byte ... aBytes) {
        this.prepend(aBytes);
        return this;
    }

    @Override
    public Sequence withPrepend(byte[] aBytes, int aOffset, int aLength) {
        this.prepend(aBytes, aOffset, aLength);
        return this;
    }

    @Override
    public Sequence withPrepend(Sequence aSequence) {
        this.prepend(aSequence);
        return this;
    }

    @Override
    public Sequence withReplace(byte[] aBytes) {
        this.replace(aBytes);
        return this;
    }

    @Override
    public Sequence withReplace(byte[] aBytes, int aLength) {
        this.replace(aBytes, aLength);
        return this;
    }

    @Override
    public Sequence withReplace(Sequence aSequence, int aLength) {
        this.replace(aSequence, aLength);
        return this;
    }

    @Override
    public Sequence withReplace(byte[] aBytes, int aOffset, int aLength) {
        this.replace(aBytes, aOffset, aLength);
        return this;
    }

    @Override
    public Sequence withReplace(Sequence aSequence) {
        this.replace(aSequence);
        return this;
    }

    @Override
    public Sequence withReplace(Sequence aSequence, int aOffset, int aLength) {
        this.replace(aSequence, aOffset, aLength);
        return this;
    }

    @Override
    public Sequence withTruncate(int aLength, TruncateMode aTruncateMode) {
        this.truncate(aLength, aTruncateMode);
        return this;
    }

    @Override
    public Sequence withTruncateHead(int aLength) {
        this.truncateHead(aLength);
        return this;
    }

    @Override
    public Sequence withTruncateTail(int aLength) {
        this.truncateTail(aLength);
        return this;
    }

    @Override
    public void writeTo(OutputStream aOutputStream) throws IOException {
        int theLength = this.getLength();
        for (int i = 0; i < theLength; ++i) {
            aOutputStream.write(this.getByteAt(i));
        }
    }
}

